# -*- encoding: utf-8 -*-
#
#   View Source - Epiphany Extension
#   Copyright © 2006, 2008  Diego Escalante Urrelo <diegoe@gnome.org>
#   Copyright © 2008  Wouter Bolsterlee <wbolster@gnome.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import epiphany
import gtk
import gettext

try:
    t = gettext.translation("epiphany")
    _ = t.ugettext
except Exception, e:
    _ = lambda x : x

_ui_str = """
<ui>
  <menubar>
    <menu name="ViewMenu" action="View">
      <menuitem name="ViewPageSourceMenu" action="ViewPageSource"/>
    </menu>
  </menubar>
</ui>
"""

def _view_source_cb(action, window):
    source_url = 'view-source:%s' % window.get_active_child().get_address()
    tab = epiphany.ephy_shell_get_default().new_tab(window, window.get_active_child(), 'about:blank', epiphany.NEW_TAB_IN_EXISTING_WINDOW)
    window.set_active_child(tab)
    window.load_url(source_url)    
    
_actions = [('ViewPageSource', 'stock_view-html-source', _('_Page Source'),
         '<control>U', None, _view_source_cb)]

def attach_window(window):
    ui_manager = window.get_ui_manager()
    group = gtk.ActionGroup('ViewPageSource')
    group.add_actions(_actions, window)
    ui_manager.insert_action_group(group, 0)
    ui_id = ui_manager.add_ui_from_string(_ui_str)

    window._sample_menu_entry_data = (group, ui_id)

def detach_window(window):
    group, ui_id = window._sample_menu_entry_data
    del window._sample_menu_entry_data

    ui_manager = window.get_ui_manager()
    ui_manager.remove_ui(ui_id)
    ui_manager.remove_action_group(group)
    ui_manager.ensure_update()
