#if HAVE_CONFIG_H
#  include <config.h>
#endif

#if !HAVE_RESIZE_WINDOW && HAVE_WRESIZE
#  define resize_window(w, l, c) (wresize((w), (l), (c)), (w))
#  define HAVE_RESIZE_WINDOW 1
#endif

#if !HAVE_INET_ATON
struct in_addr;
int inet_aton(const char *cp, struct in_addr *inp);
#endif

#if !HAVE_HERROR
void herror(const char *s);
#endif
#if !HAVE_HSTRERROR
const char *hstrerror(int err);
#endif

#if !HAVE_VSNPRINTF
#include <stdarg.h>
#include <stddef.h>
int vsnprintf(char *str, size_t size, const char *format, va_list ap);
#endif

#if !HAVE_SNPRINTF
#include <stdarg.h>
#include <stddef.h>
int snprintf(char *str, size_t size, const char *format, ...);
#endif
