/*
 * screenshot_list.h - declaration of screenshot-list for side-bar
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _SCREENSHOT_LIST_H
#define _SCREENSHOT_LIST_H

#include <qwidget.h>

#include "side_bar_widget.h"
#include "paths.h"


class QVBox;
class QLabel;
class QPushButton;
class QListBox;


const QString SCREENSHOT_PATH = "/" + QString( ITALC_CONFIG_PATH ) + "/screenshots/";


class screenshotList : public sideBarWidget
{
	Q_OBJECT
public:
	screenshotList( QWidget * _parent );
	virtual ~screenshotList();


public slots:
	void reloadList( void );



private slots:
	void screenshotSelected( const QString & _s );
	void screenshotDoubleClicked( const QString & _s );
	void showScreenshot( void );
	void deleteScreenshot( void );


private:
	QListBox * m_list;
	QLabel * m_preview;
	QLabel * m_user;
	QLabel * m_date;
	QLabel * m_time;
	QLabel * m_client;
	QPushButton * m_showBtn;
	QPushButton * m_deleteBtn;
	QPushButton * m_reloadBtn;
} ;


#endif
