/*
 * client_properties_edit.cpp - implementation of dialog for editing properties of a client
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qregexp.h>
#include <qmessagebox.h>

#include "client_properties_edit.h"
#include "client.h"
#include "client_manager.h"
#include "embed.h"

#include "client_properties_edit.moc"


clientPropertiesEdit::clientPropertiesEdit( client * _client, const QString & _group_name, QWidget * _parent ) :
	QDialog( _parent ),
	m_client( _client )
{
	setCaption( tr( "Edit properties of client...") );

	m_groupLbl = new QLabel( tr( "Client-group:" ), this );
	m_groupLbl->setGeometry( 10, 25, 120, 20 );

	m_nameLbl = new QLabel( tr( "Name:" ), this );
	m_nameLbl->setGeometry( 10, 60, 120, 20 );

	m_ipLbl = new QLabel( tr( "IP-address:" ), this );
	m_ipLbl->setGeometry( 10, 95, 120, 20 );

	m_macLbl = new QLabel( tr( "MAC-address:" ), this );
	m_macLbl->setGeometry( 10, 130, 120, 20);

	m_groupBox = new QComboBox( this );
	m_groupBox->setGeometry( 130, 20, 200, 25 );
	
	int set_to_group = 0;

	for( unsigned int i = 0; i < clientManager::inst()->m_classRooms.size(); ++i )
	{
		m_groupBox->insertItem( clientManager::inst()->m_classRooms[i]->text( 0 ) );
		if( _group_name == clientManager::inst()->m_classRooms[i]->text( 0 ) )
		{
			set_to_group = i;
		}
	}

	m_groupBox->setCurrentItem( set_to_group );

	m_nameEdit = new QLineEdit( this );
	m_nameEdit->setGeometry( 130, 55, 200, 25 );

	m_ipEdit = new QLineEdit( this );
	m_ipEdit->setGeometry( 130, 90, 200, 25 );

	m_macEdit = new QLineEdit( this );
	m_macEdit->setGeometry( 130, 125, 200, 25 );

	m_okBtn = new QPushButton( embed::getIconPixmap( "apply" ), tr( "OK" ), this );
	m_okBtn->setGeometry( 90, 170, 110, 28 );

	m_cancelBtn = new QPushButton( embed::getIconPixmap( "cancel" ), tr( "Cancel" ), this );
	m_cancelBtn->setGeometry( 220, 170, 110, 28 );


	if( m_client != NULL )
	{
		m_nameEdit->setText( m_client->name() );
		m_ipEdit->setText( m_client->ip() );
		m_macEdit->setText( m_client->mac() );
	}

	connect( m_okBtn, SIGNAL( clicked() ), this, SLOT( okBtnClicked() ) );
	connect( m_cancelBtn, SIGNAL( clicked() ), this, SLOT( reject() ) );
}




clientPropertiesEdit::~clientPropertiesEdit()
{
}




void clientPropertiesEdit::okBtnClicked( void )
{
	if( m_nameEdit->text() == "" )
	{
		QMessageBox::warning( NULL, tr( "Missing name for client" ), tr( "You didn't specify a name for the client!" ),
					QMessageBox::Ok, QMessageBox::NoButton );
		return;
	}
	if( m_ipEdit->text() == "" )
	{
		QMessageBox::warning( NULL, tr( "Missing IP-address/hostname for client" ), tr( "You didn't specify an IP-address or hostname "
									"for the client!" ), QMessageBox::Ok, QMessageBox::NoButton );
		return;
	}
	// check whether mac-address is valid
	if( m_macEdit->text() != "" && QString( m_macEdit->text().upper()+":").find( QRegExp( "^([\\dA-F]{2}:){6}$" ) ) != 0 )
	{
		QMessageBox::warning( NULL, tr( "Invalid MAC-address" ), tr( "You specified an invalid MAC-address. Either leave the "
						"field blank or enter a valid MAC-address." ), QMessageBox::Ok, QMessageBox::NoButton );
		return;
	}

	if( m_client == NULL )
	{
		m_client = new client( m_ipEdit->text(), m_macEdit->text(), m_nameEdit->text(),
					clientManager::inst()->m_classRooms[m_groupBox->currentItem()] );
	}
	else
	{
		m_client->setName( m_nameEdit->text() );
		m_client->setIP( m_ipEdit->text() );
		m_client->setMac( m_macEdit->text() );
		m_client->setClassRoom( clientManager::inst()->m_classRooms[m_groupBox->currentItem()] );
		m_client->resetConnection();
	}

	accept();
}




void clientPropertiesEdit::keyPressEvent( QKeyEvent * _ke )
{
	if( _ke->key() == Qt::Key_Escape )
	{
		reject();
	}
}

