/*
 * progress_information.cpp - implementation of dialog for showing status/progress of operation
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qlabel.h>
#include <qapplication.h>
#if QT_VERSION >= 0x030100
#include <qeventloop.h>
#endif

#include "progress_information.h"

#include "progress_information.moc"


progressInformation::progressInformation( const QString & _txt ):
	QWidget( NULL )
{
	setCaption( tr( "Please wait..." ) );

	m_txtLbl = new QLabel( _txt, this );
	m_txtLbl->setAlignment( m_txtLbl->alignment()|WordBreak );
	m_txtLbl->move( 5, 5 );
	m_txtLbl->setFixedSize( 500, 110 );
	m_txtLbl->adjustSize();

	resize( 510, 150 );
	show();
#if QT_VERSION >= 0x030100
	QApplication::eventLoop()->processEvents( QEventLoop::AllEvents, 100 );
#endif
	QApplication::flush();
}




progressInformation::~progressInformation()
{
}




void progressInformation::resizeEvent( QResizeEvent * )
{
	m_txtLbl->setFixedWidth( width()-10 );
	m_txtLbl->adjustSize();
//	m_stringLineEdit->setGeometry( 5, m_txtLbl->y()+m_txtLbl->height()+5, width()-10, 24 );
}
