#ifndef PCSPEAKER_H
#define PCSPEAKER_H

#include <qobject.h>
#include "../notify/notify.h"

class PCSpeaker : public Notifier
{	
	Q_OBJECT
	public:
		PCSpeaker();
		~PCSpeaker();
		Display *xdisplay;										//Xowy display na ktorego wywalane sa dzwieki
	private:
		int volume;												//glosnosc buczka
		void ParseStringToSound(QString linia, int tablica[21], int tablica2[20]);		//przeksztalca ze stringa na tablice intow
		void beep(int pitch, int duration);						//pipa :P
		void parseAndPlay(QString linia);
		void play(int sound[21], int soundlength[20]);
	private slots:
		void test1();											//reakcje na przycisk Test
		void test2();
		void test3();
		void test4();
		void test5();
		void OpenConfig();
		void newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t);
		void newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab);
		void connectionError(Protocol *protocol, const QString &message);
		void userStatusChanged(UserListElement ule, QString protocolName, const UserStatus &oldStatus);
		void userChangedStatusToAvailable(const QString &protocolName, UserListElement);
		void userChangedStatusToBusy(const QString &protocolName, UserListElement);
		void userChangedStatusToInvisible(const QString &protocolName, UserListElement);
		void userChangedStatusToNotAvailable(const QString &protocolName, UserListElement);
		void message(const QString &from, const QString &message, const QMap<QString, QVariant> *parameters, const UserListElement *ule);
		void externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules);

};

extern PCSpeaker *PCSpeakerObj;
#endif
