#ifndef KADU_HTML_DOCUMENT_H
#define KADU_HTML_DOCUMENT_H

#include <qstring.h>
#include <qvaluelist.h>

/**
	Klasa reprezentujca dokument html. Przechowuje
	list elementw. Element moe by tagiem html
	albo kawakiem tekstu.
**/
class HtmlDocument
{
	private:
		struct Element
		{
			QString text;
			bool tag;
			Element() : text(), tag(false) {}
		};
		QValueList<Element> Elements;
		void addElement(Element e);

	public:
		static void escapeText(QString& text);
		static void unescapeText(QString& text);

		HtmlDocument();

		/**
			Dodaje podany tekst do listy elementw jako
			tag html.
			@param text tekst do dodania
		**/
		void addTag(const QString &text);
		/**
			Dodaje podany tekst do listy elementw jako
			zwyky tekst.
			@param text tekst do dodania
		**/
		void addText(const QString &text);
		/**
			Wstawia podany tekst do listy elementw jako
			tag html przed innym elementem.
			@param pos indeks elementu przed ktorym wstawiamy
			@param text tekst do dodania
		**/
		void insertTag(const int pos,const QString &text);
		/**
			Wstawia podany tekst do listy elementw jako
			zwykly tekst przed innym elementem.
			@param pos indeks elementu przed ktorym wstawiamy
			@param text tekst do dodania
		**/
		void insertText(const int pos,const QString &text);
		/**
			Parsuje podany napis zgodny ze struktur html
			i otrzymane dane przypisuje do dokumentu.
			@param html napis do skonwertowania
		**/
		void parseHtml(const QString& html);
		/**
			Na podstawie zawartoci dokumentu generuje
			napis zgodny ze struktur html. Znaki specjalne
			wchodzce w skad elementw nie bdcych tagami
			html s escapowane.
		**/
		QString generateHtml() const;
		/**
			Zwraca ilo elementw wchodzcych w skad
			dokumentu.
		**/
		int countElements() const;
		/**
			Sprawdza czy element o podanym indeksie jest
			tagiem html czy zwykym tekstem.
		**/
		bool isTagElement(int index) const;
		/**
			Zwraca tekst elementu o podanym indeksie.
		**/
		const QString &elementText(int index) const;
		/**
			Zwraca tekst elementu o podanym indeksie.
		**/
		QString &elementText(int index);
		/**
			Ustawia tekst i typ elementu o podanym indeksie.
		**/
		void setElementValue(int index, const QString& text, bool tag=false);
		/**
			Wydziela z elementu podany fragment tekstu.
			Element moe pozosta jeden albo
			ulec podzieleniu na dwa lub nawet trzy elementy.
			Funkcja zmienia warto argumentu index, aby
			indeks wydzielonego elementu by aktualny.
		**/
		void splitElement(int& index, int start, int length);
		/**
			Skanuje tekst w poszukiwaniu adresw www,
			np. "www.kadu.net" i zmienia je w linki html.
		**/
		void convertUrlsToHtml();
};

#endif
