#ifndef I_HIDE_FROM_U_LIST_H
#define I_HIDE_FROM_U_LIST_H

#include <qobject.h>
#include <qstringlist.h>
#include "userlistelement.h"

/*!
 * This class holds the contacts lists (selected and all available). It
 * alse saves these lists to disk when exiting Kadu.
 * \brief Class providing holding selected contact list
 */
class IHideFromUList : public QObject
{
	Q_OBJECT
	public:
		/*!
		 * \brief Default constructor
		 * \param parent points to patent's object.
		 * \param name is an object's name.
		 */
		IHideFromUList(QObject *parent = 0, const char *name = 0);

		//! Default destructor
		~IHideFromUList();

		/*!
		 * \brief Returns the list of available to select contacts
		 * \return The list of available to select contacts
		 */
		QStringList getAvailableContacts();

		/*!
		 * \brief Returns the list of selected contacts
		 * \return The list of selected contacts
		 */
		QStringList getAvoidedContacts();

		/*!
		 * \brief Sets the available and selected contacts lists
		 * \param list The list of selected contacts
		 */
		void set(QStringList list);

		/*!
		 * \brief checks if selected contacts list contain the uin
		 * \param uin checked uin
		 * \return true when the uin is in selected list. Otherwise returns false
		 */
		bool contains(const QString &uin) const { return avoidedUins.contains(uin); }
	
	public slots:
		//! Saves the selected contacts list to a config file
		void readCfg();
		
		//! Reads the selected contacts list from the config file
		void writeCfg();
		
	protected:
		//! List of available to select contacts
		QStringList availableUins;

		//! List of selected contacts
		QStringList avoidedUins;

};

#endif
