/***************************************************************************
                          notificationitem.h  -  description
                             -------------------
    begin                : Thu May 22 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTIFICATIONITEM_H
#define NOTIFICATIONITEM_H

#include <qpixmap.h>
#include <qobject.h>
#include <qstringlist.h>

/**
  *@author Michael Curtis
  */

class QString;
class QStringList;
class QTimer;
class KURLLabel;
class NotificationWidget;

class NotificationItem : public QObject
{
  Q_OBJECT

  public:
    NotificationItem( NotificationWidget *parent = 0, char *name = 0,
                      QString text = 0, QString icon = 0,
                      QStringList linkedStrings = 0, QObject *linkedClass = 0 );
   ~NotificationItem();

    // get the icon path
    const QString   & getIcon() const;
    // get a pixmap that corresponds to the icon
    const QPixmap   & getPixmap() const;
    // get the text of the item
    const QString   & getText() const;
    // get the widget
    KURLLabel       * getWidget() const;

  signals:
    // emit clicked signal to the widget, which will forward it
    void      forwardClicked( QStringList strings, QObject *object );

  private slots:
    // hide, emit a message, then wait a few seconds before dying
    void      clicked();
    // just commit suicide
    void      selfDestruct();

  private:
    // icon path of the contact's (usually) icon
    QString                     icon_;
    // some object associated with the item (eg chat window)
    QObject                   * linkedClass_;
    // some strings associated with the item (eg contact handle)
    QStringList                 linkedStrings_;
    // pixmap for the icon
    QPixmap                     pixmap_;
    // a self-destruct timer
    QTimer                    * timer_;
    // text of the item (contact's name)
    QString                     text_;
    // widget for display and url launching
    KURLLabel                 * widget_;
};

#endif
