/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QStringList>
#include <QPair>

class Playlist
{
    public:
        void appendTrack( QString track, QString url, QString id ) { m_tracks.append( track ); m_urls.append( url ); m_ids.append( id ); }
        void clear() { m_tracks.clear(); m_urls.clear(); m_ids.clear(); }

        const int count() const { return m_tracks.count(); }
        QPair<QPair<QString, QString>, QString> trackAt( int id ) const;

    private:
        QStringList m_tracks;
        QStringList m_urls;
        QStringList m_ids;
};
