/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef __SETTINGS_H__
#define __SETTINGS_H__

#define VERSION "1.1.90"

#include <QtCore>

class BrowserThread : public QThread
{
    public:
        void run();
        void setUrl( QString url ) { m_url = url; }

    private:
        QString m_url;
};

class Settings : public QObject
{
    Q_OBJECT

    static Settings *s_instance;

    public:
        Settings();
        static Settings *instance() { return s_instance; }

        QString MD5Digest( const char *token );
        QString version() { return VERSION; }
        bool mergeSettings();

        QString commandLine() { return m_commandLine; }
        void setCommandLine( QString commandLine ) { m_commandLine = commandLine; }

        bool debug() { return m_debug; }
        void setDebug( bool debug ) { m_debug = debug; }

        int positionX();
        void setPositionX( int x );
        int positionY();
        void setPositionY( int y );

        bool resumePlayback();
        void setResumePlayback( bool enabled );
        QString resumeStation();
        void setResumeStation( QString station );

        int volume();
        void setVolume( int volume );
        int soundCard();
        void setSoundCard( int card );
        int soundSystem();
        void setSoundSystem( int system );
        int externalSoundSystem();

        QString username();
        void setUsername( QString username );
        QString password();
        void setPassword( QString password );

        QString proxyUsername();
        void setProxyUsername( QString username );
        QString proxyPassword();
        void setProxyPassword( QString password );
        QString proxyHost();
        void setProxyHost( QString host );
        int proxyPort();
        void setProxyPort( int port );
        bool proxyUsage();
        void setProxyUsage( bool enabled );

        int stationCounter( QString url );
        void incrementStationCounter( QString url, QString stationName = QString::null );
        void deleteStationCounter( QString url );
        void resetStationCounter( QString url );
        void clearStationCounters();
        QString stationName( QString url );
        QStringList stationItems();

        QString browser();
        void setBrowser( QString browser );
        void startBrowser( QString url );

    public slots:
        void save( bool restartConnection = false, bool restartAudio = false );

    signals:
        void reconnect();
        void resetAudio();

    private:
        QSettings *config;
        QSettings *configUsers;
        QSettings *configRadio;

        bool m_debug;
        bool m_actAsProxy;
        QString m_commandLine;
};

#endif
