/*
 * Copyright © 2005 Red Hat, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of
 * Red Hat, Inc. not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. Red Hat, Inc. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * RED HAT, INC. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL RED HAT, INC. BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Carl D. Worth <cworth@cworth.org>
 */

#include "cairo-test.h"

/* Test case for bug #4205:

   https://bugs.freedesktop.org/show_bug.cgi?id=4205
*/

cairo_test_t test = {
    "caps-sub-paths",
    "Test that sub-paths receive caps.",
    20, 20
};

static cairo_test_status_t
draw (cairo_t *cr, int width, int height)
{
    cairo_set_line_width (cr, 4);
    cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);

    cairo_move_to (cr,  4,  4);
    cairo_line_to (cr,  4, 16);

    cairo_move_to (cr, 10,  4);
    cairo_line_to (cr, 10, 16);

    cairo_move_to (cr, 16,  4);
    cairo_line_to (cr, 16, 16);

    cairo_stroke (cr);

    return CAIRO_TEST_SUCCESS;
}

int
main (void)
{
    return cairo_test (&test, draw);
}
