/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX
#define INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX

#include <com/sun/star/animations/XAnimate.hpp>

#include "basecontainernode.hxx"
#include "activitiesfactory.hxx"
#include "shapeattributelayer.hxx"
#include "shapeattributelayerholder.hxx"
#include "attributableshape.hxx"
#include "shapesubset.hxx"

namespace slideshow {
namespace internal {

/** Common base class for all leaf animation nodes.
    
    This class basically holds the target shape
*/
class AnimationBaseNode : public BaseNode
{
public:
    AnimationBaseNode(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimationNode> const& xNode, 
        ::boost::shared_ptr<BaseContainerNode> const& pParent,
        NodeContext const& rContext );
    
#if defined(VERBOSE) && defined(DBG_UTIL)
    virtual void showState() const;
#endif
    
protected:
    virtual void dispose();
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimate> const& getXAnimateNode() const
        { return mxAnimateNode; }
    
    /// Create parameter struct for ActivitiesFactory
    ActivitiesFactory::CommonParameters fillCommonParameters() const;
    ::basegfx::B2DVector const&         getSlideSize() const { return maSlideSize; }
    AttributableShapeSharedPtr          getShape() const;
    
private:
    virtual bool hasPendingAnimation() const;
    
private: // state transition callbacks
    virtual bool init_st();
    virtual bool resolve_st();
    virtual void activate_st();
    virtual void deactivate_st( NodeState eDestState );
    virtual AnimationActivitySharedPtr createActivity() const = 0;
    
private:
    /** Returns true, if this is a subset animation, and
        the subset is autogenerated (e.g. from an
        iteration)
    */
    bool isDependentSubsettedShape() const
        { return mpShapeSubset && !mbIsIndependentSubset; }
    
    ShapeAttributeLayerHolder const & getAttributeLayerHolder() const
        { return maAttributeLayerHolder; }
    
private:
    ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimate>     mxAnimateNode;
    ShapeAttributeLayerHolder                       maAttributeLayerHolder;
    ::basegfx::B2DVector                            maSlideSize;
    AnimationActivitySharedPtr                      mpActivity;
    
    /// When valid, this node has a plain target shape
    AttributableShapeSharedPtr                      mpShape;
    /// When valid, this is a subsetted target shape 
    ShapeSubsetSharedPtr                            mpShapeSubset;
    SubsettableShapeManagerSharedPtr                mpSubsetManager;
    bool                                            mbIsIndependentSubset;
};

} // namespace internal
} // namespace presentation

#endif /* INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX */

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
