<?php
/** Bulgarian (Български)
  *
  * @package MediaWiki
  * @subpackage Language
  */

#--------------------------------------------------------------------------
# Language-specific text
#--------------------------------------------------------------------------

# The names of the namespaces can be set here, but the numbers
# are magical, so don't change or move them!  The Namespace class
# encapsulates some of the magic-ness.
#

/* private */ $wgNamespaceNamesBg = array(
	NS_MEDIA            => 'Медия',
	NS_SPECIAL          => 'Специални',
	NS_MAIN             => '',
	NS_TALK             => 'Беседа',
	NS_USER             => 'Потребител',
	NS_USER_TALK        => 'Потребител_беседа',
	NS_PROJECT          => $wgMetaNamespace,
	NS_PROJECT_TALK     => $wgMetaNamespace . '_беседа',
	NS_IMAGE            => 'Картинка',
	NS_IMAGE_TALK       => 'Картинка_беседа',
	NS_MEDIAWIKI        => 'МедияУики',
	NS_MEDIAWIKI_TALK   => 'МедияУики_беседа',
	NS_TEMPLATE         => 'Шаблон',
	NS_TEMPLATE_TALK    => 'Шаблон_беседа',
	NS_HELP             => 'Помощ',
	NS_HELP_TALK        => 'Помощ_беседа',
	NS_CATEGORY         => 'Категория',
	NS_CATEGORY_TALK    => 'Категория_беседа'
) + $wgNamespaceNamesEn;

/* private */ $wgQuickbarSettingsBg = array(
	'Без меню', 'Неподвижно вляво', 'Неподвижно вдясно', 'Плаващо вляво'
);

/* private */ $wgSkinNamesBg = array(
	'standard' => 'Основен',
	'nostalgia' => 'Носталгия',
	'cologneblue' => 'Кьолнско синьо',
	'smarty' => 'Падингтън',
	'montparnasse' => 'Монпарнас',
	'davinci' => 'ДаВинчи',
) + $wgSkinNamesEn;


/* private */ $wgDateFormatsBg = array();

/* private */ $wgBookstoreListBg = array(
	'books.bg'       => "http://www.books.bg/ISBN/$1",
) + $wgBookstoreListEn;


/* private */ $wgMagicWordsBg = array(
#   ID                                 CASE  SYNONYMS
	MAG_REDIRECT             => array( 0, '#redirect', '#пренасочване', '#виж' ),
	MAG_NOTOC                => array( 0, '__NOTOC__', '__БЕЗСЪДЪРЖАНИЕ__' ),
	MAG_FORCETOC             => array( 0, '__FORCETOC__', '__СЪДЪРЖАНИЕ__' ),
	MAG_NOEDITSECTION        => array( 0, '__NOEDITSECTION__', '__БЕЗ_РЕДАКТИРАНЕ_НА_РАЗДЕЛИ__' ),
	MAG_START                => array( 0, '__START__', '__НАЧАЛО__'         ),
	MAG_CURRENTMONTH         => array( 1, 'CURRENTMONTH', 'ТЕКУЩМЕСЕЦ'      ),
	MAG_CURRENTMONTHNAME     => array( 1, 'CURRENTMONTHNAME', 'ТЕКУЩМЕСЕЦИМЕ' ),
	MAG_CURRENTDAY           => array( 1, 'CURRENTDAY', 'ТЕКУЩДЕН'            ),
	MAG_CURRENTDAYNAME       => array( 1, 'CURRENTDAYNAME', 'ТЕКУЩДЕНИМЕ'     ),
	MAG_CURRENTYEAR          => array( 1, 'CURRENTYEAR', 'ТЕКУЩАГОДИНА'       ),
	MAG_CURRENTTIME          => array( 1, 'CURRENTTIME', 'ТЕКУЩОВРЕМЕ'        ),
	MAG_NUMBEROFARTICLES     => array( 1, 'NUMBEROFARTICLES', 'БРОЙСТАТИИ'    ),
	MAG_CURRENTMONTHNAMEGEN  => array( 1, 'CURRENTMONTHNAMEGEN' ),
	MAG_PAGENAME             => array( 1, 'PAGENAME', 'СТРАНИЦА'               ),
	MAG_NAMESPACE            => array( 1, 'NAMESPACE', 'ИМЕНПРОСТРАНСТВО'              ),
	MAG_SUBST                => array( 0, 'SUBST:', 'ЗАМЕСТ:'              ),
	MAG_MSGNW                => array( 0, 'MSGNW:', 'СЪОБЩNW:'             ),
	MAG_END                  => array( 0, '__END__', '__КРАЙ__'            ),
	MAG_IMG_THUMBNAIL        => array( 1, 'thumbnail', 'thumb', 'мини'     ),
	MAG_IMG_RIGHT            => array( 1, 'right', 'вляво'                 ),
	MAG_IMG_LEFT             => array( 1, 'left', 'вдясно'                 ),
	MAG_IMG_NONE             => array( 1, 'none'                   ),
	MAG_IMG_WIDTH            => array( 1, "$1px", "$1пкс"          ),
	MAG_IMG_CENTER           => array( 1, 'center', 'centre', 'център' ),
	MAG_IMG_FRAMED           => array( 1, 'framed', 'enframed', 'frame', 'рамка', 'врамка' ),
	MAG_INT                  => array( 0, 'INT:'                   ),
	MAG_SITENAME             => array( 1, 'SITENAME', 'САЙТ'       ),
	MAG_NS                   => array( 0, 'NS:'                    ),
	MAG_LOCALURL             => array( 0, 'LOCALURL:'              ),
	MAG_LOCALURLE            => array( 0, 'LOCALURLE:'             ),
	MAG_SERVER               => array( 0, 'SERVER', 'СЪРВЪР'       )
);

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------
# БЕЛЕЖКА: За да изключите "Текущите събития" в страничното меню,
# въведете 'currentevents' => '-'

# БЕЛЕЖКА: За да изключите "Условията за ползване" в заглавните препратки,
# въведете 'disclaimers' => ''

# БЕЛЕЖКА: За да изключите "Портала" за общността в заглавните препратки,
# въведете 'portal' => ''

/* private */ $wgAllMessagesBg = array(
# User toggles
'tog-underline'      => 'Подчертаване на препратките',
'tog-highlightbroken' => 'Показване на невалидните препратки <a href="" class="new">така</a> (алтернативно: така<a href="" class="internal">?</a>)',
'tog-justify'        => 'Двустранно подравняване на абзаците',
'tog-hideminor'      => 'Скриване на малки редакции в последните промени',
'tog-usenewrc'       => 'Подобряване на последните промени (не за всички браузъри)',
'tog-numberheadings' => 'Номериране на заглавията',
'tog-showtoolbar'    => 'Показване на лента за редактиране',
'tog-editondblclick' => 'Редактиране при двойно щракване (Javascript)',
'tog-editsection'    =>'Възможност за редактиране на раздел чрез препратка [редактиране]',
'tog-editsectiononrightclick' => 'Възможност за редактиране на раздел при щракване с десния бутон върху заглавие на раздел (Javascript)',
'tog-showtoc'        =>'Показване на съдържание (за статии с повече от три раздела)',
'tog-rememberpassword' => 'Запомняне на паролата между сесиите',
'tog-editwidth'      => 'Максимална ширина на кутията за редактиране',
'tog-watchdefault'   => 'Добавяне на редактираните страници към списъка за наблюдение',
'tog-minordefault'   => 'Отбелязване на всички промени като малки по подразбиране',
'tog-previewontop'   => 'Показване на предварителния преглед преди текстовата кутия, а не след нея',
'tog-nocache'        => 'Без складиране на страниците',
# Dates
'sunday' => 'неделя',
'monday' => 'понеделник',
'tuesday' => 'вторник',
'wednesday' => 'сряда',
'thursday' => 'четвъртък',
'friday' => 'петък',
'saturday' => 'събота',
'january' => 'януари',
'february' => 'февруари',
'march' => 'март',
'april' => 'април',
'may_long' => 'май',
'june' => 'юни',
'july' => 'юли',
'august' => 'август',
'september' => 'септември',
'october' => 'октомври',
'november' => 'ноември',
'december' => 'декември',
'jan' => 'яну',
'feb' => 'фев',
'mar' => 'мар',
'apr' => 'апр',
'may' => 'май',
'jun' => 'юни',
'jul' => 'юли',
'aug' => 'авг',
'sep' => 'сеп',
'oct' => 'окт',
'nov' => 'ное',
'dec' => 'дек',

# Bits of text used by many pages:
#
'categories' => 'Категории',
'category' => 'категория',
'category_header' => "Статии в категория \"$1\"",
'subcategories' => 'Подкатегории',
'linktrail'    => "/^((?:[a-z]|а|б|в|г|д|е|ж|з|и|й|к|л|м|н|о|п|р|с|т|у|ф|х|ц|ч|ш|щ|ъ|ы|ь|э|ю|я)+)(.*)\$/sD",
'mainpage'    => 'Начална страница',
'mainpagetext'  => 'Системата на Уики бе успешно инсталирана.',
'mainpagedocfooter' => "Моля, разгледайте [http://meta.wikipedia.org/wiki/MediaWiki_i18n документацията]
     и [http://meta.wikipedia.org/wiki/MediaWiki_User%27s_Guide ръководството] за подробна информация относно МедияУики.",
'portal'     => 'Портал за общността',
'portal-url' => '{{ns:4}}:Портал',
'about'      => "За {{SITENAME}}",
'aboutsite'      => "За {{SITENAME}}",
'aboutpage'    => "{{ns:4}}:За {{SITENAME}}",
'article'   => 'Статия',
'help'      => 'Помощ',
'helppage'    => "{{ns:12}}:Помощ",
'bugreports'  => 'Съобщения за грешки',
'bugreportspage' => "{{ns:4}}:Съобщения_за_грешки",
"sitesupport"   => "Дарения", # Set a URL in $wgSiteSupportPage in LocalSettings.php
'faq'      => 'ЧЗВ',
'faqpage'    => "{{ns:4}}:ЧЗВ",
'edithelp'    => 'Помощ при редактиране',
'edithelppage'  => "{{ns:12}}:Как_се_редактират_страници",
'cancel'    => 'Отказ',
'qbfind'    => 'Търсене',
'qbbrowse'    => 'Избор',
'qbedit'    => 'Редактиране',
'qbpageoptions' => 'Настройки за страницата',
'qbpageinfo'  => 'Информация за страницата',
'qbmyoptions'  => 'Моите настройки',
'qbspecialpages' => 'Специални страници',
'moredotdotdot' => 'Повече...',
'mypage'    => 'Моята страница',
'mytalk'    => 'Моята беседа',
'anontalk'  => 'Беседа за адреса',
'navigation' => 'Навигация',
'currentevents' => 'Текущи събития',
'disclaimers' => 'Условия за ползване',
'disclaimerpage' => "{{ns:4}}:Условия_за_ползване",
'errorpagetitle' => 'Грешка',
'returnto'    => "Обратно към $1.",
'tagline'        => "от {{SITENAME}}, свободната енциклопедия",
'whatlinkshere'  => 'Какво сочи насам',
'help'      => 'Помощ',
'search'    => 'Търсене',
'go'    => 'Отваряне',
'history'    => 'История',
'history_short' => 'История',
'printableversion' => 'Версия за печат',
'edit' => 'Редактиране',
'editthispage'  => 'Редактиране',
'delete' => 'Изтриване',
'deletethispage' => 'Изтриване',
'undelete_short' => 'Възстановяване',
'undelete_short1' => 'Възстановяване',
'protect' => 'Защита',
'protectthispage' => 'Защита',
'unprotect' => 'Сваляне на защитата',
'unprotectthispage' => 'Сваляне на защитата',
'newpage' => 'Нова страница',
'talkpage'    => 'Дискусионна страница',
'specialpage' => 'Специална страница',
'personaltools' => 'Лични инструменти',
'postcomment'   => 'Оставяне на съобщение',
'addsection'   => '+',
'articlepage'  => 'Преглед на статия',
'subjectpage'  => 'Преглед на тема', # For compatibility
'talk' => 'Беседа',
'toolbox' => 'Кутия с инструменти',
'userpage' => 'Потребителска страница',
'wikipediapage' => 'Основна страница',
'imagepage' =>   'Преглед на картинка',
'viewtalkpage' => 'Преглед на беседа',
'otherlanguages' => 'Други езици',
'redirectedfrom' => "(пренасочване от $1)",
'lastmodified'  => "Последна промяна на страницата: $1.",
'viewcount'    => "Страницата е била преглеждана $1 пъти.",
'copyright'     => "Съдържанието е достъпно при условията на $1.",
'poweredby'     => "{{SITENAME}} се задвижва от [http://www.mediawiki.org/ МедияУики], софтуер за уики с отворен код.",
'printsubtitle' => '(от {{SERVER}})',
'protectedpage' => 'Защитена страница',
'administrators' => "{{ns:4}}:Администратори",
'sysoptitle'  => 'Изискване на администраторски права',
'sysoptext'    => "Желаното действие може да се изпълни само от администратори.
Вижте $1.",
'developertitle' => 'Изискват се права на разработчик',
'developertext'  => "Желаното действие може да се изпълни само от разработчици.
Вижте $1.",
"nbytes"    => "$1 байта",
'go'      => 'Отваряне',
'ok'      => 'Добре',
'sitetitle'    => "{{SITENAME}}",
'pagetitle'    => "$1 - {{SITENAME}}",
'sitesubtitle' => 'Свободната енциклопедия',
'retrievedfrom' => "Взето от \"$1\".",
'newmessages' => "Имате $1.",
'newmessageslink' => 'нови съобщения',
'editsection' => 'редактиране',
'toc' => 'Съдържание',
'showtoc' => 'показване',
'hidetoc' => 'скриване',
'thisisdeleted' => "Преглед или възстановяване на $1?",
'restorelink' => "$1 изтрити редакции",
'feedlinks' => 'Feed:',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main' => 'Статия',
'nstab-user' => 'Потребителска страница',
'nstab-media' => 'Медия',
'nstab-special' => 'Специална страница',
'nstab-wp' => "За {{SITENAME}}",
'nstab-image' => 'Картинка',
'nstab-mediawiki' => 'Съобщение',
'nstab-template' => 'Шаблон',
'nstab-help' => 'Помощ',
'nstab-category' => 'Категория',

# Main script and global functions
#
'nosuchaction'  => 'Няма такова действие',
'nosuchactiontext' => 'Действието, указано от мрежовия адрес, не се разпознава от системата.',
'nosuchspecialpage' => 'Няма такава специална страница',
'nospecialpagetext' => 'Отправихте заявка за специална страница, която не се разпознава от системата.',

# General errors
#
'error'      => 'Грешка',
'databaseerror' => 'Грешка при работа с базата данни',
'dberrortext'  => "Възникна синтактична грешка при заявка към базата данни.
Последната заявка към базата данни бе:
<blockquote><tt>$1</tt></blockquote>
при функцията \"<tt>$2</tt>\".
MySQL дава грешка \"<tt>$3: $4</tt>\".",
'dberrortextcl' => "Възникна синтактична грешка при заявка към базата данни.
Последната заявка към базата данни бе:
\"$1\"
при функцията \"$2\".
MySQL дава грешка \"$3: $4\".\n",
'noconnect'    => "В момента има технически трудности и не може да се осъществи връзка с базата данни.",
'nodb'      => "Неуспех при избиране на база данни $1",
'cachederror'  => 'Показано е складирано копие на желаната страница, което евентуално може да е остаряло.',
'readonly'    => 'Базата данни е затворена за промени',
'enterlockreason' => 'Посочете причина за затварянето, като дадете и
приблизителна оценка кога базата данни ще бъде отново отворена',
'readonlytext'  => "Базата данни е временно затворена за промени - вероятно за рутинна поддръжка,
след която ще бъде отново на разположение.
Администраторът, който я е затворил, дава следното обяснение:
<p>$1",
'missingarticle' => "Текстът на страницата \"$1\" не бе намерен в базата данни.

<p>Това обикновено е причинено от последване на остаряла разлика или
препратка от историята към изтрита страница.

<p>Ако не това е причината, е възможно да сте открили грешка в системата.
Моля, съобщете за това на администратор, като включите и името на статията.",
'internalerror' => 'Вътрешна грешка',
'filecopyerror' => "Файлът \"$1\" не можа да бъде копиран като \"$2\".",
'filerenameerror' => "Файлът \"$1\" не можа да бъде преименуван на \"$2\".",
'filedeleteerror' => "Файлът \"$1\" не можа да бъде изтрит.",
'filenotfound'  => "Файлът \"$1\" не бе намерен.",
'unexpected'  => "Неочаквана стойност: \"$1\"=\"$2\".",
'formerror'    => 'Възникна грешка при изпращане на формуляра',
'badarticleerror' => 'Действието не може да се изпълни върху страницата.',
'cannotdelete'  => 'Указаната страница или картинка не можа да бъде изтрита. Възможно е вече да е изтрита от някой друг.',
'badtitle'    => 'Невалидно заглавие',
'badtitletext'  => 'Желаното заглавие на статия е невалидно, празно или
неправилна препратка към Уикипедия на друг език.',
'perfdisabled' => 'Съжаляваме! Това свойство е временно изключено,
защото забавя базата данни дотам, че никой не може да използва уикито.',
'perfdisabledsub' => "Съхранен екземпляр от $1:",
'perfcached' => 'Следните данни са извлечени от склада и затова може да не отговарят на текущото състояние:',
'wrong_wfQuery_params' => "Невалидни аргументи за wfQuery()<br />
Функция: $1<br />
Заявка: $2
",
'viewsource' => 'Защитена страница',
'protectedtext' => "Страницата е затворена за промени. Съществуват няколко
причини това да е така, моля, вижте
[[{{ns:4}}:Защитена_страница]].

Може да прегледате и копирате изходния код на страницата:",

# Login and logout pages
#
"logouttitle"  => "Излизане на потребител",
"logouttext"  => "Излязохте от системата.
Може да продължите да използвате {{SITENAME}} анонимно или да влезете отново
като друг потребител. Обърнете внимание, че някои страници все още
ще се показват така, сякаш сте влезли, докато не изтриете кеш-паметта на браузъра.\n",

"welcomecreation" => "<h2>Добре дошли, $1!</h2><p>Вашата сметка бе успешно открита.
Сега може да промените настройките по Ваш вкус.",

"loginpagetitle" => "Влизане в системата",
"yourname"    => "Вашето потребителско име",
"yourpassword"  => "Вашата парола",
"yourpasswordagain" => "Въведете повторно парола",
"newusersonly"  => " (само за нови потребители)",
"remembermypassword" => "Запомняне на паролата между сесиите.",
"loginproblem"  => "<b>Имаше проблем с Вашето влизане.</b><br />Опитайте отново!",
"alreadyloggedin" => "<strong>$1, вече сте влезли в системата!</strong><br />\n",

'login'      => 'Влизане',
'loginprompt'  => "Бисквитките трябва да са разрешени, за да може да влезете в {{SITENAME}}.",
'userlogin'    => 'Влизане',
'logout'    => 'Излизане',
'userlogout'  => 'Излизане',
'notloggedin'  => 'Не сте влезли',
'createaccount'  => 'Създаване на сметка',
'createaccountmail'     => 'с писмо по електронната поща',
'badretype'    => 'Въведените пароли не съвпадат.',
'userexists'  => 'Въведеното потребителско име вече се използва. Моля, изберете друго име.',
'youremail'    => 'Вашата е-поща*',
'yourrealname' => 'Вашето истинско име*',
'yournick'    => 'Вашият псевдоним (за подписи)',
'emailforlost'  => '* Полетата, отбелязани със звезда (*), са незадължителни. Посочването на електронна поща позволява на хората да се свържат с Вас, без да се налага да им съобщавате адреса си, а също може да се използва, за да Ви се изпрати нова парола, ако случайно забравите сегашната си.<br /><br /> Ако посочите истинското си име, на него ще бъдат приписани Вашите приноси.',
'prefs-help-realname' => '* <strong>Истинско име</strong> (незадължително): ако го посочите, на него ще бъдат приписани Вашите приноси.<br />',
'prefs-help-email' => '* <strong>Електронна поща</strong> (незадължително): позволява на хората да се свържат с Вас, без да се налага да им съобщавате адреса си, а също може да се използва, за да Ви се изпрати нова парола, ако случайно забравите сегашната си.',
'loginerror'  => 'Грешка при влизане',
'nocookiesnew'  => "Потребителската сметка бе създадена, но все още не сте влезли. {{SITENAME}} използва бисквитки при влизане на потребителите. Моля, разрешете бисквитките във Вашия браузър, тъй като те са забранени, и след това влезте с потребителското си име и парола.",
'nocookieslogin'        => "{{SITENAME}} използва бисквитки за запис на влизанията. Моля, разрешете бисквитките във Вашия браузър, тъй като те са забранени, и опитайте отново.",
'noname'    => 'Не указахте валидно потребителско име.',
'loginsuccesstitle' => 'Успешно влизане',
'loginsuccess'  => "Влязохте в {{SITENAME}} като \"$1\".",
'nosuchuser'  => "Няма потребител с името \"$1\".
Проверете изписването или се регистрирайте, използвайки долния формуляр.",
'wrongpassword'  => 'Въведената парола е невалидна. Моля, опитайте отново.',
'mailmypassword' => 'Изпращане на нова парола',
'passwordremindertitle' => "Напомняне за парола от {{SITENAME}}",
'passwordremindertext' => "Някой (най-вероятно Вие, от IP-адрес $1)
помоли да Ви изпратим новата парола за влизане в {{SITENAME}}.
Паролата за потребителя \"$2\" е \"$3\".
Сега би трябвало да влезете в системата и да смените паролата си.",
'noemail'    => "Няма записана електронна поща за потребителя \"$1\".",
'passwordsent'  => "Нова парола беше изпратена на електронната поща на \"$1\".
Моля, влезте отново, след като я получите.",
'loginend'   => "За да се регистрирате, просто въведете потребителско име и парола (два пъти) и щракнете върху бутона '<b>Създаване на сметка</b>'.<br /><br />

Следващия път е достатъчно да попълните само първите две полета и да щракнете върху '<b>Влизане</b>'.<br /><br />",
'mailerror' => "Грешка при изпращане на писмо: $1",

# Edit page toolbar
'bold_sample'      => 'Получер текст',
'bold_tip'         => 'Получер (удебелен) текст',
'italic_sample'    => 'Курсивен текст',
'italic_tip'       => 'Курсивен (наклонен) текст',
'link_sample'      => 'Име на препратка',
'link_tip'         => 'Вътрешна препратка',
'extlink_sample'   => 'http://www.primer.com Име на препратката',
'extlink_tip'      => 'Външна препратка (не забравяйте http:// отпред)',
'headline_sample'  => 'Заглавен текст',
'headline_tip'     => 'Заглавие',
'math_sample'      => 'Тук въведете формулата',
'math_tip'         => 'Математическа формула (LaTeX)',
'nowiki_sample'    => 'Тук въведете текст',
'nowiki_tip'       => 'Пренебрегване на форматиращите команди',
'image_sample'     => 'Пример.jpg',
'image_tip'        => 'Вмъкване на картинка',
'media_sample'     => 'Пример.mp3',
'media_tip'        => 'Препратка към файл',
'sig_tip'          => 'Вашият подпис заедно с времева отметка',
'hr_tip'           => 'Хоризонтална линия (използвайте пестеливо)',
'infobox'          => 'Щракнете върху бутон за демонстрация',
# alert box shown in browsers where text selection does not work, test e.g. with mozilla or konqueror
'infobox_alert' => "Моля, въведете текста, който искате да форматирате.\\n Той ще се покаже в информационното поле, откъдето ще може да го изберете.\\nПример:\\n$1\\nще се превърне в:\\n$2",

# Edit pages
#
'summary'       => '<a href="http://bg.wikipedia.org/wiki/{{ns:4}}:Резюме" title="Моля, дайте кратко описание на направените промени">Резюме</a>',
'subject'       => 'Тема/заглавие',
'minoredit'     => 'Това е малка промяна',
'watchthis'     => 'Наблюдение на статията',
'savearticle'   => 'Съхранение',
'preview'       => 'Предварителен преглед',
'showpreview'   => 'Предварителен преглед',
'blockedtitle'  => 'Потребителят е блокиран',
'blockedtext'   => "Вашето потребителско име (или IP-адрес) е блокирано от $1.
Причината за това е:<br />''$2''<p>Може да се свържете с $1 или с някой от останалите
[[{{ns:4}}:Администратори|администратори]], за да обсъдите това.

Може да използвате услугата \"'''Пращане писмо на потребителя'''\" единствено, ако сте посочили валидна електронна поща в [[{{ns:-1}}:Preferences|настройки]] си.

Вашият IP-адрес е $3. Моля, вмъквайте този адрес във всяко питане, което правите.",
'whitelistedittitle' => 'Необходимо е да влезете, за да може да редактирате',
'whitelistedittext' => 'Необходимо е да [[{{ns:-1}}:Userlogin|влезете]], за да може да редактирате статии.',
'whitelistreadtitle' => 'Необходимо е да влезете, за да може да четете',
'whitelistreadtext' => 'Необходимо е да [[{{ns:-1}}:Userlogin|влезете]], за да може да четете статии.',
'whitelistacctitle' => 'Не ви е позволено да създавате сметка',
'whitelistacctext' => 'За да Ви бъде позволено създаването на сметки, трябва да [[{{ns:-1}}:Userlogin|влезете]] и да имате подходящото разрешение.',
'loginreqtitle' => 'Изисква се влизане',
'loginreqtext'  => 'Необходимо е да [[{{ns:-1}}:Userlogin|влезете]], за да може да разглеждате други страници.',
'accmailtitle' => 'Паролата бе изпратена.',
'accmailtext' => "Паролата за '$1' бе изпратена на $2.",
'newarticle'  => '(нова)',
'newarticletext' => "<div style=\"font-size:small;color:#033;border-width:1px;border-style:solid;border-color:#aaa;padding:3px\">Последвали сте препратка към страница, която все още не съществува.
За да я създадете, започнете да пишете в долната текстова кутия
(вижте '''[[{{ns:4}}:Помощ|помощната страница]]''' за повече информация).
Ако сте дошли тук по грешка, просто натиснете '''бутона за връщане''' на Вашия браузър.

'''Въведете съдържателен текст, който би обогатил енциклопедията.''' Вашата добавка към Уикипедия ще бъде видима '''веднага''' след съхранението, затова ако просто искате да изпробвате как работят нещата, използвайте нашия '''[[{{ns:4}}:Пясъчник|пясъчник]]'''.</div>",
'talkpagetext' => '<!-- МедияУики:talkpagetext -->',
'anontalkpagetext' => "----
''Това е дискусионната страница на анонимен потребител, който  все още няма сметка или не я използва. Затова се налага да използваме цифров мрежов адрес (IP address), за да го/я идентифицираме. Такъв адрес може да се споделя от няколко потребителя.

Ако сте анонимен потребител и мислите, че тези неуместни коментари са отправени към Вас, моля [[{{ns:-1}}:Userlogin|регистрирайте се или влезте в системата]], за да избегнете евентуално бъдещо объркване с други анонимни потребители.''",
'noarticletext' => "(Тази страница все още не съществува. Може да я създадете, като щракнете на '''Редактиране'''.)",
'usercssjsyoucanpreview' => "<strong>Съвет:</strong> Използвайте бутона 'Предварителен преглед', за да изпробвате новия код на css/js преди съхранението.",
'usercsspreview' => "'''Не забравяйте, че това е само предварителен преглед на кода на CSS, страницата все още не е съхранена!'''",
'userjspreview' => "'''Не забравяйте, че това е само изпробване/предварителен преглед на кода на Javascript, страницата все още не е съхранена!'''",
'updated'    => '(актуализирана)',
'note'      => '<strong>Забележка:</strong> ',
'previewnote'  => 'Не забравяйте, че това е само предварителен преглед и страницата все още не е съхранена!',
'previewconflict' => 'Този предварителен преглед отразява текста в горната текстова кутия така, както би се показал, ако съхраните.',
'editing'    => "Редактиране на $1",
'editingsection'    => "Редактиране на $1 (раздел)",
'editingcomment'    => "Редактиране на $1 (коментар)",
'editconflict'  => "Различна редакция: $1",
'explainconflict' => "Някой друг вече е променил тази страница, откакто започнахте да я редактирате.
Горната текстова кутия съдържа текущия текст на страницата без Вашите промени, които са показани в долната кутия. За да бъдат и те съхранени, е необходимо ръчно да ги преместите в горното поле, тъй като <b>единствено</b> текстът в него ще бъде съхранен при натискането на бутона \"Съхранение\".<br />",
"yourtext"    => "Вашият текст",
"storedversion" => "Съхранена версия",
"editingold"  => "<strong>ВНИМАНИЕ: Редактирате остаряла
версия на страницата.
Ако съхраните, всякакви промени, направени след тази версия, ще бъдат изгубени.</strong>",
"yourdiff"    => "Разлики",
"copyrightwarning" => "<div style=\"border:1px solid #333; padding:0.5em\">
Моля, обърнете внимание на това, че
всички приноси към {{SITENAME}} се публикуват при условията на
лиценза за свободна документация на ГНУ
(за подробности вижте $1).
Ако не сте съгласни Вашето произведение да бъде променяно и
преразпределяно от останалите, не го публикувайте.
<br />
Също потвърждавате, че Вие сте написали материала
или сте използвали <b>свободни ресурси</b> -
<i>обществено достояние</i> или друг свободен източник.
Ако сте ползвали чужди материали, за които имате разрешение, непременно посочете източника.
<strong>НЕ ПУБЛИКУВАЙТЕ ПРОИЗВЕДЕНИЯ С АВТОРСКИ ПРАВА БЕЗ РАЗРЕШЕНИЕ!</strong>
</div>",
"longpagewarning" => "<strong>ВНИМАНИЕ: Страницата има размер $1 килобайта; някои
браузъри могат да имат проблеми при редактиране на страници
по-големи от 32Кб.
Моля, обмислете дали страницата не може да се раздели на няколко по-малки части.</strong>",
"readonlywarning" => "<strong>ВНИМАНИЕ: Базата данни бе затворена за поддръжка,
затова в момента Вашите промени не мога да бъдат съхранени.
Ако желаете, може да съхраните страницата като текстов файл и да се
опитате да я публикувате по-късно.</strong>",
"protectedpagewarning" => "<strong>ВНИМАНИЕ: Страницата е затворена за промени, само
администратори могат да я редактират.
Моля, следвайте [[Project:Защитена_страница|указанията за защитена страница]].</strong>",

# History pages
#
'revhistory'      => 'История на версиите',
'nohistory'       => 'Няма редакционна история за тази страница.',
'revnotfound'     => 'Версията не е открита',
'revnotfoundtext' => "Желаната стара версия на страницата не бе открита.
Моля, проверете адреса, който използвахте за достъп към страницата.\n",
'loadhist'        => 'Зареждане история на страницата',
'currentrev'      => 'Текуща версия',
'revisionasof'    => "Версия от $1",
'cur'             => 'тек',
'next'            => 'след',
'last'            => 'посл',
'orig'            => 'ориг',
'histlegend'      => 'Разлики: направете отметки в кутийките срещу версиите, които желаете да сравните, и натиснете "Enter" или бутона отдолу.<br />
Легенда: (<b>тек</b>) = разлика с текущата версия,
(<b>посл</b>) = разлика с предишната версия, <b>М</b>&nbsp;=&nbsp;малка промяна',

# Diffs
#
'difference'   => '(Разлики между версиите)',
'loadingrev'   => 'зареждане на версии за функцията <em>разл</em>',
'lineno'       => "Ред $1:",
'editcurrent'  => 'Редактиране на текущата версия на страницата',
'selectnewerversionfordiff' => 'Избиране на нова версия за сравнение',
'selectolderversionfordiff' => 'Избиране на стара версия за сравнение',
'compareselectedversions' => 'Сравнение на избраните версии',

# Search results
#
'searchresults' => 'Резултати от търсенето',
'searchresulttext' => "За повече информация относно {{SITENAME}}, вижте [[Project:Търсене|Търсене в {{SITENAME}}]].",
'searchquery'  => "За заявка \"$1\"",
'badquery'    => 'Лошо формулирана заявка за търсене',
'badquerytext'  => 'Вашата заявка не можа да бъде обработена.
Вероятно сте се опитали да търсите дума с по-малко от три букви, което все
още не се поддържа.
Възможно е и да сте сгрешили в изписването на израза, например: "риба и и везни".
Моля, опитайте с нова заявка.',
'matchtotals'  => "Заявката \"$1\" отговаря на $2 заглавия на статии
и на текста на $3 статии.",
'nogomatch' => 'Не съществуват страници с точно това заглавие, опит за пълнотекстово търсене.',
'titlematches'  => 'Съответствия в заглавията на статии',
'notitlematches' => 'Няма съответствия в заглавията на статии',
'textmatches'  => 'Съответствия в текста на статии',
'notextmatches'  => 'Няма съответствия в текста на статии',
'prevn'      => "предишни $1",
'nextn'      => "следващи $1",
'viewprevnext'  => "Преглед ($1) ($2) ($3).",
'showingresults' => "Показване на <b>$1</b> резултата, започвайки от #<b>$2</b>.",
'showingresultsnum' => "Показване на <b>$3</b> резултата, започвайки от #<b>$2</b>.",
'nonefound'    => "<strong>Забележка</strong>: безрезултатните търсения често са причинени
от това, че се търсят основни думи като \"има\" или \"от\", които не се индексират,
или от това, че се търсят повече от една думи (показват се само страници, съдържащи всички
зададени понятия).",
'powersearch' => 'Търсене',
'powersearchtext' => "
Търсене в именни пространства:<br />
$1<br />
$2 Показване на пренасочвания &nbsp; Търсене на $3 $9",
'searchdisabled' => "<p>Пълнотекстовото търсене бе временно изключено поради
голямото натоварване на сървъра.
Междувременно може да търсите чрез Google:</p>",
'googlesearch' => "
<!-- претърсване на сайта чрез Google -->
<form method='GET' action='http://www.google.com/search'>
<table bgcolor='#FFFFFF'><tr><td>
<a href='http://www.google.com/'>
<img src='http://www.google.com/logos/Logo_40wht.gif'
border='0' alt='Google'/></a>
</td>
<td>
<input type='text' name='q' size='31' maxlength='255' value='$1'/>
<input type='submit' name='btnG' value='Google Search'/>
<small>
<input type='hidden' name='domains' value='{{SERVER}}'/><br />
<input type='radio' name='sitesearch' value=''/> WWW
<input type='radio' name='sitesearch' value='{{SERVER}}' checked='checked'/> {{SERVER}} <br />
<input type='hidden' name='ie' value='$2'/>
<input type='hidden' name='oe' value='$2'/>
</small>
</td></tr></table>
</form>
<!-- претърсване на сайта чрез  Google -->

Може да използвате следната препратка, за да създадете или редактирате страницата: <a href='{{localurl:$1|action=edit}}'>$1</a>",
'blanknamespace' => '(Основно)',

# Preferences page
#
'preferences'  => 'Настройки',
'prefsnologin' => 'Не сте влезли',
'prefsnologintext'  => "Необходимо е да [[Special:Userlogin|влезете]],
за да може да променяте потребителските си настройки.",
"prefslogintext" => "Влязохте като \"$1\".
Вашият вътрешен номер e $2.

Вижте [[{{ns:4}}:Настройки|помощта за потребителските настройки]], за да се ориентирате при избора.",
'prefsreset'  => 'Стандартните настройки бяха възстановени.',
'qbsettings'  => 'Настройки на лентата за бърз избор',
'changepassword' => 'Смяна на парола',
'skin'      => 'Облик',
'math'      => 'Показване на математически формули',
'dateformat'  => 'Формат на датата',
'math_failure'    => 'Неуспех при разбора',
'math_unknown_error'  => 'непозната грешка',
'math_unknown_function'  => 'непозната функция',
'math_lexing_error'  => 'лексикална грешка',
'math_syntax_error'  => 'синтактична грешка',
'math_image_error' => 'Превръщането към PNG не сполучи. Проверете дали latex, dvips и gs са правилно инсталирани.',
'math_bad_tmpdir' => 'Невъзможно е писането или създаването на временна папка за математическите операции',
'math_bad_output' => 'Невъзможно е писането или създаването на изходяща папка за математическите операции',
'math_notexvc'  => 'Липсва изпълнимият файл на texvc. Моля, прегледайте math/README за информация относно конфигурирането.',
'prefs-personal' => 'Потребителски данни',
'prefs-rc' => 'Последни промени и мъничета',
'prefs-misc' => 'Други настройки',
'saveprefs'    => 'Съхранение на настройките',
'resetprefs'  => 'Стандартни настройки',
'oldpassword'  => 'Стара парола',
'newpassword'  => 'Нова парола',
'retypenew'    => 'Нова парола повторно',
'textboxsize'  => 'Размери на текстовата кутия',
'rows'      => 'Редове',
'columns'    => 'Колони',
'searchresultshead' => 'Настройки за резултати от търсене',
'resultsperpage' => 'Резултати на страница',
'contextlines'  => 'Редове за резултат',
'contextchars'  => 'Знаци от контекста на ред',
'stubthreshold' => 'Определяне като къси статии до',
'recentchangescount' => 'Брой заглавия в последни промени',
'savedprefs'  => 'Вашите настройки бяха съхранени.',
'timezonetext'  => 'Въведете броя часове, с които Вашето местно време се
различава от това на сървъра ([[UTC]]).',
'localtime'  => 'Местно време',
'timezoneoffset' => 'Отместване',
'servertime'  => 'Време на сървъра',
'guesstimezone' => 'Попълване чрез браузъра',
'emailflag'    => 'Забраняване на писма от други потребители',
'defaultns'    => 'Търсене в тези именни пространства по подразбиране:',

# Recent changes
#
'changes' => 'промени',
'recentchanges' => 'Последни промени',
'recentchangestext' => "Проследяване на последните промени в {{SITENAME}}.

Легенда: <b>тек</b> = разлика на текущата версия,
<b>ист</b> = история на версиите, <b>М</b>&nbsp;=&nbsp;малка промяна, <b>Н</b>&nbsp;=&nbsp;начало",
'rcloaderr'    => 'Зареждане последни промени',
'rcnote'    => "Показани са последните <strong>$1</strong> промени през последните <strong>$2</strong> дни.",
'rcnotefrom'  => "Дадени са промените от <b>$2</b> (до <b>$1</b> показани).",
'rclistfrom'  => "Показване на промени, започвайки от $1.",
# 'rclinks'    => "Показване на последните $1 промени през последните $2 часа / последните $3 дни",
# 'rclinks'    => "Показване на последните $1 промени през последните $2 дни.",
'rclinks'    => "Показване на последните $1 промени през последните $2 дни<br />$3",
'showhideminor' => "$1 на малки промени | $2 на ботове | $3 на влезли потребители | $4 patrolled edits",
'rchide'    => "$4; $1 малки промени; $2 вторични именни пространства; $3 многократни редакции.",
'rcliu'      => "; $1 редакции от влезли потребители",
'diff'      => 'разл',
'hist'      => 'ист',
'hide'      => 'скриване',
'show'      => 'показване',
'tableform'    => 'таблица',
'listform'    => 'списък',
'nchanges'    => "$1 промени",
'minoreditletter' => 'М',
'newpageletter' => 'Н',

# Upload
#
'upload'    => 'Качване',
'uploadbtn'    => 'Качване',
'uploadlink'  => 'Качване на картинки',
'reupload'    => 'Повторно качване',
'reuploaddesc'  => 'Връщане към формуляра за качване.',
'uploadnologin' => 'Не сте влезли',
'uploadnologintext'  => "Необходимо е да [[Special:Userlogin|влезете]], за да качвате файлове.",
'uploaderror'  => 'Грешка при качване',
# TODO $wgMetaNamespace - Project or NS_PROJECT
'uploadtext'  => "'''ВНИМАНИЕ!''' Преди да качите нещо,
прочетете и се придържайте към [[Project:Политика_за_използване_на_картинки|политиката за използване на картинки]].

Ако файл с указаното име вече съществува в {{SITENAME}}, то той ще бъде
заменен без предупреждение. Затова, ако не правите актуализация, първо се убедете,
че такъв файл не съществува.</p>

За да прегледате съществуващите в базата данни картинки,
разгледайте [[Special:Imagelist|списъка с качените картинки]].
Качванията и изтриванията се записват в [[Project:Дневник_на_качванията|дневника на качванията]].

Използвайте долния формуляр, за да качвате нови картинки,
които да използвате в статиите си.
В повечето браузъри ще видите бутон \"Browse...\"
(ако използвате преведен интерфейс, може да видите \"Избор на файл...\",
\"Избор...\" и др.), който ще отвори основния за вашата операционна система
диалогов прозорец за избиране на файл.
След като изберете файл, името му ще се появи в текстовото поле до бутона.
Трябва също да отметнете и кутийката, с която потвърждавате, че не
нарушавате никакви авторски права посредством качването на файла.
Натиснете бутона \"Качване\", за да завършите качването.
Това може да отнеме известно време, ако връзката Ви към Интернет е бавна.</p>
<p>Предпочитаните формати са JPEG за фотографии, PNG за рисунки и иконки и OGG за музикални файлове, като самото име на файла може да съдържа и кирилски букви, например ''Васил_Левски.jpg''. Хубаво е да дадете описателно име на файловете, за да се избегне евентуално объркване.

За да включите картинка в статия, използвайте една от следните препратки: '''<nowiki>[[{{ns:6}}:картинка.jpg]]</nowiki>''' или '''<nowiki>[[{{ns:6}}:картинка.png|алтернативен текст]]</nowiki>''' или '''<nowiki>[[{{ns:-2}}:звук.ogg]]</nowiki>''' за музикални файлове.

Моля, обърнете внимание на това, че както при страниците, останалите потребители могат да редактират или изтрият Вашите качени неща, ако сметнат, че това помага на енциклопедията, а на Вас може да Ви бъде забранено да качвате файлове, ако злоупотребявате със системата.",
'uploadlog'    => 'дневник на качванията',
'uploadlogpage' => 'Дневник_на_качванията',
'uploadlogpagetext' => 'Списък с последните качвания.
Показаните времена са според часовата зона на сървъра ([[UTC]]).',
'filename'    => 'Име на файл',
'filedesc'    => 'Описание',
'filestatus' => 'Авторско право',
'filesource' => 'Изходен код',
'copyrightpage' => "{{ns:4}}:Авторски права",
'copyrightpagename' => "авторските права в {{SITENAME}}",
'uploadedfiles'  => 'Качени файлове',
'ignorewarning'  => 'Съхраняване на файла въпреки предупрежденията.',
'minlength'    => 'Имената на картинките трябва да съдържат поне три знака.',
'badfilename'  => "Картинката бе преименувана на \"$1\".",
'badfiletype'  => "Файловият формат \".$1\" не се препоръчва за картинки.",
'largefile'    => 'Препоръчва се картинките да не надвишават 100 килобайта.',
'successfulupload' => 'Качването бе успешно',
'fileuploaded'  => "Файлът \"$1\" бе успешно качен.
Моля, последвайте препратката: ($2) към страницата за описание и
въведете малко информация за файла - кога и от кого е създаден
и всякаква друга информация, която имате за него.",
'uploadwarning' => 'Предупреждение при качване',
'savefile'    => 'Съхраняване на файл',
'uploadedimage' => "качена \"[[$1]]\"",
'uploaddisabled' => 'Съжаляваме, качванията бяха спрени.',

# Image list
#
'imagelist'    => 'Списък на картинките',
'imagelisttext'  => "Списък от $1 картинки, сортирани $2.",
'getimagelist'  => 'донасяне на списъка с картинки',
'ilsubmit'    => 'Търсене',
'showlast'    => "Показване на последните $1 картинки, сортирани $2.",
'byname'    => 'по име',
'bydate'    => 'по дата',
'bysize'    => 'по размер',
'imgdelete'    => 'изтр',
'imgdesc'    => 'опис',
'imglegend'    => 'Легенда: (опис) = показване/редактиране описание на картинка.',
'imghistory'  => 'История на картинката',
'revertimg'    => 'връщ',
'deleteimg'    => 'изтр',
'imghistlegend' => 'Легенда: (тек) = текущата картинка, (изтр) = изтриване
на съответната версия, (връщ) = възвръщане към съответната версия.
<br /><i>Щракнете върху датата, за да видите картинката, качена на тази дата</i>.',
'imagelinks'  => 'Препратки към картинката',
'linkstoimage'  => 'Следните страници сочат към картинката:',
'nolinkstoimage' => 'Няма страници, сочещи към картинката.',

# Statistics
#
'statistics'  => 'Статистика',
'sitestats'    => 'Статистика',
'userstats'    => 'Потребителска статистика',
'sitestatstext' => "Има '''$1''' страници в базата данни.
Това включва дискусионни страници, страници за {{SITENAME}}, изключително къси
страници, пренасочващи страници и други, които вероятно не са статии.
Изключвайки тези, има '''$2''' страници, които може би са действителни статии.<p>
Имало е '''$4''' редакции на страници откакто уикито бе пуснато.
Това прави средно по '''$5''' редакции на страница.

За по-подробна статистическа информация вижте:
<ul>
<li><a href='http://bg.wikipedia.org/stats'>Потребителска статистика</a>,</li>
<li><a href='http://www.wikipedia.org/wikistats/EN/Sitemap.htm'>Уики-статистика</a>,</li>
<li><a href='http://www.wikipedia.org/wiki/Wikipedia:Statistics'>Прираст</a>.</li>
</ul>",
'userstatstext' => "Има '''$1''' регистрирани потребителя. '''$2''' от тях са администратори (вижте $3).",

# Maintenance Page
#
'maintenance'    => 'Страница за поддръжка',
'maintnancepagetext'  => 'Тази страница съдържа няколко удобни инструмента за всекидневна поддръжка. Някои от тези функции доста натоварват базата данни, затова, моля, не обновявайте страницата след всяка Ваша операция, ;-)',
'maintenancebacklink'  => 'Обратно към страницата за поддръжка',
'disambiguations'  => 'Пояснителни страници',
'disambiguationspage'  => "{{ns:4}}:Препратки_към_пояснителни_страници",
'disambiguationstext'  => "Следните статии сочат към <i>пояснителна страница</i>. Вместо това те би трябвало да сочат към съответната статия.<br /> Страница се определя като <i>\"пояснителна\"</i>, ако към нея се сочи от $1.<br />Тук <i>не</i> са посочени препратки от други именни пространства.",
'doubleredirects'  => 'Двойни пренасочвания',
'doubleredirectstext' => '<b>Внимание:</b> Този списък може да съдържа лъжливи записи. Това означава, че една пренасочваща страница съдържа допълнителен текст с препратки след заповедта #REDIRECT.<br />\nВсеки ред съдържа препратки към първото и второто пренасочване, както и първия ред на текста на второто пренасочване, който обикновено посочва <i>"истинката"</i> целева статия, към която първото пренасочване би трябвало да сочи.',
'brokenredirects'  => 'Невалидни пренасочвания',
'brokenredirectstext'  => 'Следните пренасочващи страници сочат към несъществуващи статии.',
'selflinks'    => 'Страници с препратки към себе си',
'selflinkstext'    => 'Следните страници правят препратки към себе се, което не би трябвало да е така.',
'mispeelings'           => 'Страници с правописни грешки',
'mispeelingstext'  => "Следните страници съдържат основни правописни грешки, които са
изброени в $1. Правилните форми може да се посочат в скоби: (ето така).",
'mispeelingspage'       => 'Списък на основните правописни грешки',
'missinglanguagelinks'  => 'Липсващи езикови препратки',
'missinglanguagelinksbutton'    => 'Търсене на липсващи езикови препратки за',
'missinglanguagelinkstext'      => "Тези статии <i>не</i> сочат към техните копия в $1. Пренасочванията и подстраниците <i>не са</i> показани.",


# Miscellaneous special pages
#
'orphans'    => 'Страници-сираци',
'lonelypages'  => 'Страници-сираци',
'unusedimages'  => 'Неизползвани картинки',
'popularpages'  => 'Известни страници',
'nviews'    => "$1 прегледа",
'wantedpages'  => 'Желани страници',
'nlinks'    => "$1 препратки",
'allpages'    => 'Всички страници',
'randompage'  => 'Случайна страница',
'shortpages'  => 'Кратки страници',
'longpages'    => 'Дълги страници',
'deadendpages'  => 'Задънени страници',
'listusers'    => 'Списък на потребителите',
'specialpages'  => 'Специални страници',
'spheading'    => 'За всички потребители',
'protectpage'  => 'Защитена страница',
'recentchangeslinked' => 'Сродни промени',
'rclsub'    => "(на страници, сочени от \"$1\")",
'debug'      => 'Отстраняване на грешки',
'newpages'    => 'Нови страници',
'ancientpages'    => 'Стари статии',
'intl'          => 'Междуезикови препратки',
'move' => 'Преместване',
'movethispage'  => 'Преместване на страницата',
'unusedimagestext' => '<p>Моля, обърнете внимание на това, че други сайтове могат да сочат към картинката чрез пряк адрес и въпреки това тя може да се намира в списъка.',
'booksources'  => 'Източници на книги',
'booksourcetext' => 'Показани са препратки към други сайтове, които продават нови и
използвани книги и могат да имат допълнителна информация за книгите, които търсите.
{{SITENAME}} не е свързана с никоя от тези фирми и този списък не трябва да
се разглежда като подкрепа към тях.',
'isbn'  => 'ISBN',
'rfcurl' =>  "http://www.faqs.org/rfcs/rfc$1.html",
'alphaindexline' => "от $1 до $2",
'version'       => 'Версия',

# Email this user
#
'mailnologin'  => 'Няма електронна поща',
'mailnologintext' => "Необходмимо е да [[Special:Userlogin|влезете]] и да посочите валидна електронна поща в [[{{ns:-1}}:Preferences|настройките]] си, за да може да пращате писма на други потребители.",
'emailuser'    => 'Пращане писмо на потребителя',
'emailpage'    => 'Пращане писмо на потребител',
'emailpagetext'  => 'Ако потребителят е посочил валидна електронна поща в
настройките си, чрез долния формуляр може да му се изпрати съобщение.
Адресът, записан в настройките Ви, ще се появи в полето "От" на
изпратеното писмо, така че получателят ще е в състояние да Ви отговори.',
'usermailererror'  => 'Пощенският обект даде грешка: ', # Mail object returned error:
'defemailsubject'  => "Писмо от {{SITENAME}}",
'noemailtitle'  => 'Няма електронна поща',
'noemailtext'  => 'Потребителят не посочил валидна електронна поща или е избрал да не получава
писма от други потребители.',
'emailfrom'    => 'От',
'emailto'    => 'До',
'emailsubject'  => 'Относно',
'emailmessage'  => 'Съобщение',
'emailsend'    => 'Изпращане',
'emailsent'    => 'Писмото е изпратено',
'emailsenttext' => 'Писмото Ви бе изпратено.',

# Watchlist
#
'watchlist'    => 'Моят списък за наблюдение',
'watchlistsub'  => "(за потребител \"$1\")",
'nowatchlist'  => 'Списъкът Ви за наблюдение е празен.',
'watchnologin'  => 'Не сте влезли',
'watchnologintext'  => "Необходимо е да [[Special:Userlogin|влезете]], за да може да променяте списъка си за наблюдение.",
'addedwatch'  => 'Добавено в списъка за наблюдение',
'addedwatchtext' => "Страницата \"$1\" бе добавена към [[{{ns:-1}}:Watchlist|списъка Ви за наблюдение]].
Нейните бъдещи промени, както и на съответната й дискусионна страница, ще се описват там, а тя ще се появява с '''удебелен шрифт''' в
[[{{ns:-1}}:Recentchanges|списъка с последните промени]],
което ще направи по-лесно избирането й.

<p>Ако по-късно искате да премахнете страницата от списъка си за наблюдение,
щракнете на \"Спиране на наблюдение\" в страничната лента.",
'removedwatch'  => 'Премахнато от списъка за наблюдение',
'removedwatchtext' => "Страницата \"$1\" бе премахната от списъка Ви за наблюдение.",
'watch' => 'Наблюдаване',
'watchthispage'  => 'Наблюдаване на страницата',
'unwatch' => 'Спиране на наблюдение',
'unwatchthispage' => 'Спиране на наблюдение',
'notanarticle'  => 'Не е статия',
'watchnochange' => 'Никоя от наблюдаваните страници не е била редактирана в показаното време.',
'watchdetails' => "($1 наблюдавани страници (без дискусионни);
$2 редактирани страници в избраното време;
$3...
[$4 показване и редактиране на пълния списък].)",
'watchmethod-recent' => 'проверка на последните промени за наблюдавани страници',
'watchmethod-list' => 'проверка на наблюдаваните страници за скорошни редакции',
'removechecked' => 'Премахване на избраните от списъка за наблюдение',
'watchlistcontains' => "Вашият списък за наблюдение съдържа $1 страници.",
'watcheditlist' => 'Показани са наблюдаваните страници в
азбучен ред. Отметнете кутийките на страниците, които искате да премахнете
от списъка Ви за наблюдение и натиснете бутона "Премахване на избраните".',
'removingchecked' => 'Премахване на избраните от списъка за наблюдение...',
'couldntremove' => "Неуспех при премахването на '$1'...",
'iteminvalidname' => "Проблем с '$1', грешно име...",
'wlnote' => "Показани са последните $1 промени през последните <b>$2</b> часа.",
'wlshowlast' => "Показване на последните $1 часа $2 дни $3",
'wlsaved' => 'Това е съхранена версия на вашия списък за наблюдение.',

# Delete/protect/revert
#
'deletepage'  => 'Изтриване на страница',
'confirm'    => 'Потвърждение',
'excontent' => "съдържанието бе: '$1'",
'exbeforeblank' => "съдържанието преди изпразването бе: '$1'",
'exblank' => 'страницата бе празна',
'confirmdelete' => 'Потвърждение за изтриване',
'deletesub'    => "(Изтриване на \"$1\")",
'historywarning' => 'Внимание: Страницата, която ще изтриете, има история: ',
'confirmdeletetext' => "На път сте безвъзвратно да изтриете страница или картинка заедно с
цялата й история от базата данни.
Моля, потвърдете, че искате това, разбирате последствията и правите това
в съответствие с нашата [[{{ns:4}}:Линия на поведение|линия на поведение]].",
'actioncomplete' => 'Действието бе изпълнено',
'deletedtext'  => "Страницата \"$1\" беше изтрита.
Вижте $2 за запис на последните изтривания.",
"deletedarticle" => "изтрита \"$1\"",
"dellogpage"  => "Дневник_на_изтриванията",
"dellogpagetext" => 'Списък на най-скорошните изтривания.
Показаните времена са според часовата зона на сървъра ([[UTC]]).',
'deletionlog'  => 'дневника на изтриванията',
'reverted'    => 'Възвръщане към предишна версия',
'deletecomment'  => 'Причина за изтриването',
'imagereverted' => 'Възвръщането към предишна версия бе успешно.',
'rollback'    => 'Връщане назад на промените', #Roll back edits
'rollback_short' => 'Връщане',
'rollbacklink'  => 'връщане', #rollback
'rollbackfailed' => 'Връщането не сполучи', #Rollback failed
'cantrollback'  => 'Промяната не може да се извърши; последният автор е единственият собственик на статията.',
'alreadyrolled'  => "Последната редакция на [[$1]], направена от [[Потребител:$2|$2]] ([[Потребител беседа:$2|Беседа]]) не може да се върне назад; някой друг вече е редактирал статията или е върнал назад промените.

Последната редакция е на [[Потребител:$3|$3]] ([[Потребител беседа:$3|Беседа]]). ",
#   only shown if there is an edit comment
'editcomment' => "Коментарът на редакцията е бил: \"<i>$1</i>\".",
'revertpage'  => "Възвръщане към последната редакция на $1",
'protectlogpage' => 'Дневник_на_защитата',
'protectlogtext' => "Списък на защитите и техните сваляния за страницата.
За повече информация вижте [[{{ns:4}}:Защитена страница]].",
'protectedarticle' => "защитена [[$1]]",
'unprotectedarticle' => "незащитена [[$1]]",
'protectsub' => "(Защитаване на \"$1\")",
'confirmprotecttext' => 'Наистина ли искате да защитите страницата?',
'confirmprotect' => 'Потвърдете защитата',
'protectcomment' => 'Причина за защитата',
'unprotectsub' => "(Сваляне на защита на \"$1\")",
'confirmunprotecttext' => 'Наистина ли искате да свалите защитата на страницата?',
'confirmunprotect' => 'Потвърдете свалянето на защитата',
'unprotectcomment' => 'Причина за сваляне на защитата',

# Undelete
'undelete' => 'Възстановяване на изтрита страница',
'undeletepage' => 'Преглед и възстановяване на изтрити страници',
'undeletepagetext' => 'Следните страници бяха изтрити, но се намират все още
в архива и могат да бъдат възстановени. Архивът може да се почиства от време на време.',
'undeletearticle' => 'Възстановяване на изтрита статия',
'undeleterevisions' => "$1 версии архивирани",
'undeletehistory' => 'Ако възстановите страницата, всички версии ще бъдат
върнати в историята.
Ако след изтриването е създадена страница със същото име, възстановените
версии ще се появят като по-ранна история, а текущата версия на страницата
няма да бъде автоматично заменена.',
'undeleterevision' => "Изтрита версия на $1",
'undeletebtn' => 'Възстановяване!',
'undeletedarticle' => "възстановена \"$1\"",
'undeletedtext'   => "Статията [[$1]] бе успешно възстановена.
Вижте [[{{ns:4}}:Дневник_на_изтриванията|дневника на изтриванията]] за запис на последните изтривания и възстановявания.",

# Contributions
#
'contributions'  => 'Приноси',
'mycontris' => 'Моите приноси',
'contribsub'  => "За $1",
'nocontribs'  => 'Не са намерени промени, отговарящи на критерия.',
'ucnote'    => "Показани са последните <b>$1</b> промени, извършени от този потребител през последните <b>$2</b> дни.",
'uclinks'    => "Показване на последните $1 промени; показване на последните $2 дни.",
'uctop'    => ' (последна)' ,

# What links here
#
'whatlinkshere'  => 'Какво сочи насам',
'notargettitle' => 'Няма цел',
'notargettext'  => 'Не указахте целева страница или потребител,
върху която/който да се изпълни действието.',
'linklistsub'  => '(Списък с препратки)',
'linkshere'    => 'Следните страници сочат насам:',
'nolinkshere'  => 'Няма страници, сочещи насам.',
'isredirect'  => 'пренасочваща страница',

# Block/unblock IP
#
'blockip'    => 'Блокиране на потребител',
'blockiptext'  => "Използвайте долния формуляр, за да забраните правото на писане
на определен IP-адрес или потребител.
Това трябва да се направи само, за да се предотвратят прояви на вандализъм,
и в съответствие с [[{{ns:4}}:Линия_на_поведение|линията на поведение]] на {{SITENAME}}.
Посочете също и причина за блокирането (например, заглавия на страници,
станали обект на вандализъм).

Времето за изтичане на блокирането се въвежда според установения ГНУ-формат, описан в [http://www.gnu.org/software/tar/manual/html_chapter/tar_7.html ръководството], например: '1 hour', '2 days', 'next Wednesday', '1 January 2017'. Неограничено блокиране може да се зададе чрез 'indefinite' или 'infinite'.",
'ipaddress'    => 'IP-адрес/потребител',
'ipbexpiry'    => 'Изтичане на срока',
'ipbreason'    => 'Причина',
'ipbsubmit'    => 'Блокиране на потребителя',
'badipaddress'  => 'Невалиден IP-адрес или грешно име на потребител',
'blockipsuccesssub' => 'Блокирането бе успешно',
'blockipsuccesstext' => "\"$1\" беше блокиран.
<br />Вижте [[{{ns:-1}}:Ipblocklist|списъка на блокираните IP-адреси]], за да прегледате блокираните.",
'unblockip'    => 'Отблокиране на потребител',
'unblockiptext'  => 'Използвайте долния формуляр, за да възстановите
правото на писане на по-рано блокиран IP-адрес или потребител.',
'ipusubmit'    => 'Отблокиране на адреса',
'ipusuccess'  => "\"$1\" бе отблокиран",
'ipblocklist'  => 'Списък на блокирани IP-адреси и потребители',
'blocklistline'  => "$1, $2 е блокирал $3 ($4)",
'infiniteblock' => 'изтича на infinite', //fixme
'expiringblock' => 'изтича на $1',
'blocklink'    => 'блокиране',
'unblocklink'  => 'отблокиране',
'contribslink'  => 'приноси',
'autoblocker'  => "Автоматично блокиране поради взаимно ползване на IP-адрес с \"$1\". Причина \"$2\".",
'blocklogpage'  => 'Дневник_на_блокиранията',
'blocklogentry' => 'блокиране на "$1" със срок на изтичане $2',
'blocklogtext'  => "Това е дневник на блокиранията и отблокиранията, извършени от този потребител. Автоматично блокираните IP-адреси не са показани. Вижте  [[{{ns:-1}}:Ipblocklist|списъка на блокираните IP-адреси]] за текущото състояние
на блокиранията.",
'unblocklogentry'       => 'отблокиране на "$1"',
'range_block_disabled'  => 'Възможността на администраторите да задават интервали (<i>range blocks</i>) е изключена.',
'ipb_expiry_invalid'    => 'Невалиден срок на изтичане.',
'ip_range_invalid'      => "Невалидни граници за IP-адреси.\n",
'proxyblocker'  => 'Блокировач на проксита',
'proxyblockreason'      => 'Вашият IP-адрес беше блокиран, тъй като е отворено прокси. Моля, свържете се с Вашия интернет-доставчик и го информирайте за този сериозен проблем в сигурността.',
'proxyblocksuccess'     => "Готово.\n",

# Developer tools
#
'lockdb'    => 'Заключване на базата данни',
'unlockdb'    => 'Отключване на базата данни',
'lockdbtext'  => 'Заключването на базата данни ще попречи на всички
потребители да редактират страници, да сменят своите настройки, да редактират
своите списъци за наблюдение и на всички други техни действия, изискващи
промени в базата данни.
Моля, потвърдете, че искате точно това и ще отключите базата данни,
когато привършите с работата по подръжката.',
'unlockdbtext'  => 'Отключването на базата данни ще възстанови способността на
потребителите да редактират страници, да сменят своите настройки, да редактират
своите списъци за наблюдение и изпълнението на всички други действия, изискващи
промени в базата данни.
Моля, потвърдете, че искате точно това.',
'lockconfirm'  => 'Да, наистина искам да заключа базата данни.',
'unlockconfirm'  => 'Да, наистина искам да отключа базата данни.',
'lockbtn'    => 'Заключване на базата данни',
'unlockbtn'    => 'Отключване на базата данни',
'locknoconfirm' => 'Не сте отметнали кутийката за потвърждение.',
'lockdbsuccesssub' => 'Заключване на базата данни успешно',
'unlockdbsuccesssub' => 'Отключване на базата данни успешно',
'lockdbsuccesstext' => "Базата данни на {{SITENAME}} бе заключена.
<br />Не забравяйте да отключите базата данни, когато привършите с работата по поддръжката.",
'unlockdbsuccesstext' => "Базата данни на {{SITENAME}} бе отключена.",

# Make sysop
'makesysoptitle'        => 'Превръщане на потребител в администратор',
'makesysoptext'         => 'Този формуляр се използва от бюрократи за превръщане на обикновени потребители в администратори.

Въведете името на потребителя в полето и натиснете бутона, за да направите съответния потребител администратор',
'makesysopname'         => 'Име на потребителя:',
'makesysopsubmit'       => 'Превръщане на потребителя в администратор',
'makesysopok'           => "<b>Потребителят '$1' бе направен администратор</b>.",
'makesysopfail'         => "<b>Потребителят '$1' не бе направен администратор. (Правилно ли въведохте името?)</b>",
'setbureaucratflag' => 'Вдигане на флага "бюрократ"',
'bureaucratlog'         => 'Дневник_на_бюрократите',
'bureaucratlogentry'    => "Права за потребителя \"$1\": \"$2\"",
'rights'                => 'Права:',
'set_user_rights'       => 'Даване на потребителски права',
'user_rights_set'       => "<b>Потребителските права за \"$1\" са променени</b>",
'set_rights_fail'       => "<b>Потребителските права за \"$1\" не бяха променени. (Правилно ли въведохте името?)</b>",
'makesysop'             => 'Превръщане на потребител в администратор',
# Move page
#
'movepage'    => 'Преместване на страница',
'movepagetext'  => "Посредством долния формуляр може да преименувате
страница, премествайки цялата й история на новото име.
Старото заглавие ще се превърне в пренасочваща страница.
Препратките към старата страница няма да бъдат променени; затова
проверете за двойни или невалидни пренасочвания.
Вие сами би трябвало да се убедите в това, дали препратките продължават да сочат там,
където се предполага.

Страницата '''няма''' да бъде преместена, ако вече съществува страница с
новото име, освен ако е празна или пренасочване и няма редакционна история.

<b>ВНИМАНИЕ!</b>
Това може да е голяма и неочаквана промяна за известна страница;
моля, уверете се, че разбирате последствията, преди да продължите.",
"movepagetalktext" => "Съответната дискусионна страница, ако съществува,
ще бъде автоматично преместена заедно с нея, '''освен ако:'''
*не местите страницата от едно именно пространство в друго,
*вече съществува непразна дискусионна страница с това име или
*не сте отметнали долната кутийка.

В тези случаи, ако желаете, ще е необходимо да преместите страницата ръчно.",
'movearticle'  => 'Преместване на страница',
'movenologin'  => 'Не сте влезли',
'movenologintext' => "Необходимо е да [[Special:Userlogin|влезете]], за да може да премествате страници.",
'newtitle'    => 'Към ново заглавие',
'movepagebtn'  => 'Преместване',
'pagemovedsub'  => 'Преместването бе успешно',
'pagemovedtext' => "Страницата \"[[$1]]\" бе преместена под името \"[[$2]]\".",
'articleexists' => "Вече съществува страница с това име или името, което сте избрали,
е невалидно. Моля, изберете друго име.",
'talkexists'  => 'Страницата бе успешно преместена, но без
съответната дискусионна страница, защото под новото име
има една съществуваща. Моля, обединете ги ръчно.',
'movedto'    => 'преместена като',
'movetalk'    => 'Преместване и на дискусионната страница, ако е приложимо.',
'talkpagemoved' => 'Съответната дискусионна страница също бе преместена.',
'talkpagenotmoved' => 'Съответната дискусионна страница <strong>не</strong> бе преместена.',
'1movedto2' => "$1 преместена като $2",

# Export
'export'     => 'Изнасяне на страници',
'exporttext'    => 'Тук може да изнесете като XML текста и историята на една или повече страници. Получените данни може да:
<ul>
<li>вмъкнете в друг сайт, използващ софтуера на МедияУики, </li>
<li>обработвате или </li>
<li>просто запазите за лично ползване.</li>
</ul>

Въвеждайте всяко ново заглавие на статия на <b>нов ред</b>.',
'exportcuronly' => 'Включване само на текущата версия, а не на цялата история',

# Namespace 8 related

'allmessages'   => 'Всички системни съобщения',
'allmessagestext' => 'Това е списък на всички системни съобщения, намиращи се в именното пространство МедияУики',

# Thumbnails

'thumbnail-more' => 'Увеличаване',
'missingimage'   => "<b>Липсваща картинка</b><br /><i>$1</i>\n",

# Special:Import
'import'        => 'Внасяне на страници',
'importtext'    => 'Моля, изнесете файла от изходното уики, използвайки инструмента {{ns:-1}}:Export, съхранете го на Вашия диск и го качете тук.',
'importfailed'  => "Внасянето пропадна: $1",
'importnotext'  => 'Празно',
'importsuccess' => 'Внасянето бе успешно!',
'importhistoryconflict' => 'Съществува версия от историята, която си противоречи с тази (възможно е страницата да е била вече внесена)',

# Keyboard access keys for power users
'accesskey-search' => 's',
'accesskey-minoredit' => 'i',
'accesskey-save' => 's',
'accesskey-preview' => 'p',
'accesskey-contributions' => '',
'accesskey-emailuser' => '',
'accesskey-compareselectedversions' => 'v',

# tooltip help for the main actions
'tooltip-watch' => 'Добавяне на страницата към списъка Ви за наблюдение [alt-w]',
'tooltip-search' => 'Търсене в Уикито',
'tooltip-minoredit' => 'Отбелязване на промяната като малка [alt-i]',
'tooltip-save' => 'Съхраняване на промените [alt-s]',
'tooltip-preview' => 'Предварителен преглед, моля, използвайте го преди да съхраните! [alt-p]',
'tooltip-compareselectedversions' => 'Показване на разликите между двете избрани версии на страницата [alt-v]',

# Metadata
'nodublincore' => 'Dublin Core RDF metadata disabled for this server.',
'nocreativecommons' => 'Creative Commons RDF metadata disabled for this server.',
'notacceptable' => 'Сървърът не може да предостави данни във формат, който да се разпознава от клиента Ви.',

# Attribution

'anonymous' => "Анонимен потребител(и) на {{SITENAME}}",
'siteuser'  => "потребителя на {{SITENAME}} $1",
"lastmodifiedby" => "Последна промяна на $1 от $2.",
'and' => 'и',
"othercontribs" => "Основано върху работа на $1.",
"siteusers" => "потребителите на {{SITENAME}} $1",

# Math
  'mw_math_png'    => 'Използване винаги на PNG',
  'mw_math_simple' => 'HTML при опростен TeX, иначе PNG',
  'mw_math_html'   => 'HTML по възможност, иначе PNG',
  'mw_math_source' => 'Оставяне като TeX (за текстови браузъри)',
  'mw_math_modern' => 'Препоръчително за нови браузъри',
  'mw_math_mathml' => 'MathML по възможност (експериментално)'
);

/** This is an UTF-8 language */
require_once( 'LanguageUtf8.php' );

/**
 * @package MediaWiki
 * @subpackage Language
 */
class LanguageBg extends LanguageUtf8 {

	function getBookstoreList () {
		global $wgBookstoreListBg ;
		return $wgBookstoreListBg ;
	}

	function getNamespaces() {
		global $wgNamespaceNamesBg;
		return $wgNamespaceNamesBg;
	}

	function getQuickbarSettings() {
		global $wgQuickbarSettingsBg;
		return $wgQuickbarSettingsBg;
	}

	function getSkinNames() {
		global $wgSkinNamesBg;
		return $wgSkinNamesBg;
	}

	function getDateFormats() {
		global $wgDateFormatsBg;
		return $wgDateFormatsBg;
	}

	function getMessage( $key ) {
		global $wgAllMessagesBg;
		if( isset( $wgAllMessagesBg[$key] ) ) {
			return $wgAllMessagesBg[$key];
		} else {
			return parent::getMessage( $key );
		}
	}

	function getMagicWords()  {
		global $wgMagicWordsBg;
		return $wgMagicWordsBg;
	}
}
?>
