
from xml.dom import *
from xml.dom.ext.reader.Sax import FromXmlFile
import sys
import os
import time


def extractWidget(file, node):
    w= node.firstChild
    l=[]
    while w:
        if w.nodeName == "widget":
            c= w.firstChild
            label= None
            while c:
                if c.nodeName == "property":
                    if c.getAttribute("translatable")=="yes":
                        if c.firstChild:
                            label= c.firstChild.nodeValue
                elif c.nodeName == "child":
                    l+= extractWidget(file, c)
                c= c.nextSibling
            if label:
                l.append((label, os.path.split(file)[1], w.getAttribute("class"), w.getAttribute("id")))
        w= w.nextSibling

    return l

except_file= None
for f in sys.argv[1:]:
        if f.startswith("--except-from="):
                sys.argv.remove(f)
                except_file= f[f.find("=")+1:]
		break

def read_po_file(file):
        lines= open(file).readlines()
        messages=[]
        msg= ""
        for line in lines:
                if msg == "":
                        if line.startswith("msgid"):
                                msg= line[6:].strip()
                else:
                        if line.startswith("msgstr"):
                                messages.append(msg)
                                msg= ""
                        else:
                                msg+= "\n"+line.strip()
        return messages


if except_file:
        dupe_msgs= read_po_file(except_file)
else:
        dupe_msgs= []



everything= []
for file in sys.argv[1:]:
    print>>sys.stderr, "parsing %s..."%file
    doc= FromXmlFile(file)
    print>>sys.stderr, "processing..."
    everything+= extractWidget(file, doc.getElementsByTagName("glade-interface")[0])

def comp(a,b):
    if a[0] < b[0]:
        return -1
    elif a[0] > b[0]:
        return 1
    return 0

everything.sort(comp)


f= sys.stdout


if 1:
##    f.write(
##        '''# automatically generated
### Copyright (C) 2005 MySQL AB
###
##msgid ""
##msgstr ""
##"Project-Id-Version: PACKAGE VERSION\\n"
##"Report-Msgid-Bugs-To: http://bugs.mysql.com\\n"
##"POT-Creation-Date: %(date)s\\n"
##"PO-Revision-Date: %(date)s\\n"
##"Last-Translator: Somebody <your.email@address.com>\\n"
##"Language-Team: LANGUAGE <LL@li.org>\\n"
##"MIME-Version: 1.0\\n"
##"Content-Type: text/plain; charset=UTF-8\\n"
##"Content-Transfer-Encoding: 8bit\\n"
##
##''' % {"src":os.path.split(sys.argv[1])[1], "date":time.strftime("%F %T")})

    l= everything

    same= []
    while l:
        item= l[0]
        del l[0]
        if same and item[0] != same[0][0]:
            msgid= ""
            if "\n" in same[0][0]:
                msgid= "msgid \"\"\n"+"".join(['"%s"\n'%x for x in same[0][0].replace('"', '\\"').split("\n")])
            else:
                msgid= "msgid "+"".join(['"%s"\n'%x for x in same[0][0].replace('"', '\\"').split("\n")])

            if msgid[5:].strip() not in dupe_msgs:
                f.write("#. %s\n"%"..".join(['%s:%s:%s'%x[1:] for x in same]))
                f.write(msgid)
                f.write("msgstr \"\"\n")
                f.write("\n")
            same= [item]
        else:
            same.append(item)

    f.write("#. %s\n"%"..".join(['%s:%s:%s'%x[1:] for x in same]))
    if "\n" in same[0][0]:
        f.write("msgid \"\"\n"+"".join(['"%s"\n'%x for x in same[0][0].replace('"', '\\"').split("\n")]))
    else:
        f.write("msgid "+"".join(['"%s"\n'%x for x in same[0][0].replace('"', '\\"').split("\n")]))
    f.write("msgstr \"\"\n")
    f.write("\n")

    f.close()

