#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Generate .h file.
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out


def begin(events):
    out('/* This file is autogenerated by tracetool, do not edit. */',
        '',
        '#ifndef TRACE_H',
        '#define TRACE_H',
        '',
        '#include "qemu-common.h"')

def end(events):
    for e in events:
        if "disable" in e.properties:
            enabled = 0
        else:
            enabled = 1
        out('#define TRACE_%s_ENABLED %d' % (e.name.upper(), enabled))
    out('',
        '#endif /* TRACE_H */')

def nop(events):
    for e in events:
        out('',
            'static inline void trace_%(name)s(%(args)s)',
            '{',
            '}',
            name = e.name,
            args = e.args,
            )
