/*
	Description: macro handling

	Author: Marco Costalba (C) 2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef MACROIMPL_H
#define MACROIMPL_H

#include "macrobase.h"

class MacroImpl : public Macro {
Q_OBJECT
public:
	MacroImpl();

signals:
	void macroListChanged(const QStringList&);

protected slots:
	void listViewNames_currentChanged(QListViewItem*);
	void pushButtonNew_clicked();
	void pushButtonRename_clicked();
	void pushButtonRemove_clicked();
	void pushButtonMoveUp_clicked();
	void pushButtonMoveDown_clicked();
	void checkBoxRefreshAfterMacro_toggled(bool);
	void checkBoxAskArgs_toggled(bool);
	void textEditMacro_textChanged();
	void pushButtonOk_clicked();

private:
	void updateMacroList();
	bool getNewName(QString& name, const QString& caption);
	void loadMacro(const QString& macroName);
	void removeMacro(const QString& macroName);

	QStringList macroList;
	QString curMacro;
};

#endif

