#!/usr/bin/perl -w

# apt-cacher-cleanup.pl
# Script to clean the cache for the Apt-cacher package caching system.
# For more information visit www.apt-cacher.org
#
# Copyright (C) 2005, Eduard Bloch <blade@debian.org>
# Copyright (C) 2002-03, Jonathan Oxer <jon@debian.org>
# Portions  (C) 2002, Jacob Lundberg <jacob@chaos2.org>
# Distributed under the terms of the GNU Public Licence (GPL).


# add one argument like 1 to make it verbose

# do locking, not loosing files because someone redownloaded the index files
# right then
# use IO::Handle;
use Fcntl ':flock';
use IO::Handle;
use POSIX;

for(@ARGV) {
   if($_ eq "-n") { $nice_mode=1; }
   elsif ($_ eq "-v") { $verbose=1;}
   else {
      die <<EOM
Usage: $0 [ -n ] [ -v ]
      -n : nice mode, refresh index files first, then renice to 20 and continue
      -v : verbose mode
EOM
      ;
   }
}

sub printmsg {
   print @_ if $verbose;
}

#use strict;
#############################################################################
### configuration ###########################################################
# Include the library for the config file parser
require '/usr/share/apt-cacher/apt-cacher-lib.pl';

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';

my $configref;
eval {
        $configref = read_config($configfile);
};
my %config = %$configref;

# not sure what to do if we can't read the config file...
die "Could not read config file: $@" if $@;

# check whether we're actually meant to clean the cache
if ( $config{clean_cache} ne 1 ) {
	exit 0;
}

#############################################################################

my $refresh=1;

#my %valid;

@info = stat $config{cache_dir};

#if ($< != $info[4]) {
#   $refresh=0;
#   print "Not running with apt-cacher's user ID, won't refresh the index files.
#Try sth. like su -c /usr/share/apt-cacherapt-cacher-cleanup.pl www-data
#";
#   # that's not critical, will just hurt the apt-qupdate/apt-dupdate users
#}
#
#
### Preparation of the package lists ########################################

chdir "$config{cache_dir}/packages" && -w "." || die "Could not enter the cache dir";

@ifiles=(<*es.gz>, <*es.bz2>, <*es>);
for (@ifiles) {
   printmsg "Processing index: $_\n";
   die "Someone is cheating, bad filename found: $_" if /[^.\-\w]/;

   # preserve the index files
   $valid{$_}=1;

   # now refresh them, unless disabled by the setting above
   if($refresh) {
      $ENV{"REMOTE_ADDR"}="local";
      # if the path is stored there, better use that
      if(-s "../private/$_.complete") {
         open(my $tmp, "../private/$_.complete");
         $ENV{"PATH_INFO"}=<$tmp>;
         close $tmp;
      }
      if(!$ENV{"PATH_INFO"}) {
         my $tmp=$_;
         $tmp=~s/^/\//;
         $tmp=~s/_/\//;
      }
      if($ENV{"PATH_INFO"}) {
         system "/usr/share/apt-cacher/apt-cacher.pl >/dev/null";
         # fix the permissions, apt-cacher can have been executed as root
         chown $info[4], $info[5], $_, "../private/$_.complete", "../headers/$_";
      }
   }
}

setpriority 0, 0, 20 if $nice_mode;

# use the list of config files we already know
for(@ifiles) { extract_sums($_, \%valid);}

printmsg "Found ".scalar (keys %valid)." valid file entries\n";
#print join("\n",keys %valid);

for(<*.deb>, <*.bz2>, <*.gz>, <*.dsc>) {
   if(! defined($valid{$_})) {
      unlink $_, "../headers/$_", "../private/$_.complete";
      printmsg "Removing: $_ and company...\n";
   }
}

# similar thing for possibly remaining cruft
chdir "$config{cache_dir}/headers" && -w "." || die "Could not enter the cache dir";

for(<*.deb>, <*.bz2>, <*.gz>, <*.dsc>) {
   if(! defined($valid{$_})) {
      unlink $_, "../private/$_.complete";
      printmsg "Removing: $_ and company...\n";
   }
}

chdir "$config{cache_dir}/private" && -w "." || die "Could not enter the cache dir";
for(<*.deb.complete>, <*.bz2.complete>, <*.gz.complete>, <*.dsc.complete>) {
   s/.complete$//;
   if(! defined($valid{$_})) {
      printmsg "Removing: $_.complete\n";
      unlink "$_.complete";
   }
}
