/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * libp2papplication - application in P2P, doing things.
 *
 *$Id: dmachinemon-libp2papplication.c,v 1.36 2002/12/20 07:54:00 dancer Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "dmachinemon/dmachinemon.h"

static int nodeport;
static int clientport;

#define malloc_with_error(A,BYTES,ERROR) if (NULL==((A)=malloc(BYTES)))\
{fprintf(stderr, "out of memory in allocating %i bytes\n", BYTES);return ERROR ;}

#define LOCALHOST "localhost"

int
DNAS_Init (int * ac /** &argc */
	   , char *** av /** &argv */ ,
	   dm_commandoption* p2pcdat /** command line parameter option */
	     )
{
  int fd;
  
  dmachinemon_parse_options(*ac, *av, p2pcdat);

  nodeport = atoi(p2pcdat->port_nodes);
  clientport = atoi(p2pcdat->port_client);
  
  fd = dm_connect_to_host(LOCALHOST, nodeport);
  if (fd == -1)
    {
      char * s = dm_gethostname_versatile();
      fprintf (stderr, "dm_Init-error [%s]: error ... cannot link to %s.\n", s, LOCALHOST);
      if (s) free(s);
      return 1;
    }

  dm_obtain_route (fd, 0, NULL);
  close (fd);

  /* debug. */
  if (p2pcdat->debuglevel > 10 ) 
    {
      char *s;
      s = dm_get_route();
      if (s) 
	{
	  fprintf(stderr, "DEBUG: Route is :[%s] \n", s);
	  free (s);
	}
      else
	{
	  fprintf(stderr, "DEBUG: Route is NULL\n");
	}
    }

  return 0;
}

int DNAS_Finalize(dm_commandoption* d)
{
  return 0;
}

int DNAS_sendinfo (const char * TAG, /** TAG to identify information */
		 const char * string /** The information string. */,
		 dm_commandoption* p2pcdat /** command line parameter option */
		 )
{
  int fd = dm_connect_to_host(LOCALHOST, nodeport);
  FILE*f ;
  char * this_hostname = NULL;
  if (fd == -1)
    {
      fprintf (stderr, "Error: error ... cannot link to %s.\n", LOCALHOST);
      return 1;
    }

  dm_obtain_route (fd, 0, NULL);
  f = fdopen (fd, "w");
  if (!f)
    {
      fprintf (stderr, "Error: cannot fdopen to [%s] although open succeeded.\n", LOCALHOST);
      close (fd);
      return 1;
    }
 
  if (NULL != (this_hostname = dm_gethostname_versatile ()))
    {
      fprintf (f, 
	       ":%s:\n"
	       SEEN_BY ": localhost\n"
	       "%s: %s\n", this_hostname, TAG, string);
      free(this_hostname);
    }
  
  fclose (f);

  return 0;
}


dm_machinelist_information myinfo = {NULL, PTHREAD_MUTEX_INITIALIZER};

char ** 
DNAS_gatherinfo (const char * TAG /** Name of tag to search for */,
		 dm_commandoption* p2pcdat /** command line parameter option */
		       ) 
{
  char ** buf = NULL;
  char * grandparentlink = dm_obtain_grandparent_host();
  int fd;
  FILE * f;  
  int membercount = 0 ;
  int currentcount = 0;
  const char * curinfo ;
  
  dm_machinelist * thismachine = NULL;

  if (!grandparentlink)
    {
      fprintf(stderr, "DEBUG: grandparent link has not been established yet\n");
      return NULL;
    }
  
  fd = DNAS_connect_to_host (p2pcdat, grandparentlink, clientport, 0);
  f= (fd!=-1)?fdopen(fd,"r"):NULL;

  if (!f)
    {
      fprintf (stderr, "dm-p2p: error: cannot link to grandparent [%s].\n", grandparentlink);
      if (fd == -1)
	fprintf (stderr, "dm-p2p: diagnosis: DNAS_connect_to_host failed.\n" );
      else
	close(fd);
      free (grandparentlink);
      return NULL;
    }

  dm_process_nodes_input (f, &myinfo, NULL, NULL);
  membercount = dm_count_nodes_number (&myinfo);
  malloc_with_error (buf, sizeof (char*) * membercount + 1, NULL); 

  for (thismachine = myinfo.machinedb; thismachine; thismachine = thismachine -> next)
    {
				/* gather the info... */
      if (0!=(curinfo=dm_get_value_text (thismachine, TAG)))
	{
	  (*(buf + currentcount++)) = strdup(curinfo);
	}
    }
  
  if ((membercount + 1) <= currentcount)
    {
      fprintf (stderr, "Fatal logic error, buffer overrun in DNAS_gatherinfo\n");
      exit (1);
    }
    
  *(buf + currentcount) = 0;
  fclose(f);
  free (grandparentlink);
  return buf;
}

void
DNAS_freeinfo(char ** m)
{
  int i= 0;
  while (m[i])
      free (m[i++]);
  free (m);
}



