//
// $Id: scenario.cc,v 1.13 2002/11/07 23:40:26 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/scenario.cc,v $
// $Revision: 1.13 $
// $Date: 2002/11/07 23:40:26 $
// $State: Exp $
//
// Author: Geoff Wong, 1996-2001.
// Note: Code used (modified) from "Advanced Unix Programming" by Stevens.
//
// 20010710 Robert Nielson - POST verbose and better cookie handling
//
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>
#include <sys/errno.h>

#include "result.h"
#include "str.h"
#include "scenario.h"
#include "dictionary.h"

#include "statistics.h"

#include "config.h"
#include "str.h"

#include "connection.h"

#define MAX_LINE 4096
// #define VERBOSE  // Define this is you want to see outgoing/incoming data
                    // spewing past on the output console

#if 0
extern int operator==(const Dictionary<Scenario *>::iterator& it1,
               const Dictionary<Scenario *>::iterator& it2);
#endif


Dictionary<Scenario *> Scenario::SCN;
Dictionary<Scenario *> Scenario::SEQ;
Dictionary<String *> Scenario::allRequests;
Dictionary<list<String> *> Scenario::allExpected;
FILE * Scenario::logStream = 0;
FILE * Scenario::reportStream = 0;

int Scenario::lineNum = 0;

bool Scenario::Restore(const char * nme, FILE * fp)
{
    String str;
    String *strP = 0;
    char inbuf[MAX_LINE+1], * buf;
    char shortname[MAX_LINE];
    int x, sl;
    list<String> *newExpected = 0;

    if ((x = strlen(nme)) > 4)
    {
        strncpy(shortname, nme, x - 4);
        shortname[x-4] = 0;
        name = shortname;
    }


    bool endedInDot = false;
    request = 0;
    bool ignoreExpected = false;

    while (!endedInDot &&  fgets(inbuf, MAX_LINE, fp) != NULL)
    {
        lineNum++;

        // ignore empty lines
        if ((sl = strlen(inbuf)) <= 1) continue;            

        // chop off eol 
        inbuf[sl-1] = 0;         

        // FIX: should we top and tail whitespace?
        buf = &(inbuf[1]);

        switch (inbuf[0])
        {
        case 'N':        /*  name of scenario */
            name = strip_trailing_whitespace(buf);
            break;
        case 'D':        /* dependencies to be met */
            str = buf;
            dependency.push_back(str);
            break;
        case 'R':        /* request to be made */
            {
                // strip off http protocol string
                char *httpIdx = strstr(buf, "HTTP/1");
                if (httpIdx != 0)
                {
                    *httpIdx = '\0';
                }

                if (allRequests.exists(buf))
                {
                    request = allRequests[buf];
                }
                else
                {
                    String *newReq = new String(buf);
                    allRequests[buf] = newReq;
                    request = newReq;
                }
                // the URL could also be check for which protocol (if any) is
                // being requested. but that's perhaps not as flexible...

                // Ok - find the request base for relative loads
                int bs,be;

                request_base = "/";
                bs = (*request).find(' ');
                be = (*request).rfind('/');
                if (bs != -1 && be != -1)
                {
                    request_base = (*request).substr(bs+1,be-bs);
                }

                break;
            }
        case 'H':   /* header lines */
            {
                if (header.empty() == true) header = buf;
                else header = header + "\r\n" + buf;
                break;
            }
        case 'B':   /* body lines */
            {
                if (body.empty() == true) body = buf;
                else body = body + "\r\n" + buf;
                break;
            }
        case 'E':		/* expected output lines */
            // only save the string if we don't already have a result
            // for the request string
            if (request == 0)
            {
                String tmpstr;
                if (!ignoreExpected)
                {
                    Log("Expected results must follow request. Ignoring expected results for Scenario \""
                        + name + "\", line " + itoa(lineNum) + " onwards");
                    ignoreExpected = true;
                }
            }
            else if (!allExpected.exists(request->c_str()))
            {
                str = buf;
                if (newExpected == 0)
                {
                    newExpected = new list<String>;
                }
                newExpected->push_back(str);
            }
            break;
        case 'L':        /* expected log result */
            log_expected = buf;
            break;
        case 'S':        /* scenario recommended in sequence */
            //            printf("sequences %s\n", str.c_str());
            strP = new String(buf);
            next.push_back(strP);
            break;
        case 'T':        /* think time (milliseconds) */
            if (buf == "_exit") 
            {
                // it's an exiting scenario
                terminate = true;
            }
            else if (buf[0] == '+')
            {
                // sleep until a fixed point (from StartedTime)
                wait_until = StartedTime + atoi(&buf[1]) * 1000;
            }
            else
            {
                // else we just sleep for a while :)
                think = atoi(buf);
                if (think > ThinkLimit)
                {
                    fprintf(stderr,
                        "Warning: %s think time (%d) greater than %d, line %d\n",
                        name.c_str(), think, ThinkLimit, lineNum);
                }
            }
            break;
        case 'X':        /* number of xrefs allowed for this scenario */
            xrefsAllowed = atoi(buf);
            break;
        case '.':        /* end of scenario */
            endedInDot = true;
            break;
        case '#':        /* ignore comment */
            break;
        case 'O': /* scenario options */
            char *ap;
            char *key;
            char *val;
            for(; (ap = strsep(&buf, " ,")) != NULL;)
            {
                key = ap;
                val = ap;

                /* we can have single key words here or assignment expressions
                    like ssl_port=443 */
                strsep(&val, "=");

                if (strcasecmp(key, "SSL") == 0)
                {
                    if (strcasecmp(val, "on") == 0)
                    {
                        /* this does not change the destinaton port. Whether it
                            should is subject to debate. You can always used the
                            'port=...' directive for force use of a particular
                            destination port. 

                            The default port (contained in the session object will
                            be used. It may well be an ssl port or a clear port. */
#ifdef HAVE_SSL
                        use_ssl = 1;
#else
                        fprintf(stderr, "SSL not compiled in. Ignoring option.\n");
#endif
                    }
                    else /* turn ssl off */
                    {
                        use_ssl = 0;
                    }
                }
                else if (strcasecmp(key,"PORT") == 0)
                {
                    port = atoi(val);
                    fprintf(stderr, "Changing to port %d for scenario %s\n", port, name.c_str());
                }
                else
                {
                    fprintf(stderr, "Unknown scenario option (%s).\n", ap);
                }
            }

            break;
        default:
            fprintf(stderr,
                    "Warning: Unknown tag \'%c\'<%d> in scenario \"%s\", line %d: \"%s\"\n",
                    inbuf[0], inbuf[0], name.c_str(), lineNum, inbuf);
            break;
        }
    }

    //
    if (request != 0 && !request->empty())
    {
        if (allExpected.exists(request->c_str()))
        {
            expected = allExpected[request->c_str()];
        }
        else
        {
            allExpected[request->c_str()] = newExpected;
            expected = newExpected;
        }
#if 0
        if (next.empty() == false)
        {
            nposition = next.begin();
        }
#endif
    }
    return endedInDot;
}

/*
 * NAME: verify
 * PURPOSE: compare the output lines in Result with the
 *    expected lines in this scenario
 */
bool Scenario::Verify(Session * sess, Result * r)
{
    int expl, resl;
    list<String>::iterator i, j;
    String el, rl;

    if (r == 0)
    {
        return false;
    }
    if (sess == 0)
    {
        return false;
    }

    if (expected == 0)
    {
        // if there is no expected result, then assume anything is ok...
        return true;
    }

    expl = expected->size();
    resl = r->buffer.size();

    if (resl < expl)
    {
        return false;
    }

    j = r->buffer.begin();
    for (i = expected->begin(); i != expected->end(); i++)
    {
        el = (*i);
        rl = (*j);
        if ( el == rl )
        {
            j++;
        }
        else
        {
            Log(itoa(sess->pin)+": Verify failed:" + 
                request->c_str() + " :" +
                el + ":" + rl);
            return false;
        }
    }

    return true;
}

/*
 * NAME:        Connect Factory
 * ACTION:        Construct a connection object to do the request.
 * RETURNS:        Connection *
 */
Connection *Scenario::ConnectionFactory(Session *sess)
{
    /* this method creates a connection object as per
       hammer's config and the scenario request. */

    Connection *c = NULL;

    /*
    fprintf(stderr, "UseSSLLayer = %d\n", UseSSLLayer);
    fprintf(stderr, "sess->scenario->use_ssl = %d\n", sess->scenario->use_ssl);
    */


    /* SSL connection */
    /* use ssl for this request */
    if (!sess->scenario->use_ssl) 
    {
        c = new Clear_Connection(sess);
    } 
#ifdef HAVE_SSL
    /*
    else if (next connection type)
    {
    }
    */
    else /* default is to use http in the clear... */
    {
        c = new SSL_Connection(sess);
    }
#endif

    /* establish the connection */
    if (c->connect()) 
    {
        /* connection failed */
        delete c;
        return NULL;
    }

    return c;
}

/*
 * NAME:    Request
 * PURPOSE: Make a scenario request
 */
Result * Scenario::Request(Session * sess)
{
    Connection *ReqStream;
    char ReturnLine[MAX_LINE+1];
    int LineLen, Done, timetaken, responsetime = 0;
    Result * result = NULL;
    String retstr, finalrequest, PID;
    hrtime_t start, fin;
    time_t commenced;

    start = gethrtime();

    /* get the connection */
    ReqStream = ConnectionFactory(sess);

    PID = itoa(sess->pin);
    if (ReqStream == NULL)
    {
        Log(PID + ": Request (Connect) failed ("
            //+ itodot(sess->ip_addr) + ":" + itoa(sess->port)
            + sess->machine.c_str()
            + ")" );
        return 0;
    }

    /* do any substitutions */
    finalrequest = *request;
    finalrequest += HTTPReqType;

    if (CookieOn)
    {
        //finalrequest = finalrequest + "\r\nCookie: " + PID;
        while(0 != sess->cookie_list.size())
        {
            String cookie = sess->cookie_list.front();
            sess->cookie_list.pop_front();
            finalrequest = finalrequest + "\r\nCookie: " + cookie;
         }
    }

    if (RobotId != "")
    {
        finalrequest = finalrequest + "\r\nUser-Agent: " + RobotId;
    }

    if (body.empty() == false)
    {
        finalrequest = finalrequest + "\r\nContent-Length: " + itoa(body.length());
    }

#if 1
    // Support POST requests
    if (header.empty() == false)
    {
        finalrequest = finalrequest + "\r\n" + header;
    }

    finalrequest += "\r\n";

    if (body.empty() == false)
    {
        finalrequest = finalrequest + "\r\n" + body;
    }

    finalrequest += "\r\n";
#else
    // Otherwise only GET requests
	finalrequest = finalrequest + "\r\n\r\n";
#endif

#if 0
    cout << finalrequest; // Karim Hyder loves this feature!!
#endif

	// record the commence time 
	commenced = time(0);

	ReqStream->write(finalrequest.c_str(), strlen(finalrequest.c_str()));
    ReqStream->flush();

#ifdef VERBOSE
    fwrite(finalrequest.c_str(), sizeof(char), strlen(finalrequest.c_str()), stdout);
#endif

    // get a response 
    ReturnLine[MAX_LINE] = '\0';

    int returnCode = 0;
    int contentLength = 0;
    String serverUsed = "";
    int first = 1;

    while (ReqStream->gets(ReturnLine, MAX_LINE) != NULL &&
           ReturnLine[0] != '\r' && ReturnLine[0] != '\n')
    {
#ifdef VERBOSE
        cout << ReturnLine; // Karim Hyder loves this feature!!
#endif
        if (first == 1)
        {
            fin = gethrtime();
            responsetime = (fin - start) / 1000000;
            first = 0;
        }
        if (ReturnLine[0] != '\0' &&
            strncasecmp(ReturnLine, "http", 4) == 0)
        {
            // get the return code to decide what to do next
            char *cp;
            for (cp = &ReturnLine[4]; *cp != '\0' && *cp != ' '; cp++)
                ; // skip all chars until either end of line or space
            if (*cp == ' ')
            {
                returnCode = atoi(++cp);
            }
        } 
        else if (ReturnLine[0] != '\0' &&
            strncasecmp(ReturnLine, "Content-Length:", 15) == 0)
        {
            char *cp;

            for (cp = &ReturnLine[15]; *cp != '\0' && *cp != ' '; cp++)
                ; // skip all chars until either end of line or space
            if (*cp == ' ')
            {
                contentLength = atoi(++cp);
            }
        } 
        else if (ReturnLine[0] != '\0' &&
            strncasecmp(ReturnLine, "Server:", 7) == 0)
        {
			char *svr;
			for (svr = &ReturnLine[7]; *svr != '\0' && *svr != ' '; svr++) ;
			if (*svr == ' ')
			{
				serverUsed = ++svr;
			}
		} 
        else if (ReturnLine[0] != '\0' &&
                strncasecmp(ReturnLine, "Set-Cookie:", 11) == 0)
        {
            // rfc 2109 "HTTP State Management"
            const size_t max_cookie_length = 4096;
            char buffer[max_cookie_length+1];
            char *cookie = ReturnLine + 11 + 1; // strlen(set-cookie)+strlen(:)
            unsigned int cookie_len;
            strncpy(buffer, cookie, max_cookie_length); 
            cookie_len = strlen(buffer);
            buffer[max_cookie_length] = '\0';
            if (buffer[cookie_len-2] == '\r' || buffer[cookie_len-2] == '\n') 
                    buffer[cookie_len-2] = '\0';
            if (buffer[cookie_len-1] == '\r' || buffer[cookie_len-1] == '\n') 
                    buffer[cookie_len-1] = '\0';
            sess->cookie_list.push_back(buffer);
        }
    }

    int premclose = TRUE;
    Done = FALSE;
    int readLength = 0;
    int bytes;
    if (result == NULL)
    {
        result = new Result;
    }
    result->commenceTime = commenced - get_start_time();
    result->contentLength = contentLength;
    result->returnCode = returnCode;
    result->serverUsed = serverUsed;
    if (returnCode < 400)
    {
        while ((bytes = ReqStream->read(ReturnLine, MAX_LINE)))
        {
            ReturnLine[bytes] = '\0';
            LineLen = strlen(ReturnLine);
            readLength += bytes;
            if (ReturnLine[LineLen-1] == '\n')
                ReturnLine[LineLen-1] = '\0';
            
            retstr = ReturnLine;
            
            result->buffer.push_back(retstr);
            if (premclose && PrematureClose)
            {
                premclose = FALSE;
                if (random() % 100 < PrematureClose)
                {
                   result->interrupted = 1;
                   break; 
                }
            }
        }
    }

    result->readLength = readLength;

    fin = gethrtime();
    timetaken = (fin - start) / 1000000;
    result->timetaken = timetaken;
    result->response = responsetime;

    // record some performance stuff.
    sess->lastElapsed = fin - start;
    sess->elapsedSubTot += fin - start;
    sess->requestCnt++;

#if 0
    Log(itoa(sess->pin) + ":" + itoa(time(0)) + ":"
        + itoa(timetaken) + ":"+ finalrequest);
#endif

    delete ReqStream;

    return result;
}

/*
 * NAME: SelectNext
 */
Scenario * Scenario::SelectNext()
{
    Scenario *ret;
    ret = (*nposition);
    nposition++;
    if (nposition == nextscenario.end())
        nposition = nextscenario.begin();
    return ret;
}

/*
 * Name: Resolve
 */
void Scenario::Resolve()
{
    list<String *>::iterator i;
    
    for (i = next.begin(); i != next.end(); i++)
    {
        Scenario * sc;
        sc = SCN[(*(*i)).c_str()];

        if (sc != NULL) 
        {
            sc->head = 0;
            nextscenario.push_back(sc); 
        }
        else
        {
            fprintf(stderr, "Unable to find scenario %s\n",
                            (*(*i)).c_str());
        }
    }
    nposition = nextscenario.begin();
}

/*
 * NAME:         Log
 * ACTION:       Log stuff - this probably should be seperated from this class
 */
#define MAX_DATE 128
void Scenario::Log(String str)
{
    char timeBuf[MAX_DATE];
    time_t logTime = time(0);

#ifdef FreeBSD
    struct tm tm;
    localtime_r(&logTime, &tm);

#define DAYSPERWEEK 7
#define MONSPERYEAR 12
#define TM_YEAR_BASE 1900

    static const char       wday_name[DAYSPERWEEK][4] = {
            "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
    };              
    static const char       mon_name[MONSPERYEAR][4] = {
            "Jan", "Feb", "Mar", "Apr", "May", "Jun",
            "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
    };
    (void) sprintf(timeBuf, "%.3s %.3s%3d %02d:%02d:%02d %d\n",
            wday_name[tm.tm_wday],
            mon_name[tm.tm_mon],
            tm.tm_mday, tm.tm_hour,
            tm.tm_min, tm.tm_sec,
            TM_YEAR_BASE + tm.tm_year);

#else
#ifdef Linux
    ctime_r(&logTime, timeBuf);
#else
    ctime_r(&logTime, timeBuf, MAX_DATE);
#endif
#endif

    timeBuf[24] = '\0';
    if (logStream == 0) return;
    if (LogTimeFormat == TF_NUMERIC)
        fprintf(logStream, "%ld:%s\n", logTime, str.c_str());
    else
        fprintf(logStream, "%s:%s\n", timeBuf, str.c_str());
    fflush(logStream);
}

Scenario::Scenario()
    : xrefsAllowed(-1), terminate(false), think(0), wait_until(0), 
      port(0), head(1)
{
    use_ssl = UseSSLLayer;  

    /* this sets the default application of SSL - it can be turned on or off
        with the O option in the scenario specification. If we default to using
        ssl, then turning it on in a scenario has no effect whilst turning
        it off does. (Ossl=off) The reverse is true if we are not using SSL 
        by default. */
}

Scenario::~Scenario()
{
    // do nothing.  used to close LogStream, but since it is shared by
    // all scenarios, shutting it here will affect all other
    // scenarios.  Perhaps this should be a class static var?
}

