/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef _ZY_BASIC_H
#define _ZY_BASIC_H
#include "PYIM.h"

/*
 **********  Chuyin Keyboard Layout   **********

   ------------------------------------------------------------------------------
         !    "    #    $    %    &    '    (    )    *    +    ,    -    .    /
                                                                ie   er   ou   eng

   ------------------------------------------------------------------------------
    0    1    2    3    4    5    6    7    8    9    :    ;    <    =    >    ?
    an   b    d    3    4    zh   2    5    a    ai        ang

   ------------------------------------------------------------------------------
    @    A    B    C    D    E    F    G    H    I    J    K    L    M    N    O
         m    r    h    k    g    q    sh   c    o    u    e    ao   v    s    ei

   ------------------------------------------------------------------------------
    P    Q    R    S    T    U    V    W    X    Y    Z    [    \    ]    ^    _
    en   p    j    n    ch   i    x    t    l    z    f

   ------------------------------------------------------------------------------
*/

#define	CY_B	0
#define	CY_P	1
#define	CY_M	2
#define	CY_F	3
#define	CY_D	4
#define	CY_T	5
#define	CY_N	6
#define	CY_L	7
#define	CY_G	8
#define	CY_K	9
#define	CY_H	10
#define	CY_J	11
#define	CY_Q	12
#define	CY_X	13
#define	CY_ZH	14
#define	CY_CH	15
#define	CY_SH	16
#define	CY_R	17
#define	CY_Z	18
#define	CY_C	19
#define	CY_S	20

#define	CY_I	21
#define	CY_U	22
#define	CY_V	23

#define	CY_A	24
#define	CY_AI	25
#define	CY_AN	26
#define	CY_ANG	27
#define	CY_AO	28
#define	CY_E	29
#define	CY_EI	30
#define	CY_EN	31
#define	CY_ER	32
#define	CY_ENG	33
#define	CY_IE	34
#define	CY_O	35
#define	CY_OU	36

#define	CY_ZHI	37
#define	CY_CHI	38
#define	CY_SHI	39
#define	CY_RI	40
#define	CY_ZI	41
#define	CY_CI	42
#define	CY_SI	43
#define	CY_YI	44
#define	CY_WU	45
#define	CY_YU	46

#define CY_SEP	50

#define CY_TONE1 51
#define CY_TONE2 52
#define CY_TONE3 53
#define CY_TONE4 54
#define CY_TONE5 55

#define CY_TONE1_SYMBOL	0xa3bc
#define CY_TONE2_SYMBOL	0xa3bd
#define CY_TONE3_SYMBOL	0xa3be
#define CY_TONE4_SYMBOL	0xa3bf
#define CY_TONE5_SYMBOL	0xa3bb

#define MAXLENGTH	52

typedef struct _Zhuyin_Pinyin_Map {
	char  zhuyin_str[5]; /* now gb code */
	char  pinyin_key[5];
	char  zhuyin_key;
} Zhuyin_Pinyin_Map;

static Zhuyin_Pinyin_Map ZhuyinPinyin[47] = {
/* ShengMu 21, I,U,U: 3, YunMu 13. */

	{"t", "b",  '1'},
	{"u", "p",  'q'},
	{"v", "m",  'a'},
	{"w", "f",  'z'},
	{"x", "d",  '2'},
	{"y", "t",  'w'},
	{"z", "n",  's'},
	{"{", "l",  'x'},
	{"|", "g",  'e'},
	{"}", "k",  'd'},
	{"~", "h",  'c'},
	{"", "j",  'r'},
	{"", "q",  'f'},
	{"", "x",  'v'},
	{"", "zh", '5'},
	{"", "ch", 't'},
	{"", "sh", 'g'},
	{"", "r",  'b'},
	{"", "z",  'y'},
	{"", "c",  'h'},
	{"", "s",  'n'},

	{"", "i",  'u'},
	{"", "u",  'j'},
	{"", "v",  'm'},

	{"", "a",  '8'},
	{"", "ai", '9'},
	{"", "an", '0'},
	{"", "ang",';'},
	{"", "ao", 'l'},
	{"", "e",  'k'},
	{"", "ei", 'o'},
	{"", "en", 'p'},
	{"", "er", '-'},
	{"", "eng",'/'},
	{"", "e",  ','},
	{"", "o",  'i'},
	{"", "ou", '.'},

	{"", "zhi",'5'},
	{"", "chi",'t'},
	{"", "shi",'g'},
	{"", "ri", 'b'},
	{"", "zi", 'y'},
	{"", "ci", 'h'},
	{"", "si", 'n'},
	{"", "yi", 'u'},
	{"", "wu", 'j'},
	{"", "yu", 'm'}
};

typedef struct _zhuyin_session {
	char	rawstr[512];
	JWORD	hanzi[128];
	int	caret;
	int	hz_caret;
	int	length;
}zhuyin_session;

zhuyin_session ZySessions[512];

typedef struct _pinyin_zhuyin {
        char * pinyin;
        char * zhuyin;
}pinyin_zhuyin;

#endif
