/***************************************************************************
                          dlg_newmatch.cpp  -  description
                             -------------------
    begin                : Tue Jun 25 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlg_newmatch.moc"
#include <kcombobox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qgrid.h>
#include "resource.h"
#include "dlg_selectengine.h"
#include "dlg_selectemail.h"

#define _TYPE_HUMAN_ 0
#define _TYPE_PC_ 1
#define _TYPE_EMAIL_ 2

dlg_newmatch::dlg_newmatch(QWidget *parent, const char *name, resource *Rsrc ) :
KDialogBase(parent, name, TRUE, i18n("Start a New Match"), Cancel|Ok|Help, Ok, TRUE )
{
  myResource = Rsrc;
  Param = new match_param( myResource );
  BOX_Parent = makeHBoxMainWidget();
  BOX_Players = new QVBox( BOX_Parent );

  BOX_White = new QGroupBox(3, Qt::Horizontal, i18n("White"), BOX_Players );
  BOX_Black = new QGroupBox(3, Qt::Horizontal, i18n("Black"), BOX_Players );

  IMAGE_White = new QLabel( BOX_White );
  IMAGE_Black = new QLabel( BOX_Black );

  BOX_White_Detail = new QVBox( BOX_White );
  BOX_Black_Detail = new QVBox( BOX_Black );

  LABEL_White_Name = new QLabel( BOX_White_Detail );
  LABEL_Black_Name = new QLabel( BOX_Black_Detail );

  GROUP_White_Type = new QButtonGroup( 3, Qt::Vertical, BOX_White_Detail );
  GROUP_White_Type->setExclusive( TRUE );
  RADIO_White_Human = new QRadioButton( i18n("Human"), GROUP_White_Type );
  RADIO_White_PC = new QRadioButton( i18n("Computer"), GROUP_White_Type );
  RADIO_White_Email = new QRadioButton( i18n("Email"), GROUP_White_Type );
  connect( GROUP_White_Type, SIGNAL( clicked(int)), this, SLOT( slotWhiteType(int)));

  GROUP_Black_Type = new QButtonGroup( 3, Qt::Vertical, BOX_Black_Detail );
  GROUP_Black_Type->setExclusive( TRUE );
  RADIO_Black_Human = new QRadioButton( i18n("Human"), GROUP_Black_Type );
  RADIO_Black_PC = new QRadioButton( i18n("Computer"), GROUP_Black_Type );
  RADIO_Black_Email = new QRadioButton( i18n("Email"), GROUP_Black_Type );
  connect( GROUP_Black_Type, SIGNAL( clicked(int)), this, SLOT( slotBlackType(int)));

	/* Disable Unconfigured Types */
	if( !myResource->engines.count() )
	{
		RADIO_White_PC->setEnabled( FALSE );
		RADIO_Black_PC->setEnabled( FALSE );
	}
	if( 1 )
	{
		RADIO_White_Email->setEnabled( FALSE );
		RADIO_Black_Email->setEnabled( FALSE );
	}

  /* Time for White */
  GRID_White_Time = new QGrid( 2, Qt::Horizontal, BOX_White );
  LABEL_White_Base = new QLabel( i18n("Base Time:"), GRID_White_Time );
  SPIN_White_Base = new QSpinBox( 0, 120, 1, GRID_White_Time );
  SPIN_White_Base->setSuffix( i18n(" min.") );
  connect( SPIN_White_Base, SIGNAL( valueChanged(int)), this, SLOT( slotWhiteBase(int)));

  LABEL_White_Moves = new QLabel( i18n("Moves Per Base Time"), GRID_White_Time );
  SPIN_White_Moves = new QSpinBox( 0, 100, 5, GRID_White_Time );
  SPIN_White_Moves->setSuffix( i18n(" moves") );
  connect( SPIN_White_Moves, SIGNAL( valueChanged(int)), this, SLOT( slotWhiteMoves(int)));

  LABEL_White_Inc = new QLabel( i18n("Increment Per Move"), GRID_White_Time );
  SPIN_White_Inc = new QSpinBox( 0, 120, 1, GRID_White_Time );
  SPIN_White_Inc->setSuffix( i18n(" sec.") );
  connect( SPIN_White_Inc, SIGNAL( valueChanged(int)), this, SLOT( slotWhiteInc(int)));

  /* Time for Black */
  GRID_Black_Time = new QGrid( 2, Qt::Horizontal, BOX_Black );
  LABEL_Black_Base = new QLabel( i18n("Base Time:"), GRID_Black_Time );
  SPIN_Black_Base = new QSpinBox( 0, 120, 1, GRID_Black_Time );
  SPIN_Black_Base->setSuffix( i18n(" min.") );
  connect( SPIN_Black_Base, SIGNAL( valueChanged(int)), this, SLOT( slotBlackBase(int)));

  LABEL_Black_Moves = new QLabel( i18n("Moves Per Base Time"), GRID_Black_Time );
  SPIN_Black_Moves = new QSpinBox( 0, 100, 5, GRID_Black_Time );
  SPIN_Black_Moves->setSuffix( i18n(" moves") );
  connect( SPIN_Black_Moves, SIGNAL( valueChanged(int)), this, SLOT( slotBlackMoves(int)));

  LABEL_Black_Inc = new QLabel( i18n("Increment Per Move"), GRID_Black_Time );
  SPIN_Black_Inc = new QSpinBox( 0, 120, 1, GRID_Black_Time );
  SPIN_Black_Inc->setSuffix( i18n(" sec.") );
  connect( SPIN_Black_Inc, SIGNAL( valueChanged(int)), this, SLOT( slotBlackInc(int)));

  setTCP();
  setTypes();
  setNames();
  setImages();
	setHelp( QString( "new-match-dialog" ) );
}

dlg_newmatch::~dlg_newmatch()
{
}

///////////////////////////////////////
//
//  dlg_newmatch::setTCP
//
///////////////////////////////////////
void dlg_newmatch::setTCP( void )
{
  TCPList tmpList( Param->time(WHITE) );
  TCP tmpTCP = tmpList[0];

  SPIN_White_Base->setValue( tmpTCP.Seconds / 60 );
  SPIN_White_Moves->setValue( tmpTCP.Moves );
  SPIN_White_Inc->setValue( tmpTCP.Increment );

  tmpList = Param->time(BLACK);
  tmpTCP = tmpList[0];

  SPIN_Black_Base->setValue( tmpTCP.Seconds / 60 );
  SPIN_Black_Moves->setValue( tmpTCP.Moves );
  SPIN_Black_Inc->setValue( tmpTCP.Increment );
}
///////////////////////////////////////
//
//  dlg_newmatch::setTypes
//
///////////////////////////////////////
void dlg_newmatch::setTypes( void )
{
	switch( Param->type(WHITE) )
	{
		case PLAYERPC:
			GROUP_White_Type->setButton( _TYPE_PC_ );
			break;
		case PLAYEREMAIL:
			GROUP_White_Type->setButton( _TYPE_EMAIL_ );
			break;
		case PLAYERLOCAL:
		default:
			GROUP_White_Type->setButton( _TYPE_HUMAN_ );
			slotWhiteType( _TYPE_HUMAN_ );
			break;
	}
	if( GROUP_White_Type->selected() != _TYPE_HUMAN_ )
	{
		if( !GROUP_White_Type->selected()->isEnabled() )
		{
			GROUP_White_Type->setButton( _TYPE_HUMAN_ );
			slotWhiteType( _TYPE_HUMAN_ );
		}
	}
	else
	{
		Param->setType( WHITE, PLAYERLOCAL );
		GROUP_White_Type->setButton( _TYPE_HUMAN_ );
	}

	switch( Param->type(BLACK) )
	{
		case PLAYERPC:
			GROUP_Black_Type->setButton( _TYPE_PC_ );
			break;
		case PLAYEREMAIL:
			GROUP_Black_Type->setButton( _TYPE_EMAIL_ );
			break;
		case PLAYERLOCAL:
		default:
			GROUP_Black_Type->setButton( _TYPE_HUMAN_ );
			slotBlackType( _TYPE_HUMAN_ );
			break;
	}
	if( GROUP_Black_Type->selected() != _TYPE_HUMAN_ )
	{
		if( !GROUP_Black_Type->selected()->isEnabled() )
		{
			GROUP_Black_Type->setButton( _TYPE_HUMAN_ );
			slotBlackType( _TYPE_HUMAN_ );
		}
	}
	else
	{
		Param->setType( BLACK, PLAYERLOCAL );
		GROUP_Black_Type->setButton( _TYPE_HUMAN_ );
	}
}

///////////////////////////////////////
//
//	dlg_newmatch::setImages
//
///////////////////////////////////////
void dlg_newmatch::setImages( void )
{
	IMAGE_White->setPixmap( Param->image( WHITE ) );
	IMAGE_Black->setPixmap( Param->image( BLACK ) );
}

///////////////////////////////////////
//
//	dlg_newmatch::setNames
//
///////////////////////////////////////
void dlg_newmatch::setNames( void )
{
	LABEL_White_Name->setText( Param->name( WHITE ) );
	LABEL_Black_Name->setText( Param->name( BLACK ) );
}

///////////////////////////////////////
//
//  dlg_newmatch::slotWhiteType
//
///////////////////////////////////////
void dlg_newmatch::slotWhiteType( int type )
{
	if( type == _TYPE_PC_ )
	{
		EngineSelect = new dlg_selectengine( this, myResource, WHITE );
		connect( EngineSelect, SIGNAL( valuesChanged() ), this, SLOT( slotReparse() ) );
		EngineSelect->exec();
		Param->setType( WHITE, PLAYERPC );
	}
	else if( type == _TYPE_EMAIL_ )
	{
		EmailSelect = new dlg_selectemail( this, myResource );
		connect( EmailSelect, SIGNAL( valuesChanged() ), this, SLOT( slotReparse() ) );
		EmailSelect->exec();
		Param->setType( WHITE, PLAYEREMAIL );
	}
	else
	{
		Param->setType( WHITE, PLAYERLOCAL );
	}
	setNames();
	setImages();
}

///////////////////////////////////////
//
//  dlg_newmatch::slotWhiteBase
//
///////////////////////////////////////
void dlg_newmatch::slotWhiteBase( int time )
{
	TCPList tmpList( Param->time(WHITE) );
	TCP tmpTCP = tmpList[0];
	tmpTCP.Seconds = time * 60;
	tmpList[0] = tmpTCP;
	Param->setTime( WHITE, tmpList );
}

///////////////////////////////////////
//
//  dlg_newmatch::slotWhiteMoves
//
///////////////////////////////////////
void dlg_newmatch::slotWhiteMoves( int time )
{
	TCPList tmpList( Param->time(WHITE) );
	TCP tmpTCP = tmpList[0];
	tmpTCP.Moves = time;
	tmpList[0] = tmpTCP;
	Param->setTime( WHITE, tmpList );
}

///////////////////////////////////////
//
//  dlg_newmatch::slotWhiteInc
//
///////////////////////////////////////
void dlg_newmatch::slotWhiteInc( int time )
{
	TCPList tmpList( Param->time(WHITE) );
	TCP tmpTCP = tmpList[0];
	tmpTCP.Increment = time;
	tmpList[0] = tmpTCP;
	Param->setTime( WHITE, tmpList );
}

///////////////////////////////////////
//
//  dlg_newmatch::slotBlackType
//
///////////////////////////////////////
void dlg_newmatch::slotBlackType( int type )
{
	if( type == _TYPE_PC_ )
	{
		EngineSelect = new dlg_selectengine( this, myResource, BLACK );
		connect( EngineSelect, SIGNAL( valuesChanged() ), this, SLOT( slotReparse() ) );
		EngineSelect->exec();
		Param->setType( BLACK, PLAYERPC );
	}
	else if( type == _TYPE_EMAIL_ )
	{
		EmailSelect = new dlg_selectemail( this, myResource );
		connect( EmailSelect, SIGNAL( valuesChanged() ), this, SLOT( slotReparse() ) );
		EmailSelect->exec();
		Param->setType( BLACK, PLAYEREMAIL );
	}
	else
	{
		Param->setType( BLACK, PLAYERLOCAL );
	}
	setNames();
	setImages();
}

///////////////////////////////////////
//
//  dlg_newmatch::slotBlackBase
//
///////////////////////////////////////
void dlg_newmatch::slotBlackBase( int time )
{
	TCPList tmpList( Param->time(BLACK) );
	TCP tmpTCP = tmpList[0];
	tmpTCP.Seconds = time * 60;
	tmpList[0] = tmpTCP;
	Param->setTime( BLACK, tmpList );
}
///////////////////////////////////////
//
//  dlg_newmatch::slotBlackMoves
//
///////////////////////////////////////
void dlg_newmatch::slotBlackMoves( int time )
{
	TCPList tmpList( Param->time(BLACK) );
	TCP tmpTCP = tmpList[0];
	tmpTCP.Moves = time;
	tmpList[0] = tmpTCP;
	Param->setTime( BLACK, tmpList );
}
///////////////////////////////////////
//
//	dlg_newmatch::slotBlackInc
//
///////////////////////////////////////
void dlg_newmatch::slotBlackInc( int time )
{
	TCPList tmpList( Param->time(BLACK) );
	TCP tmpTCP = tmpList[0];
	tmpTCP.Increment = time;
	tmpList[0] = tmpTCP;
	Param->setTime( BLACK, tmpList );
}
///////////////////////////////////////
//
//	dlg_newmatch::slotReparse
//
///////////////////////////////////////
void dlg_newmatch::slotReparse( void )
{
	setNames();
	setImages();
	Param->setStrength( WHITE, myResource->Strength[WHITE] );
	Param->setStrength( BLACK, myResource->Strength[BLACK] );
}
