/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGDOCKER_H
#define XGDOCKER_H

#include <kxdocker_setup_sources.h>

#include "xeobject.h"
#include "xeconfiguration.h"
#include "xgicon.h"
#include "xematrix.h"

#include <qtimer.h>

class QWidget;
class QPixmap;
class QPainter;
class QFont;
class QColor;
//class QMutex;
#include <qmutex.h>
#include <qdatetime.h>
//class QTime;

class KRootPixmap;
class KMainWindow;

#include <kiconloader.h>
#include <kpixmapio.h>
//class KPixmapIO;
class KPopup;


#define		LONBOTTOM	0
#define		LONTOP		1
#define		LONLEFT		2
#define		LONRIGHT	3


//const int MAX_DISPLAYED_ICONS=50;

/**
@author Stefano
*/
class XGDocker : public QWidget//KMainWindow 
{
Q_OBJECT

friend class XEObject;

public:
	QString xFindIconFile(const QString &logicName);
	void wheelEvent(QWheelEvent * e );
	XGDocker(QWidget *parent = 0, const char *name = 0);
	~XGDocker();
	void mouseMoveEvent( QMouseEvent *e );
	void paintEvent( QPaintEvent *e);
	XGIcon * getObjectIcon(int i);
	void xBliz(int isDesktop=0);
	int getRaised();
	void mouseMoveSoftware(int,int);
	void reloadIcon(int icon);
	void dropEvent(QDropEvent* event);
	void dragMoveEvent( QDragMoveEvent * );
	void mouseReleaseEvent ( QMouseEvent * e );
	int xLastX,xLastY;
	QMutex Busy;
	QMutex cacheBusy;
	int isAnimating;
		QValueList<int> xcache;
		QValueList<int> ycache;
	void mouseMoveEventSW(int x,int y,int force=0,Qt::ButtonState button=Qt::NoButton);
    int xGetLayout();
public slots:
	void xCfgChanged(QObject *XECfgObject=NULL);
	void xReset();
	void xSetup();
	void xStart();
	void xStop();
	void xUpdate(int EnableTransparency=0, int pass=0);
	void backgroundUpdated(const QPixmap &);
	void xIRQ_MouseTimeout();
	void mousePressEvent( QMouseEvent *e );
	void iconAdd(const XSGObjectIcon *, int index=-1);
	void iconRemove(int index,int noanimation=0);
	void changeBackground(const QString basePath);
	void xEventTaskAppend(int);
	void xIRQ_Reset();
	void xRestore();
	void polish();
	void xHide();
	void xDrawPillow();
	void hide();
	void show();
	void purgeCacheMovements();
    void xGetWidget(QWidget *&);
    void xMouseMoveSoftware(int,int);
    void xDockerRedraw();
    void iconAddSeparator();
    void xDockerRedraw(QObject *);
    void xSendToBackground();
    void createPopup(KPopupMenu *&,const QObject *);
    void getPopupMenu(KPopupMenu *&, const QObject *);
    void showRaised();
    void xFindResource(const QString, QString &);
	signals:
	void xWarningMsg(const QObject *, const QString &);
	void xEventMouseMoved(int,int);
	void xEventMouseClick(int,int,int,int);
	void xEventReset(int,int);
	void xEventAnimateTo(int,int,int,int);
	void xEventMouseWheel(int,int,int,int);
	void xEventRemoveIcon(int);
	void xEventDockerHidden();
	void xEventWidgetMoved(int,int,int,int,int,int);
	void xEventDockerShowed();
protected:
	#ifdef ENABLE_SPECIALENGINE2
		int xLastX_notmanaged;
		int xLastY_notmanaged;
	#endif
	int AxisAreInverted;
	int xLastY_real;
	int xLastX_real;
	class QTime mouseMoveTimeElapsed;
	void (XGDocker::*funz1)(int,int,int,Qt::ButtonState);
	Qt::ButtonState lastButtonStatus;
	int		isRaised,xDesignVirtualYMatrix, lastRaise, lastIcon;
	int lastIconActivated;
	long int 	activeIconsCounter;
	int 	RefreshMask;
	QTimer	*tMouseMoved;
	QTimer	*tAutoHideTimer;
	
	QTimer	*tAutoSendBGTimer;
//	QTime	*tAutoSendFGTimer;
	
	QTimer	*tDrawPillow;
	QImage	imgWindow;
	QImage	imgFakeBackground;
	QImage	imgFakeBackgroundGlobal;
	timespec req,   rem;
	
	
	KIconLoader	KDEIconLoader;
	
	KRootPixmap	*KDesktopBackground;
	
	XSConfigurations * ActiveConfiguration;
	// Off screen buffers
	QImage 	imgBackground;
	QImage 	paintBuffer;
	QBitmap 	maskBackground;
	QBitmap 	maskBuffer;
	QBitmap	maskFull;
	
	QBitmap	fakeDesktop;
	
	class XEMatrix *	Matrix;
	
	// arrays
	XGIcon 	*activeIcons[MAX_ICONS];
	XGIcon 	*lastIconDrag;
	XGIcon	backgroundBar;
	XGIcon	backgroundBarLeft;
	XGIcon	backgroundBarRight;
	XGIcon	backgroundBarOver;
	KPixmapIO	PixmapConverter;
	
	XEConfiguration *Configurator;
	
	void applyCfg();
	void maskGenerareBigFake();
	void xMoveWidgetCenter();
	//inline void mouseMoveEventSW(int x,int y,int force=0);
	void dragEnterEvent(QDragEnterEvent* event);
    void checkBackgroundSeparators();
protected:
    void xUpdateSmooth();
    QWidget *xPillow;

    /*!
        \fn XGDocker::xUpdateDrawBackground()
     */
    void xUpdateDrawBackground();
    void xUpdateDrawBackgroundPass2();

    /*!
        \fn XGDocker::xUpdateRepaint(int myIndex)
     */
    void xUpdateRepaint(int myIndex);
    int xBar;
    int yBar;
    int dxBar;
    int dyBar;
    int LayoutPosition;
};

#endif
