/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: net.h,v 1.8 2000/11/05 17:07:34 kos Exp $
 *
 */

#ifndef _NET_H
#define _NET_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>

#include "common.h"

#define P_LINELEN 256
#define NET_LINELEN 1024
#define NET_MAXPARAMS 16
#define NET_P_DATASIZE (16*1024)
#define NET_P_NELEMS 16

#define NET_SERVER 1
#define NET_CLIENT 2
#define NET_SSL 4

#define NET_F_TEXTIFY (1<<1)
#define NET_F_DEFAULT (0)

#define net_conn_id(x) ((x)->ident)

typedef struct net_t {
  int type;
  int sock;
  struct sockaddr_in sa;
  char addr[NET_LINELEN];
  int port;
  int proto;
  int ssl;
  RETSIGTYPE (*oldsigpipe);
} net_t;

typedef struct net_conn_t {
  char ident[NET_LINELEN];
  int sock;  
  struct sockaddr_in sa;
  int salen;
  FILE *rfp;
  FILE *wfp;
  int flags;
} net_conn_t;

net_t *net_init(int type, char *addr, int port);
int net_destroy(net_t *);
net_conn_t *net_connect(net_t *);
net_conn_t *net_accept(net_t *);
int net_conn_destroy(net_conn_t *);

int net_send(net_conn_t *n, msg *p);
msg *net_recv(net_conn_t *n);

int net_conn_getflags(net_conn_t *c);
int net_conn_setflags(net_conn_t *c, int f);
FILE *net_rfp(net_conn_t *c);
FILE *net_wfp(net_conn_t *c);

#endif /* _NET_H */
