/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Branchable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;

public class ShortCircuitOp
extends Procedure2
implements Inlineable,
Branchable {
    private static final int And = 2;
    private static final int Or = 3;
    private final int kind;
    private static final Type retType = Type.boolean_type;

    /*
     * WARNING - void declaration
     */
    public static ShortCircuitOp create(String param) {
        void var1_1;
        int kind;
        if ("&&".equals(param)) {
            kind = 2;
        } else if ("||".equals(param)) {
            kind = 3;
        } else {
            throw User.error("Unknown inlined short-circuit operator " + param);
        }
        return new ShortCircuitOp((int)var1_1);
    }

    private ShortCircuitOp(int kind) {
        this.kind = kind;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] brArgs;
        Expression[] args = exp.getArgs();
        if (this.kind == 2) {
            if (args[0] == QuoteExp.trueExp) {
                args[1].compile(comp, target);
                return;
            }
            if (args[1] == QuoteExp.trueExp) {
                args[0].compile(comp, target);
                return;
            }
        }
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.boolean_type);
        Branchable branchOp = args[0].getBranchable();
        Branchable branchOp2 = args[1].getBranchable();
        Label _else = new Label(code);
        Label _end = new Label(code);
        if (branchOp != null) {
            brArgs = ((ApplyExp)args[0]).getArgs();
            if (this.kind == 2) {
                branchOp.compileJumpNot(comp, brArgs, _else);
            } else {
                branchOp.compileJump(comp, brArgs, _else);
            }
        } else {
            args[0].compile(comp, stack);
            if (this.kind == 2) {
                code.emitGotoIfIntEqZero(_else);
            } else {
                code.emitGotoIfIntNeZero(_else);
            }
        }
        if (branchOp2 != null) {
            brArgs = ((ApplyExp)args[1]).getArgs();
            if (this.kind == 2) {
                branchOp2.compileJumpNot(comp, brArgs, _else);
            } else {
                branchOp2.compileJump(comp, brArgs, _else);
            }
            code.emitPushBoolean(this.kind == 2);
        } else {
            args[1].compile(comp, stack);
        }
        code.emitGoto(_end);
        code.popType();
        _else.define(code);
        code.emitPushBoolean(this.kind != 2);
        _end.define(code);
        target.compileFromStack(comp, retType);
    }

    public void compileJump(Compilation comp, Expression[] args, Label to) {
        Expression[] brArgs;
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.boolean_type);
        Branchable branchOp = args[0].getBranchable();
        Branchable branchOp2 = args[1].getBranchable();
        Label _end = new Label(code);
        if (branchOp != null) {
            brArgs = ((ApplyExp)args[0]).getArgs();
            if (this.kind == 2) {
                branchOp.compileJumpNot(comp, brArgs, _end);
            } else {
                branchOp.compileJump(comp, brArgs, to);
            }
        } else {
            args[0].compile(comp, stack);
            if (this.kind == 2) {
                code.emitGotoIfIntEqZero(_end);
            } else {
                code.emitGotoIfIntNeZero(to);
            }
        }
        if (branchOp2 != null) {
            brArgs = ((ApplyExp)args[1]).getArgs();
            branchOp2.compileJump(comp, brArgs, to);
        } else {
            args[1].compile(comp, stack);
            code.emitGotoIfIntNeZero(to);
        }
        _end.define(code);
    }

    public void compileJumpNot(Compilation comp, Expression[] args, Label to) {
        Expression[] brArgs;
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.boolean_type);
        Branchable branchOp = args[0].getBranchable();
        Branchable branchOp2 = args[1].getBranchable();
        Label _end = new Label(code);
        if (branchOp != null) {
            brArgs = ((ApplyExp)args[0]).getArgs();
            if (this.kind == 2) {
                branchOp.compileJumpNot(comp, brArgs, to);
            } else {
                branchOp.compileJump(comp, brArgs, _end);
            }
        } else if (this.kind != 2 || args[0] != QuoteExp.trueExp) {
            args[0].compile(comp, stack);
            if (this.kind == 2) {
                code.emitGotoIfIntEqZero(to);
            } else {
                code.emitGotoIfIntNeZero(_end);
            }
        }
        if (branchOp2 != null) {
            brArgs = ((ApplyExp)args[1]).getArgs();
            branchOp2.compileJumpNot(comp, brArgs, to);
        } else if (this.kind != 2 || args[1] != QuoteExp.trueExp) {
            args[1].compile(comp, stack);
            code.emitGotoIfIntEqZero(to);
        }
        _end.define(code);
    }

    public Type getReturnType(Expression[] args) {
        return retType;
    }

    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

