/*
 * mash-event.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1999-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "mash-event.h"

static struct Mash_Queue {
    Mash_QueueEvent *first;
    Mash_QueueEvent *last;
} mash_queue;

void
Mash_QueueInit ()
{
    mash_queue.first = NULL;
    mash_queue.last  = NULL;
}

Mash_QueueEvent *
Mash_RemoveFromEventQueue ()
{
    if (mash_queue.first == NULL) {
        return NULL;
    } else {
        Mash_QueueEvent *event;
        event = mash_queue.first;
        mash_queue.first = event->next;
        if (event == mash_queue.last) {
            // event is the only thing in the queue.
            mash_queue.last = NULL;
        }
        event->next = NULL;
        return event;
    }
}

void
Mash_InsertToEventQueue (Mash_QueueEvent *event)
{
    if (mash_queue.first == NULL) {
        // nothing in the queue.
        mash_queue.first = mash_queue.last = event;
        event->next = NULL;
    } else {
        // FIXME : for now, just append to queue.
        mash_queue.last->next = event;
        event->next = NULL;
        mash_queue.last = event;
    }
}
