/*
 * jpegwc.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef JPEGWC_H
#define JPEGWC_H

/*
 * JPEG markers consist of one or more 0xFF bytes, followed by a marker
 * code byte (which is not an FF).  Here are the marker codes of interest
 * in this program.  (See jdmarker.c for a more complete list.)
 */

#define M_SOF0  0xC0		/* Start Of Frame N */
#define M_SOF1  0xC1		/* N indicates which compression process */
#define M_SOF2  0xC2		/* Only SOF0-SOF2 are now in common use */
#define M_SOF3  0xC3
#define M_SOF5  0xC5		/* NB: codes C4 and CC are NOT SOF markers */
#define M_SOF6  0xC6
#define M_SOF7  0xC7
#define M_SOF9  0xC9
#define M_SOF10 0xCA
#define M_SOF11 0xCB
#define M_SOF13 0xCD
#define M_SOF14 0xCE
#define M_SOF15 0xCF
#define M_SOI   0xD8		/* Start Of Image (beginning of datastream) */
#define M_EOI   0xD9		/* End Of Image (end of datastream) */
#define M_SOS   0xDA		/* Start Of Scan (begins compressed data) */
#define M_APP0	0xE0		/* Application-specific marker, type N */
#define M_APP12	0xEC		/* (we don't bother to list all 16 APPn's) */
#define M_COM   0xFE		/* COMment */

typedef enum {TRAN = 1, REDUCE, ENHANCE, GETRANGE, ISPROGRESS} JPEGWC_COMMANDS;

/* Transcode a baseline JPEG image into a progressive JPEG image
 * with all the levels (standard is 10). fnsrc is the filename of
 * the original image, and fndst is the filename to output the
 * progressive image. fnsrc and fndst cannot be the same filename.
 */
int jpeg_tran_progressive(char *fnsrc, char *fndst);


/* Reduce a progressive JPEG image to the number of levels specified
 * by the parameter "level". If the source image is a baseline image,
 * it is transcode to a progressive image before the reduction is
 * applied. fnsrc is the filename of the original image, and fndst is
 * the filename to output the progressive image. fnsrc and fndst
 * cannot be the same filename.
 */
int jpeg_reduce_progressive(char *fnsrc, char *fndst, int level);


/* Get the scan levels from start_level to end_level (inclusive) in
 * the source image. JPEG headers are not placed in the file, so
 * clients need to remember what levels the scan records are requested.
 * fsrc is the filename of the original image, and fblks is the filename
 * to put the blocks. fsrc is not changed.
 */
int jpeg_getrange_progressive(char *fnsrc, char *fnblks, int start_level, int end_level);


/* Enhance the source image with additional scan records. This assume
 * the scan records form consecutive levels with those in the source
 * image. fsrc is the filename of the original image, fdst is the
 * filename to output the enhanced image, and fblks is the filename
 * which contains the blocks. num_level is the number of level in fblks.
 * Returns the number of levels resulted.
 */
int jpeg_enhance_progressive(char *fnsrc, char *fndst, char *fnblks, int num_level);


/* Private function to determine whether a JPEG image is progressive
 * by counting the number of scan records in the file. Returns the number
 * of levels used in the image. If the image is not progressive, the
 * function returns 0 instead of 1 which is the number of scan record in
 * the file
 */
int jpeg_is_progressive(FILE *f);

#endif
