/*
 * gaussian-source.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1999-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <math.h>
#include "timer.h"
#include "media-timer.h"
#include "source.h"
#include "pktbuf.h"
#include "pktbuf-rtp.h"

class TransmitTimer;

class GaussianSource : public SourceModule, public MediaTimer, public Timer
{
public:
  GaussianSource() {
    timer_q_ = 0;
    avg_ = 30.0;
    sd_ = 5.0;
    pkts_per_frame_ = 1;
    bp_ = 0;
    format_ = RTP_PT_JPEG;
    pkt_len_ = 1024;
    pi_ = acos(-1);
    epoch_ = 0;
  };
  TransmitTimer *timer_q_;

  double avg_;
  double sd_;
  int pkts_per_frame_;
  RTP_BufferPool *bp_;
  double rate_;
  int format_;
  int pkt_len_;
  double pi_;
  int epoch_;

  double gen_delay();

  void start();
  void stop();

  void alloc_timer(int delay, pktbuf *pb);

  virtual int command(int argc, const char*const* argv);
  virtual void timeout();
};

class TransmitTimer : public Timer {
public:
  TransmitTimer(GaussianSource *src): Timer() {
    src_ = src;
  };
  GaussianSource *src_;
  pktbuf *pb_;
  int epoch_;
  TransmitTimer *next_;
  virtual void timeout();
};

void
TransmitTimer::timeout() {
  pktbuf *pb = pb_;
  pktbuf *npb;

  if ((src_ != 0) && (epoch_ == src_->epoch_)) {
    while(pb != 0) {
      npb = pb->next;
      pb->next = 0;
      (src_->target())->recv(pb);
      pb = npb;
    }
  } else {
    while(pb != 0) {
      npb = pb->next;
      pb->next = 0;
      pb->release();
      pb = npb;
    }
  }

  next_ = src_->timer_q_;
  src_->timer_q_ = this;

  return;
}

void
GaussianSource::alloc_timer(int delay, pktbuf *pb_list) {
  TransmitTimer *tt;

  if (timer_q_ == 0) {
    tt = new TransmitTimer(this);
  } else {
    tt = timer_q_;
    timer_q_ = timer_q_->next_;
    tt->next_ = 0;
  }

  tt->epoch_ = epoch_;
  tt->pb_ = pb_list;
  tt->msched(delay);
}


void
GaussianSource::start()
{
  stop();
  timeout();
}

void
GaussianSource::stop()
{
  epoch_++;
  cancel();
}

double
GaussianSource::gen_delay()
{
  return (sd_ *(pow((-2.0 * log((1.0-drand48()))), 0.5) *
		cos(pi_*2.0*(1.0-drand48()))) + avg_);
}

void
GaussianSource::timeout()
{
  double delay = gen_delay();

  while (delay < 0.0) {
    delay = gen_delay();
  }

  u_int32_t now = media_ts();

  pktbuf *pb_head = bp_->alloc(now, format_);
  pktbuf *pb = pb_head;

  int i;

  for (i=1; i<pkts_per_frame_; i++) {
    pb->len = pkt_len_;

    pb->next = bp_->alloc(now, format_);
    pb = pb->next;
  }
  pb->len = pkt_len_;
  pb->next = 0;
  rtphdr *rh = (rtphdr *) pb->dp;
  rh->rh_flags |= htonl(RTP_M);

  alloc_timer(((int) delay), pb_head);

  msched((int) (1000.0 / rate_));
}


int
GaussianSource::command(int argc, const char*const* argv)
{
  if (argc == 2) {
    if (strcmp(argv[1], "start") == 0) {
      start();
      return TCL_OK;
    }
    if (strcmp(argv[1], "stop") == 0) {
      stop();
      return TCL_OK;
    }
    if (strcmp(argv[1], "average") == 0) {
      Tcl &tcl = Tcl::instance();

      tcl.resultf("%f", avg_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "framerate") == 0) {
      Tcl &tcl = Tcl::instance();

      tcl.resultf("%f", rate_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "stddev") == 0) {
      Tcl &tcl = Tcl::instance();

      tcl.resultf("%f", sd_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "pkts_per_frame") == 0) {
      Tcl &tcl = Tcl::instance();

      tcl.resultf("%d", pkts_per_frame_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "bufferpool") == 0) {
      Tcl &tcl = Tcl::instance();

      if (bp_ != 0) {
	tcl.result(bp_->name());
      } else {
	tcl.result("");
      }
      return TCL_OK;
    }
  }
  if (argc == 3) {
    if (strcmp(argv[1], "average") == 0) {
      Tcl &tcl = Tcl::instance();

      avg_ = atof(argv[2]);

      tcl.resultf("%d", avg_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "framerate") == 0) {
      Tcl &tcl = Tcl::instance();

      rate_ = atof(argv[2]);

      tcl.resultf("%d", rate_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "stddev") == 0) {
      Tcl &tcl = Tcl::instance();

      sd_ = atof(argv[2]);

      tcl.resultf("%d", sd_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "pkts_per_frame") == 0) {
      Tcl &tcl = Tcl::instance();

      pkts_per_frame_ = atoi(argv[2]);

      tcl.resultf("%d", pkts_per_frame_);
      return TCL_OK;
    }
    if (strcmp(argv[1], "bufferpool") == 0) {
      Tcl &tcl = Tcl::instance();

      bp_ = (RTP_BufferPool *) TclObject::lookup(argv[2]);
      tcl.result(bp_->name());
      return TCL_OK;
    }
  }
  return (SourceModule::command(argc, argv));
}

static class GaussianSourceClass : public TclClass {
public:
  GaussianSourceClass() : TclClass("GaussianSource") {}
  TclObject * create(int argc, const char*const* argv) {
    return (new GaussianSource());
  }
} gaussian_source_class_;
