/*
 * logger.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

class LogService : public TclObject {
public:
  LogService() : TclObject(), cur_rtp_record_(0),
    cur_comm_record_(0), on_flag_(0) {};

  int command(int argc, const char*const* argv);
  void log_rtp_pkt(pktbuf *pb);
  int check_time(int rtp_index, int comm_index);
  void gen_log(char *mesg);

  int cur_rtp_record_;
  int cur_comm_record_;

  int on_flag_;

  class RTPPktEntry {
  public:
    u_int16_t flags_;
    u_int16_t seq_no_;
    u_int32_t ts_;
    u_int32_t ssrc_;
    int length_;
    struct timeval log_ts_;
  };

  class GraphCommEntry {
  public:
    char in_or_out_;
    char delivered_;
    char mesg_[100];
    struct timeval log_ts_;
  };

  RTPPktEntry rtp_entries_[9000];
  GraphCommEntry gcomm_entries_[9000];

};

extern LogService logger;
