/*
 * module-temp_select.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "module-temp_select.h"

void
TemporalSelectModule::execute_callback(u_int32_t ts)
{
  Tcl& tcl=Tcl::instance();

  if (callback_ != 0) {
    tcl.evalf("%s %d", callback_, ts );
  }
}

int
TemporalSelectModule::command(int argc, const char*const* argv)
{
  Tcl& tcl = Tcl::instance();

  if (argc == 4) {
    if (strcmp(argv[1], "register") == 0) {
      u_int32_t new_id;
      Module *new_target;

      new_id = atoi(argv[2]);
      new_target = (Module *)TclObject::lookup(argv[3]);

      if (get_state_by_id(new_id) != 0) {
	tcl.add_errorf("Target id must be unique. Tried to reuse %d", new_id);
	return TCL_ERROR;
      }

      if (new_target == 0) {
	tcl.add_errorf("Target %s not found.", argv[3]);
	return TCL_ERROR;
      }

      TemporalSelectTargetState *new_state = register_target(new_id,
							     new_target);
      if (new_state == 0) {
	tcl.add_errorf("Error registering target.");
	return TCL_ERROR;
      }

      add_state(new_state);
      return TCL_OK;
    }
  } else if (argc == 3) {
    if (strcmp(argv[1], "unregister") == 0) {
      u_int32_t id;

      id = atoi(argv[2]);

      TemporalSelectTargetState *state = get_state_by_id(id);

      if (state != 0) {
	del_state(state);
	unregister_target(id, state);
      }
      return TCL_OK;
    }
    else if (strcmp(argv[1], "set_callback") == 0) {
      if (callback_ != 0) {
	free(callback_);
	callback_ = 0;
      }
      if (strlen(argv[2]) > 0) {
	callback_ = (char *) malloc(strlen(argv[2])+1);
	strcpy(callback_, argv[2]);
      }

      return TCL_OK;
    }
    else if (strcmp(argv[1], "update") == 0) {
      u_int32_t id;
      TemporalSelectTargetState *state;

      id = atoi(argv[2]);

      state = get_state_by_id(id);

      if (state != 0) {
	update_target(id, state);
      }

      return TCL_OK;
    }
  }
  return (PacketModule::command(argc, argv));
}

void
TemporalSelectModule::add_state(TemporalSelectTargetState *state)
{
  state->next_ = target_list_;
  target_list_ = state;
  num_targets_++;
}

void
TemporalSelectModule::del_state(TemporalSelectTargetState *state)
{
  TemporalSelectTargetState *cur, *prev;

  prev = 0;
  cur = target_list_;

  while (cur != 0) {
    if (cur == state)
      break;
    prev = cur;
    cur = cur->next_;
  }

  if (cur != 0) {
    num_targets_--;
    if (prev == 0) {
      target_list_ = cur->next_;
    } else {
      prev->next_ = cur->next_;
    }
  }
}

TemporalSelectTargetState *
TemporalSelectModule::get_state_by_id(u_int32_t id)
{
  TemporalSelectTargetState *cur;

  cur = target_list_;

  while(cur != 0) {
    if (cur->id_ == id)
      break;
    cur = cur->next_;
  }
  return cur;
}

