# al-megagw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mega/al-megagw.tcl,v 1.7 2002/02/03 04:27:39 lim Exp $

import AnnounceListenManager/AS/Service RTP/Audio RTP/Video MeGa

#
Class AnnounceListenManager/AS/Service/MeGa -superclass \
		{ AnnounceListenManager/AS/Service MeGa }
#
Class AnnounceListenManager/AS/Service/MeGa/Audio -superclass \
		{ AnnounceListenManager/AS/Service/MeGa RTP/Audio }
#
Class AnnounceListenManager/AS/Service/MeGa/Video -superclass \
		{ AnnounceListenManager/AS/Service/MeGa RTP/Video }

AnnounceListenManager/AS/Service/MeGa instproc init { agent spec bw sspec toolname media } {
	set spec [MeGa ctrlchan $media $spec]
	$self next $agent $spec $bw $sspec
	$self instvar toolname_ media_
	set toolname_ $toolname
	set media_ $media
}

AnnounceListenManager/AS/Service/MeGa instproc recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar media_
	# Check for media specific death packet
	if { $srv_name == "DEATH"  && $srv_loc == $media_ } {
			puts stderr "Received death packet from $aspec at $addr - exiting."
			$self announce_death
			exit 0
	}
	$self next $atype $aspec $addr $srv_name $srv_loc $srv_inst $ssg_port \
		"$msg"
}


AnnounceListenManager/AS/Service/MeGa private format_num { fmt } {
	return -1
}

AnnounceListenManager/AS/Service/MeGa/Video private format_num { fmt } {
	return [$self rtp_fmt_number $fmt]
}

AnnounceListenManager/AS/Service/MeGa/Audio private format_num { fmt } {
	return [$self rtp_fmt_number $fmt]
}

AnnounceListenManager/AS/Service/MeGa instproc agent_data {} {
	$self instvar id1_ id2_ agent_ toolname_ media_ srv_inst_

	set o "v=0"
	set n "o=gw [pid] 0 IN IP4 [localaddr]"
	set o $o\n$n
	set n "s=$srv_inst_"
	set o $o\n$n
	set n "t=0 0"
	set o $o\n$n

	set o $o\n$n
	set n "a=tool:$toolname_"
	set o $o\n$n
	# for now all we do is no share
	# set n "a=noshare"
	# set o $o\n$n

	# media record for each output session
	foreach outs [$agent_ set sessions_] {
		set nm [$outs set netmgr_]
		if { $nm == "" } {
			continue
		}
		set net [$nm set net_(0)]
		set dn [$net data-net]
		set sport [$dn sport]
		set rport [$dn rport]
		set fmt [$self format_num [$outs set ofmt_]]
		set n "m=$media_ $sport:$rport RTP/AVP $fmt"
		set o $o\n$n

		set n "c=IN IP4 [$dn addr]/[$dn ttl]"
		set o $o\n$n

		if { [$outs set sname_] == "global" } {
			set n "a=global"
			set o $o\n$n
		}
	}

	return $o
}

AnnounceListenManager/AS/Service/MeGa instproc service_name {} {
	return MeGa
}
