# session-rtp-rtpgw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rtpgw/session-rtp-rtpgw.tcl,v 1.4 2002/02/03 04:29:18 lim Exp $


Session/RTP/RTPGW instproc init { agent } {
	$self next

	$self instvar dh_ ch_ agent_ netmgr_
	set agent_ $agent
	set h [new Module/DataHandler]
	$self data-handler $h
	set dh_ $h

	set h [new Module/ControlHandler]
	$self ctrl-handler $h
	set ch_ $h

	set netmgr_ ""
}


Session/RTP/RTPGW instproc reset ab {
	$self instvar agent_ netmgr_

	set nm [new NetworkManager $ab $self $agent_]

	if { $netmgr_ != "" } {
		delete $netmgr_
	}
	set netmgr_ $nm

	# Turn on loopback since multiple gateways could be running on same
	# host
	set i 0
	set n [$nm nchan]
	while { $i < $n } {
		set net [$nm set net_($i)]
		set dn [$net data-net]
		set cn [$net ctrl-net]
		$dn loopback 1
		$cn loopback 1
		incr i
	}
}

Session/RTP/RTPGW instproc destroy {} {
	$self instvar dh_ ch_ netmgr_
	delete $dh_
	delete $ch_
	if { $netmgr_ != "" } {
		delete $netmgr_
	}

	$self next
}

