#
# RTSP client classes
#


#
# RTSP Client Manager 
#
Class RTSP_ClientManager/RTSP_Client -superclass RTSP_ClientManager
#
# instproc open, called each time a new connection is set up
#
RTSP_ClientManager/RTSP_Client instproc init {addr port} {
	puts "Starting RTSP_ClientManager/RTSP_Client init"
        $self next
        $self instvar handler_
        
        set handler_ [new TCPClientHandler]
	puts "Create handler: $handler_"
        set chan [new TCPClientChannel]
	puts "Create channel: $chan"
        
        $self attach $chan $handler_ $self
        $chan open $addr $port
	puts "Opening $addr $port"
        $handler_ channel $chan
	puts "Done with RTSP_ClientManager/RTSP_Client init"
}

RTSP_ClientManager/RTSP_Client instproc get_handler { } {
	$self instvar handler_
	return $handler_
}

RTSP_ClientManager/RTSP_Client instproc destroy {} {
        $self instvar handler_

	if [info exists handler_] {
		delete $handler_
	}
        $self next
}

Class RTSP_Client_Application -superclass RTSP_Client
RTSP_Client_Application set seqno_ 0

RTSP_Client_Application instproc init {argv } {

	$self instvar version_
	$self tkvar   offset_
	$self instvar seqno_ 
	$self instvar state_

	$self next
	set state_ INIT_STATE
	set offset_ 0
	set seqno_ 0
	set version_ "RTSP/0.6"
	$self init_UI .main
	$self init_tokens
	$self init_stat
}

RTSP_Client_Application instproc init_stat { } {
	$self instvar statmsgs_

	set statmsgs_("Continue") 100
	set statmsgs_("OK") 200
	set statmsgs_("Created") 201
	set statmsgs_("Accepted") 202
	set statmsgs_("Non-Authoritative\ Information") 203
	set statmsgs_("No\ Content") 204
	set statmsgs_("Reset\ Content") 205
	set statmsgs_("Partial\ Content") 206
	set statmsgs_("Multiple\ Choices") 300
	set statmsgs_("Moved\ Permanently") 301
	set statmsgs_("Moved\ Temporarily") 302
	set statmsgs_("Bad\ Request") 400
	set statmsgs_("Unauthorized") 401
	set statmsgs_("Payment\ Required") 402
	set statmsgs_("Forbidden") 403
	set statmsgs_("Not\ Found") 404
	set statmsgs_("Method\ Not\ Allowed") 405
	set statmsgs_("Not\ Acceptable") 406
	set statmsgs_("Proxy\ Authentication\ Required") 407
	set statmsgs_("Request\ Time-out") 408
	set statmsgs_("Conflict") 409
	set statmsgs_("Gone") 410
	set statmsgs_("Length\ Required") 411
	set statmsgs_("Precondition\ Failed") 412
	set statmsgs_("Request\ Entity\ Too\ Large") 413
	set statmsgs_("Request-URI\ Too\ Large") 414
	set statmsgs_("Unsupported\ Media\ Type") 415
	set statmsgs_("Bad\ Extension") 420
	set statmsgs_("Invalid\ Parameter") 450
	set statmsgs_("Parameter\ Not\ Understood") 451
	set statmsgs_("Conference\ Not\ Found") 452
	set statmsgs_("Not\ Enough\ Bandwidth") 453
	set statmsgs_("Session\ Not\ Found") 454
	set statmsgs_("Method\ Not\ Valid\ In\ This\ State") 455
	set statmsgs_("Header\ Field\ Not\ Valid\ for\ Resource") 456
	set statmsgs_("Invalid\ Range") 457
	set statmsgs_("Parameter\ Is\ Read-Only") 458
	set statmsgs_("Internal\ Server\ Error") 500
	set statmsgs_("Not\ Implemented") 501
	set statmsgs_("Bad\ Gateway") 502
	set statmsgs_("Service\ Unavailable") 503
	set statmsgs_("Gateway\ Time-out") 504
	set statmsgs_("RTSP\ Version\ Not\ Supported") 505
	set statmsgs_("Extended\ Error:") 911
}


RTSP_Client_Application instproc init_tokens { } {
	$self instvar version_
	$self instvar token_
	$self instvar tknlist_

	set token_(SETUP)       "SETUP"
	set token_(REDIRECT)    "REDIRECT"
	set token_(PLAY)        "PLAY"
	set token_(PAUSE)       "PAUSE"
	set token_(SESSION)     "SESSION"
	set token_(RECORD)      "RECORD"
	set token_(EXT_METHOD)  "EXT-"

	set token_(HELLO)       "OPTIONS"
	set token_(GET)         "DESCRIBE"
	set token_(GET_PARAM)   "GET_PARAMETER"
	set token_(SET_PARAM)   "SET_PARAMETER"
	set token_(CLOSE)       "TEARDOWN"
	set tknlist_ {"REDIRECT" "PLAY" "PAUSE" "SESSION" "RECORD" "EXT-" \
			"OPTIONS" "DESCRIBE" "GET_PARAMETER" "SET_PARAMETER" "TEARDOWN"}
}

RTSP_Client_Application instproc get_URL {w} {

	$self tkvar url_
	set url_ "rtsp://heart.cs:12128/test/09151322-video1-2"
	toplevel $w
	wm title $w "Open URL"
	message $w.msg -width 200 -justify center -text "Enter URL"
	pack $w.msg
	entry $w.url -width 40 -textvariable [$self tkvarname url_]
	pack $w.url
	frame $w.bf
	pack  $w.bf -pady 5
	button $w.bf.ok -text "Open" -width 5 -command "destroy $w; $self open"
	pack   $w.bf.ok
	button $w.bf.quit -text "Cancel" -width 5 -command "destroy $w"
	pack   $w.bf.quit -side right -before $w.bf.ok
}

RTSP_Client_Application instproc open { } {

	$self instvar addr_ port_ path_ manager_
	$self instvar daddr_ dport_ version_
	
	$self parse_url
	if [info exists manager_] {
		delete $manager_
	}
	if {$port_ == ""} { 
		set port_ 554  
	}
	set manager_ [new RTSP_ClientManager/RTSP_Client $addr_ $port_]
	$self manager $manager_
	$manager_ client $self
	$self alloc "unicast"


#	$self send "HELLO"
	$self send "SETUP"
}

# 
# Construct and send messages of type 'type'
#
RTSP_Client_Application instproc send {type} {

	global tcl_platform
	$self instvar addr_ path_ version_ 
	$self tkvar url_
	$self instvar dport_ daddr_
	$self instvar seqno_
	$self instvar token_
	$self instvar manager_
	$self instvar smsg_
	$self instvar statmsgs_ status_

	if [info exists token_($type)] {
		set tkn $token_($type)
	} else {
		puts "$type : No token!"
	}
	if [info exists smsg_] {
		puts "Status message :: $smsg_"
		set code $statmsgs_(\"$smsg_\")
		puts "CODE = $code"
	} else { 
		set code "RTSP_UNKNOWN" 
	}
		
	set date "Date: [clock format [clock seconds] -format {%d %b %Y %H:%M:%S GMT} -gmt true]"

	switch -exact -- $type {
		"SETUP" {
			incr seqno_
			set msg "$tkn rtsp://$url_ $version_ $seqno_\nStream-ID:0 \nTransport: rtp/udp;port=$dport_\r\n"
		} 
		"HELLO" {
			incr seqno_
			set msg "$tkn * $version_ $seqno_\nUser-Agent: mash RTSP/0.1alpha [set tcl_platform(os)]\r\n\r\n"
		}

		"HELLO_RESPONSE" {
			incr seqno_
			set msg "$version_ $code $seqno_ $smsg_\n$date\r\n\r\n"
		}

		"CLOSE" {
			incr seqno_
			set msg "$tkn $version_ $seqno_ \r\n\r\n"
		}
		"GET" {
			incr seqno_
			set msg "$tkn rtsp://$url_ $version_ $seqno_\nAccept: application/sdp; application/x-rtsp-mh\n\r\n\r\n"
		}
		"PAUSE" {
			incr seqno_
			set msg "$tkn $url_ $version_ $seqno_ \r\n\r\n"
		}
		default {
			puts "No such type!"
		}
	}
	set length [string length $msg]
	puts "\n\nSending :: \n $msg (length = $length)"
	
	set handler [$manager_ get_handler]
	puts "Handler: $handler"
	puts "Channel: [$handler channel]"
	puts "Self: $self"
	$self send_ctrl [$handler channel] $msg $length
}


#  
# XXX: Address allocation
# What happens if the port gets allocated to another 
# process in the meanwhile? 
# What happens if two different servers re-use the 
# same multicast address but have overlapped regions? 

RTSP_Client_Application instproc alloc { type } {
	$self instvar daddr_ dport_
	if {$type == "unicast"} {
		set daddr_ [info hostname]
	} else {
		# Generate a random multicast address? We'll worry later!
		set daddr_ 224.2.45.324
	}
	set dport_ 8738
}

RTSP_Client_Application instproc init_UI {path} {

	wm title . "MASH Remote Player"
	wm geometry . 350x120

	frame $path        -relief raised          -bd 2
	pack  $path        -side top               -fill x
	
#	label .name -text "MASH Remote Player" -height 10
#	pack  .name -side bottom
	
	$self build_menubar $path
	$self build_slider  $path
	$self build_title   $path
}

RTSP_Client_Application instproc build_title { w } { 
	# Stream description
	$self instvar st_des_ 
	$self instvar st_dur_
	# Change this later
	set st_des_ "Description: CSCW Class (Tuesday)"
	frame $w.sdes -relief sunken  -bd 2 
	label $w.sdes.label -text $st_des_ -height 10
	pack  $w.sdes $w.sdes.label -side top -anchor w -fill x
}

RTSP_Client_Application instproc build_slider { w } { 

	frame $w.scale -relief sunken
        scale $w.scale.slider -orient horizontal -width 12 -length 20 -relief groove -showvalue 0 -from 0 -to 100 \
			-tickinterval 20  -showvalue true -variable [$self tkvarname offset_] -command "set a" 
        pack $w.scale $w.scale.slider -side top -fill x -expand 1 -anchor e
}

RTSP_Client_Application instproc build_menubar {path} {

	frame $path.menubar -relief raised -bd 2
	pack $path.menubar -side top -fill x

	menubutton      $path.menubar.file -text "File" -m $path.menubar.file.x -width 5 -underline 0
	pack            $path.menubar.file -side left
	menu            $path.menubar.file.x -tearoff no
	
	$path.menubar.file.x add command -label "Open URL"    -command "$self get_URL .open"
	$path.menubar.file.x add command -label "Exit"        -command "$self exit"

	menubutton      $path.menubar.view -text "View" -m $path.menubar.view.x -width 5 -underline 0
	pack            $path.menubar.view -side left -fill x

	menu            $path.menubar.view.x -tearoff no
	$path.menubar.view.x add command -label "Statistics"    -command " "
}

RTSP_Client_Application instproc parse_url { } {

	$self tkvar url_
	$self instvar port_ addr_ path_

	# Check to see if  the URL is valid
	if [expr [string length $url_] <= 0] {
		Dialog transient MessageBox -type ok -text \
                                "Invalid URL.\n Example: rtsp://hearst.cs.berkeley.edu:554" -image Icons(warning)
		return
	}
	if [expr [string first "rtsp://" $url_] == 0] {
		set url_ [string range $url_ [string length "rtsp://"] end]
	}
	# Split at the firs occurrence of '/'
	set sIndex [string first "/" $url_]
	set lIndex [string length $url_]
	set addr_ [string range $url_ 0 [expr $sIndex - 1]]
	set path_ [string range $url_ $sIndex end]
	
	set sIndex [string first ":" $addr_]
	set port_ [string range $addr_ [expr $sIndex + 1] end]
	set addr_ [string range $addr_ 0 [expr $sIndex -1]]
	if {$addr_ == ""} {
		Dialog transient MessageBox -type ok -text \
                                "Invalid URL.\n Example: rtsp://hearst.cs.berkeley.edu:554" -image Icons(warning)		
	}
}


RTSP_Client_Application instproc exit {} {
	# Clean up here
	exit
}

# 
# Received messages are passed up to this instproc 
# This is adapted from the the state machine implementation
# of Rob Lanphier 
#


# XXX : Incomplete!
RTSP_Client_Application instproc parse_message {message} {

	$self instvar parts_ status_
	if {![$self valid_response $message]} {
		set op [lindex $parts_ 0]
		set r [$self valid_method $op]
		if {[expr $r == 0]} {
			puts "Invalid message received"
			return 0
		} else {
			$self handle_event $op
			return
		}
	} else {
		set server_seqno_ [lindex $parts_ 2]
		set method_ [lindex $parts_ 3]
		set object_ [lindex $parts_ 4]
		puts "method = $method_"
		puts "server_seqno = $server_seqno_"
		puts "object = $object_"
		return
	}
}

# 
# Client state machine
#
RTSP_Client_Application instproc handle_event {opcode} {
	$self instvar status_ token_ smsg_ state_
	puts "HANDLE_EVENT"
	switch -exact -- $state_ {
		INIT_STATE {
			puts "Init state"
			switch -exact -- $opcode {
				"OPTIONS" {
					puts "HELLO : $opcode"
					set smsg_ "OK"
					$self send "HELLO_RESPONSE"
					$self send "GET"
				}
				"DESCRIBE" {
					puts "$opcode"
				}
			}
		}
	}
	return
}
#
# Mapping from status number to status message
#
RTSP_Client_Application instproc status {errno} {
	
}


RTSP_Client_Application instproc valid_method {opcode} {
	$self instvar tknlist_
	foreach t $tknlist_ {
		if {[string match $t $opcode]} {
			puts "MATCH"
			return 1
		}
	}
	return 0
}

RTSP_Client_Application instproc valid_response {message} {
	$self instvar status_ server_seqno_ version_
	$self instvar parts_

	set parts_ [split $message " "]
	set version [lindex $parts_ 0]
	if  [expr [string first "RTSP/" $version] != 0] {
		puts "INVALID RESPONSE - no version"
		return 0
	}
	if [expr [llength $parts_] < 3] {
		puts "INVALID RESPONSE - parts < 3"
		return 0
	}
	#if {[string toupper $version] != $version_} {
	#	puts "INVALID RESPONSE - diff version"
	#	return 0
	#}
	set status_ [lindex $parts_ 1]
	puts "VALID RESPONSE"
	return 1
}

RTSP_Client_Application instproc handle_reply {message} {
	$self instvar state_

	puts "handle_reply :: Message = $message"
	if {[$self parse_message $message] == 0} {
		puts "Invalid message received \n$message"
	}
	puts "----------------------------------------"
}

