# server.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import TCP

Class SdforServer -superclass TCP

SdforServer set methods_ [list get advertise]

SdforServer public init {parent} {
    $self instvar cache_ source_ buffer_
    set cache_ [$parent set cache_]
    set source_ [$parent set source_]
    set buffer_ ""
    $self next
}

SdforServer public recv s {
    $class instvar methods_
    $self instvar buffer_

    append buffer_ $s
    append buffer_ "\n"
    if {$s != ""} { return }

    set i [string first " " $buffer_]
    set cmd [string range $buffer_ 0 [expr $i-1]]
    switch $cmd {
	subscribe {
	    $self instvar cache_
	    $cache_ subscribe $self
	}

	advertise {
	    set msg [string range $buffer_ [expr $i + 1] end]
	    $self advertise $msg
	}

	default {
	    #FIXME
	    #$self send "Unrecognized command \"$cmd\"\n\n"
	    $self warn "Unrecognized command \"$cmd\""
	}
    }
}

SdforServer public advertise {text} {
    $self instvar source_

    #FIXME
    set parser [$source_ set sdp_]

    set objs [$parser parse $text]
    foreach o $objs {
	set prog [new Program $o]
	$source_ announce $prog
    }

    #FIXME still need to do:
    #  - write to stable storage and readvertise when restarted
    #  - stop announcing when timed out
    #  - authentication stuff from the mm98 paper
}

SdforServer public shutdown {} {
    $self instvar cache_
    $cache_ unsubscribe $self
}



import ERSServer

Class ERSServer/Sdfor -superclass ERSServer

ERSServer/Sdfor public init {port spec} {
	$self instvar server_port_
	set server_port_ $port
	$self next $spec
}

ERSServer/Sdfor public build_reply {data} {
	$self instvar net_ server_port_
	set addr [$net_ interface]
	return "$addr/$server_port_"
}
