# mash-setup.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#FIXME: change working directory to mash so that relative paths will be correct
if {$tcl_platform(platform) == "windows"} {
	if ![file exists mash.exe] {
		if [file exists mash\\mash.exe] {
			puts "changing dir to mash"
			cd mash
		}
	}
}



Class Setup/Mash -superclass Setup

Setup/Mash public init { } {
	$self next
	$self set appname_ "Mash"
	$self set copyright_ "lib/setup/COPYRIGHT"
	if { [Setup system]=="Win32" } {
		$self set destination_ "C:/Program Files/mash"
	}

	$self set components_(typical) [list {Mash binaries} scripts]
	$self set components_(custom) [list {Mash binaries} scripts \
				{other scripts} {active services} mplug]
	$self set {component_help_(Mash binaries)} \
			"This installs the executable files\
			\nfor the Mash shell."
	$self set component_help_(scripts) \
			"These are the various scripts for multimedia\
			\nconferencing that use the Mash toolkit."
	$self set {component_help_(other scripts)} \
			"These are other scripts for multimedia\
			\nconferencing that use the Mash toolkit.\
			\n\nThese scripts are not officially supported."
	$self set {component_help_(active services)} \
			"These are the various scripts for the Active\
			\nServices Infrastructure that is built on the\
			\nMash toolkit.\
			\n\nThese scripts are not officially supported."
	$self set component_help_(mplug) \
			"This is a web browser plug-in for the Mash\
			\ntoolkit. It includes the plug-in shared library,\
			\nhelper scripts, and initialization files.\
			\n\nThis plug-in is not officially supported."

	if { [Setup system]=="Win32" } {
		$self set {files_(Mash binaries)} \
				[list mash.exe smash.exe tclpip83.dll]
	} else {
		global mash
		$self set {files_(Mash binaries)} \
				[list bin/mash-$mash(version) \
				bin/smash-$mash(version)]
	}

	if { [Setup system]=="Win32" } {
		$self set files_(scripts) \
				[list nsdr vic vat \
				recorder player \
				nsdr.exe vic.exe vat.exe \
				recorder.exe player.exe \
				lib/setup/setup lib/setup/setup.gif \
				lib/setup/COPYRIGHT lib/setup/LICENSE]
	} else {
		$self set files_(scripts) \
				[list bin/nsdr bin/vic bin/vat \
				bin/recorder bin/player \
				lib/setup/setup lib/setup/setup.gif \
				lib/setup/COPYRIGHT lib/setup/LICENSE]
	}

	if { [Setup system]=="Win32" } {
		$self set {files_(other scripts)} \
				[list collaborator mb mbv2 tgw \
				collaborator.exe mb.exe mbv2.exe tgw.exe]
	} else {
		$self set {files_(other scripts)} \
				[list bin/collaborator bin/mb bin/mbv2 bin/tgw]
	}

	if { [Setup system]=="Win32" } {
		$self set {files_(active services)} \
				[list as/hm as/vgw as/agw as/sdgw as/mars \
				as/tgmb as/pathfinder as/megafor as/mgamon \
				as/hm.exe as/vgw.exe as/agw.exe as/sdgw.exe as/mars.exe \
				as/tgmb.exe as/pathfinder.exe as/megafor.exe as/mgamon.exe \
				as/mediapad.prc \
				as/html/*.html as/html/images/*.gif]
	} else {
		$self set {files_(active services)} \
				[list as/hm as/vgw as/agw as/sdgw as/mars \
				as/tgmb as/pathfinder as/megafor as/mgamon \
				as/mediapad.prc \
				as/html/*.html as/html/images/*.gif]
	}

	$self instvar files_
	set files_(mplug) \
			 [list lib/npmplug* lib/prefs-mplug \
			 lib/mplug-test.html lib/mplug-test.mash]
	if  { [Setup system]=="Win32" } {
		lappend files_(mplug) script-loader
	} else {
		lappend files_(mplug) bin/script-loader
	}
}

Setup/Mash public dialog_list { } {
	set list [$self next]
	lappend list SetEnvironDlg InstallMPlugDlg
	return $list
}


Setup/Mash public do_install { } {
	SetupProgress/Mash .progress
	.progress center

	$self copy_files
	# on unix, create a symlink from mash to mash-$mash(version)
	$self link_mash

	$self update_environment
	.progress check_next
	update

	$self install_mplug
	.progress check_next
	update

	after 1000
	destroy .progress
}


Setup/Mash public success { } {
	$self instvar appname_ destination_
	set text "\n$appname_ has been successfully installed\
			\on your system.\n"

	if {[Setup system]=="Win32"} {
		set bin [file nativename $destination_]
	} else {
		set bin [file nativename [file join $destination_ bin]]
	}
	set lib [file nativename [file join $destination_ lib]]
	append text \
            "\nYou can find the executable files associated with\
            \n$appname_ in \"$bin\".\
            \n\nThe libraries, examples, and initialization files for the\
            \nvarious applications are in \"$lib\".\n\
            \nEnjoy playing around with your new software!\n\n"

	set retval [Dialog transient MessageBox -text $text -image Icons(cal) \
			-type \
			{ {readme -text "View README.TXT" -under 0 \
			-image Icons(textfile) } \
			{ exit -text "Exit" -under 1 -image Icons(cross) } }]
	if { $retval == "readme" } {
		ReadmeDlg .readmedlg
		.readmedlg invoke
	}
}


Setup/Mash private link_mash { } {

	if { [Setup system]!="Unix" } return

	$self instvar destination_
	global mash
	set to [file join $destination_ bin/mash]
	$self copy_or_symlink/[Setup system] mash-$mash(version) $to

	set to [file join $destination_ bin/smash]
	$self copy_or_symlink/[Setup system] smash-$mash(version) $to
}


Setup/Mash private update_environment { } {
	$self instvar update_user_environ_ update_system_environ_

	.progress subwidget bar configure -max 2 -value 0
	update

	if { $update_user_environ_==1 } {
		.progress subwidget info configure -text \
				"Updating user environment"
		update
		$self update_user_environment/[Setup system]
	}
	.progress subwidget bar configure -value 1
	# no need to do an update here

	if { $update_system_environ_==1 } {
		.progress subwidget info configure -text \
				"Updating system environment"
		update
		$self update_system_environment/[Setup system]
	}
	.progress subwidget bar configure -value 2
	update
}




Setup/Mash private update_user_environment/Unix {} {
	# we assume that $HOME will always be defined under UNIX
	# so all we need to set is $MASH_HOME

	$self instvar destination_

	QueryUnixRCFilesDlg .query
	set list [.query invoke]

	set comment "\n\n# Environment variables for Mash\n"
	set envline(.cshrc)   "${comment}setenv MASH_HOME $destination_"
	set envline(.tcshrc)  $envline(.cshrc)
	set envline(.profile) "${comment}MASH_HOME=$destination_\
			\nexport MASH_HOME"

	set shells(.cshrc)   "csh and tcsh"
	set shells(.tcshrc)  "tcsh"
	set shells(.profile) "sh and bash"

	foreach rcfile $list {
		$self update_environment_file "~/$rcfile" $envline($rcfile) \
				$shells($rcfile)
	}
}


Setup/Mash private update_system_environment/Unix {} {
	# we assume that $HOME will always be defined under UNIX
	# so all we need to set is $MASH_HOME

	$self instvar destination_

	$self update_environment_file /etc/csh.cshrc \
			"setenv MASH_HOME $destination_" "csh and tcsh"
	$self update_environment_file /etc/profile \
			"MASH_HOME=$destination_\nexport MASH_HOME" \
			"sh and bash"
}


Setup/Mash private update_environment_file { filename envline shells } {
	if [file exists $filename] {
		if { [catch { set file [open $filename a] } msg ] } {
			set file ""
		}
	} else {
		if { [catch { set file [open $filename w] } msg ] } {
			set file ""
		}
	}

	if { $file=="" } {
		$self warn "Could not open $filename:\n$msg\n\nUnable to \
				update environment for $shells"
		# proceed on
	} else {
		puts $file $envline
		close $file
	}
}


Setup/Mash private update_user_environment/Win32 { } {
	global tcl_platform
	if { $tcl_platform(os)=="Windows 95" } {
		$self update_user_environment/Win95
	} else {
		$self update_user_environment/WinNT
	}
}


Setup/Mash private update_system_environment/Win32 { } {
	global tcl_platform
	if { $tcl_platform(os)=="Windows NT" } {
		$self update_system_environment/WinNT
	}
}


Setup/Mash private update_user_environment/Win95 { } {
	$self instvar destination_

	set dest [file nativename $destination_]
	$self update_environment_file C:/autoexec.bat \
			"set MASH_HOME=$dest" "Windows 95"
	global env
	if { ![info exists env(HOME)] || $env(HOME)=="" } {
		set def_home "C:\\"
		$self update_environment_file C:/autoexec.bat \
				"set HOME=\"$def_home\"" "Windows 95"

		Dialog transient MessageBox -text "\
				\nSetup has set your HOME environment variable\
				\nto ${def_home}. It is recommended that you\
				\nchange this to a directory where you store\
				\nyour local files.\n\
				\nSetup will look for a directory \".mash\" in\
				\nthis sub-directory for user-customized\
				\noptions.\n\
				\nYou can update your environment settings by\
				\nmanually editing the C:\\autoexec.bat file\
				\n\n" -image Icons(warning) -type ok
	}
}


Setup/Mash private update_user_environment/WinNT { } {
	$self instvar destination_

	set dest [file nativename $destination_]
	putregistry "HKEY_CURRENT_USER\\Environment" "MASH_HOME" $dest
	if { [catch {set HOME [getregistry \
			"HKEY_CURRENT_USER\\Environment" HOME]}] || \
			$HOME=={} } {
		# couldn't find a valid HOME env var
		# so, set it
		set def_home "C:\\"
		putregistry "HKEY_CURRENT_USER\\Environment" "HOME" $def_home

		Dialog transient MessageBox -text "\
				\nSetup has set your HOME environment variable\
				\nto ${def_home}. It is recommended that you\
				\nchange this to a directory where you store\
				\nyour local files.\n\
				\nSetup will look for a directory \".mash\" in\
				\nthis sub-directory for user-customized\
				\noptions.\n\
				\nYou can update your environment settings by\
				\nselecting \"System\" from the Control Panel\
				\nand choosing the \"Environment\" tab.\n\n" \
				-image Icons(warning) -type ok
	}
}


Setup/Mash private update_system_environment/WinNT { } {
	$self instvar destination_

	set dest [file nativename $destination_]
	set key "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\"
	append key "Control\\Session Manager\\Environment"

	putregistry $key "MASH_HOME" $dest
	if { [catch {set HOME [getregistry $key HOME]}] || $HOME=={} } {
		# couldn't find a valid HOME env var
		# so, set it
		set def_home "C:\\"
		putregistry $key "HOME" $def_home

		Dialog transient MessageBox -text "\
				\nSetup has set a system-wide HOME environment\
				\nvariable to ${def_home}. It is recommended\
				\nthat you change this on a per-user basis\
				\nto a directory where the user stores his/her\
				\nlocal files.\n\
				\nSetup will look for a directory \".mash\" in\
				\nthis sub-directory for user-customized\
				\noptions.\n\
				\nYou can update your environment settings by\
				\nselecting \"System\" from the Control Panel\
				\nand choosing the \"Environment\" tab.\n\n" \
				-image Icons(warning) -type ok
	}
}


Setup/Mash private install_mplug { } {
	$self instvar install_components_
	if { [lsearch $install_components_ mplug] == -1 } {
		# mplug has not been installed
		return
	}

	$self instvar destination_

	set npmplug_so [file join $destination_ lib/npmplug.*]
	if { [catch { set npmplug_so [glob $npmplug_so] } msg] } {
		$self warn "Could not find Mash plug-in files:\n$msg\n\
				\nSome components seem to be missing from the\
				\ninstallation package."
		return
	}

	$self instvar mplug_dest_

	.progress subwidget bar configure -max [llength $mplug_dest_] \
			-value 0
	.progress subwidget info configure -text \
			"Installing Mash plug-in"
	update
	set done 0

	foreach dir $mplug_dest_ {
		set msg [$self create_dir $dir]
		if { $msg!={} } {
			$self warn "Could not create directory:\
					$dir\n$msg"
				# don't return here; go on with the remaining
				# dirs
		}

		foreach file $npmplug_so {
			$self copy_or_symlink/[Setup system] $file $dir
		}

		incr done
		.progress subwidget bar configure -value $done
		update
	}

	# now update the prefs-mplug file
	.progress subwidget info configure -text \
			"Updating preferences file for Mash plug-in"
	update
	$self update_prefs_mplug
}


Setup/Mash private copy_or_symlink/Unix { src dest } {
	set src  [$self do_tilde_subst $src]
	set dest [$self do_tilde_subst $dest]

	file delete $dest
	if {[catch { set retval [exec ln -s "$src" "$dest"] } msg ] } {
		$self warn "Could not create symbolic links between\
				\n$src and $dest:\n$msg"
		return
	} else {
		set retval [string trim $retval]
		if { $retval!={} } {
			$self warn "Possible error while creating symbolic\
					links\nbetween $src and $dest\n:\
					\n$retval"
			return
		}
	}
}


Setup/Mash private copy_or_symlink/Win32 { src dest } {
	if {[catch { file copy -force -- $src $dest } msg ] } {
		$self warn "Could not copy Mash plug-in files\
				\n$src to $dest"
		return
	}
}


Setup/Mash private do_tilde_subst { file } {
	# FIXME: we are only checking for leading ~/
	set split [file split $file]
	if { [lindex $split 0] == "~" } {
		global env
		if [info exists env(HOME)] {
			set file [eval file join \
					[lreplace $split 0 0 $env(HOME)]]
		} else {
			set file [eval file join [lreplace $split 0 0]]
		}
	}

	return $file
}


Setup/Mash private update_prefs_mplug { } {
	$self instvar destination_
	set prefs_mplug [file join $destination_ "lib/prefs-mplug"]

	# open the preferences file

	if { ![file exists $prefs_mplug] } {
		$self warn "Could not find file \"$prefs_mplug\"\
				\nSome components seem to be missing from the\
				installation\npackage."
		return
	}

	if { [catch {set file [open $prefs_mplug]} msg] } {
		$self warn "Error occurred while opening the Mash plug-in\
				\npreferences file \"$prefs_mplug\"\n($msg)\
				\n\nSetup will not be able to update the\
				\plug-in preferences."
		return
	}

	# replace all occurrences of $MASH_HOME with the actual path
	set mash_home [file nativename $destination_]
	set buffer ""
	while { [gets $file line] >= 0 } {
		set line [string trim $line]
		set first [string index $line 0]
		if { $first!="#" } {
			# this line is not a comment line

			regsub -all -- {\$MASH_HOME} $line $mash_home line
		}

		append buffer "$line\n"
	}
	close $file

	# output the new mplug-prefs file
	if { [catch {set file [open $prefs_mplug w]} msg] } {
		$self warn "Error occurred while writing to the Mash plug-in\
				\npreferences file \"$prefs_mplug\"\n($msg)\
				\n\nSetup will not be able to update the\
				\plug-in preferences."
		return
	}

	if { [catch {puts -nonewline $file $buffer} msg] } {
		$self warn "Error occurred while writing to the Mash plug-in\
				\npreferences file \"$prefs_mplug\"\n($msg)\
				\n\nSetup will not be able to update the\
				\plug-in preferences."
		return
	}

	close $file
}




WidgetClass SetEnvironDlg -superclass SetupDialog -default {
	{ .title "Update Environment Variables" }
	{ *Checkbutton.borderWidth 1 }
}


SetEnvironDlg private build_widget { path } {
	$self tkvar update_user_environ_ update_system_environ_

	set path [$self build_skeleton $path [list Back Next Cancel]]
	label $path.label -justify left -text \
			"Setup will attempt to reconfigure your environment\
			\nby adding the appropriate system variables to your\
			\nstartup files.\
			\n\nSetup can reconfigure the environment for just\
			\nyou (User Environment), the entire system (System\
			\nEnvironment), or both. You must have administrative\
			\nor root privileges in order to update the System\
			\nEnviroment. Don't select the System Environment\
                        \noption unless you have those privileges.\
			\n\nOn UNIX, you can get root privileges by running\
			\nSetup as the \"root\" user. On Windows, you must be\
			\nthe Administrator in order to update the System\
			\nEnvironment.\
			\n\nYou can choose to skip this step completely by not\
			\nselecting either of the following choices.\n"

	frame $path.frame -borderwidth 2 -relief groove
	label $path.envlabel -text "Update environment variables:"

	set update_user_environ_ 1
	set update_system_environ_ 0
	checkbutton $path.user -text "User Environment (only yours)" \
			-variable [$self tkvarname update_user_environ_]
	checkbutton $path.system -text "System Environment (global)" \
			-variable [$self tkvarname update_system_environ_]

	global tcl_platform
	if { $tcl_platform(os)=="Windows 95" } {
		# there is no such thing as system/user environment on Win95
		$path.system configure -state disabled
	}

	pack $path.label -side top -pady 5 -padx 5
	pack $path.envlabel -in $path.frame -side top -anchor w -padx 5 -pady 2
	pack $path.user   -in $path.frame -side top -anchor w -padx 20 -pady 1
	pack $path.system -in $path.frame -side top -anchor w -padx 20 -pady 1
	pack $path.frame -side top -padx 5 -pady 10 -fill x
}


SetEnvironDlg private verify { direction } {
	if { $direction=="back" } { return 1 }

	# update the corresponding variables in the Setup object
	set setup [Setup instance]

	$self tkvar update_user_environ_ update_system_environ_
	$setup set update_user_environ_ $update_user_environ_
	$setup set update_system_environ_ $update_system_environ_

	return 1
}


WidgetClass InstallMPlugDlg -superclass SetupDialog -default {
	{ .title "Copy Mash plug-in files" }
	{ *Checkbutton.borderWidth 1 }
}


InstallMPlugDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar appname_

	set path [$self build_skeleton $path [list Back Next Cancel]]
	set text \
			"The $appname_ distribution comes with a plug-in for\
			Netscape\nand Internet Explorer that can be used to\
			enhance the\ncapabilities of your web browser\
			by allowing it to browse\nthe MBone and participate\
			in MBone sessions.\
			\n\nSetup must copy the plug-in files to your browser's\
			directory\nin order for it to work.\n\
			\nThe Setup program has auto-detected the following\
			browser\nplug-in directories on your system. Please\
			select \"Add to list\"\
			\nto make additions to this list.\n\n"

	if { [Setup system]=="Unix" } {
		append text \
				"Your browser's plug-in directory is usually a\
				directory called\n\"plugins\" somewhere under\
				your browser's installation.\
				\nFor example:\
				\n    /usr/local/netscape/lib/plugins\n\
				\nPlease note that you may need root\
				privileges in order to\ninstall the plug-in\
				in some of these directories.\n"
	} else {
		# win32
		append text \
				"Your browser's plug-in directory is usually a\
				directory called\n\"Plugins\" somewhere under\
				your browser's installation.\
				\nFor example:\
				\n    C:\\Program Files\\Netscape\\Communicator\\Program\\Plugins\
				\n    C:\\Program Files\\Microsoft Internet\\Plugins\n\
				\nPlease note that you may need administrative\
				privileges in order to\ninstall the plug-in\
				in some of these directories.\n"
	}

	label $path.label -justify left -text $text
	pack $path.label -side top -pady 5 -padx 5

	frame $path.f1 -borderwidth 2 -relief groove
	frame $path.f2
	label $path.cplabel -text "Copy Mash plug-in files to:" -justify left \
			-anchor w
	pack $path.cplabel -in $path.f2 -side left -anchor w -padx 5 -pady 0 \
			-fill x -expand 1

	button $path.add -text "Add to list..." -command "$self add"
	pack $path.add -in $path.f2 -side right -anchor e -padx 5 -pady 0
	pack $path.f2 -in $path.f1 -padx 0 -pady 2 -fill x

	$self tkvar copy_list_
	set copy_list_(count) 0
	foreach mplugpath [$self search_browsers] {
		set copy_list_(path,$mplugpath) 0
		checkbutton $path.check$copy_list_(count) -text $mplugpath \
				-variable \
				[$self tkvarname copy_list_(path,$mplugpath)]
		pack $path.check$copy_list_(count) -in $path.f1 -side top \
				-anchor w -padx 20 -pady 1
		incr copy_list_(count)
	}

	pack $path.f1 -side top -padx 5 -pady 10 -fill x

	label $path.disabled -justify left -anchor w -text \
		"The installation that you have chosen does not include\
		\nthe Mash plug-in. If you would like to install the plug-in,\
		\nplease hit \"Back\" and change your installation options."
	# don't pack this label here
	# pack it in "invoke" only if mplug has been disabled
}


InstallMPlugDlg private verify { direction } {
	if { $direction=="back" } { return 1 }

	$self tkvar copy_list_
	set setup [Setup instance]
	$setup instvar mplug_dest_
	set mplug_dest_ {}
	foreach name [array names copy_list_ "path,*"] {
		if { $copy_list_($name) } {
			set filepath [string range $name 5 end]
			lappend mplug_dest_ $filepath
		}
	}

	return 1
}


InstallMPlugDlg public invoke { args } {
	# check if MPlug is part of the components list that we are trying to
	# install

	set setup [Setup instance]
	$setup instvar install_components_
	if { [lsearch $install_components_ mplug] == -1 } {
		# disable this dialog box
		$self set_state disabled
	} else {
		$self set_state normal
	}
	return [eval [list $self] next $args]
}


InstallMPlugDlg private set_state { state } {
	$self tkvar copy_list_
	set path [$self subwidget main]
	for { set idx 0 } { $idx < $copy_list_(count) } { incr idx } {
		 $path.check$idx configure -state $state
	}
	$path.add configure -state $state
	if { $state=="disabled" } {
		set fg [$path.add cget -disabledforeground]
		pack $path.disabled -side top -padx 5 -pady 5 -anchor w
	} else {
		set fg [$path.add cget -foreground]
		catch {pack forget $path.disabled}
	}
	$path.label configure -foreground $fg
	$path.cplabel configure -foreground $fg
}


InstallMPlugDlg private search_browsers { } {
	return [$self search_browsers/[Setup system]]
}


InstallMPlugDlg private add { } {
	$self tkvar copy_list_
	set setup [Setup instance]
	set dirdlg [$setup get_dirdlg]

	$dirdlg configure -title "Choose browser plug-in directory"
	$dirdlg subwidget dirbox configure -allownonexistent 0

	set retval [$dirdlg invoke]
	if { $retval!={} } {
		set path [$self info path]
		set copy_list_(path,$retval) 1
		checkbutton $path.check$copy_list_(count) -text $retval \
				-variable \
				[$self tkvarname copy_list_(path,$retval)]
		pack $path.check$copy_list_(count) -in $path.main.f1 \
				-side top \
				-anchor w -padx 20 -pady 1
		incr copy_list_(count)
	}
}



InstallMPlugDlg private search_browsers/Unix { } {
	# return a list of directories; look for a default
	# /usr/local/netscape/lib/plugins or
	# /usr/local/lib/netscape/plugins

	set list [list ~/.netscape/plugins]
	foreach dir [list /usr/local/netscape/lib/plugins \
			/usr/local/lib/netscape/plugins] {
		if [file isdirectory $dir] { lappend list $dir }
	}

	return $list
}


InstallMPlugDlg private search_browsers/Win32 { } {
	# return a list of directories

	set list {}

	# first try to locate the default browser
	set key "HKEY_LOCAL_MACHINE\\Software\\Classes\\"
	append key "http\\shell\\open\\command"
	if { ![catch {set browser [getregistry $key ""]}] && $browser!={} } {
		# extract the name of the browser from the data
		# the filename might contain spaces, so I can't just
		# use [lindex $browser 0] to get the filename
		#
		# The stupid thing is that Windows does not necessarily
		# quote the pathname, so I'm just going to use a heuristic
		# where if there is a word that starts with a -, I'll assume
		# that it's the start of the arglist and assume everything
		# before that is the pathname
		# FIXME:

		set browser [string trim $browser]
		set idx [string first " -" $browser]
		if { $idx==-1 } { set idx [string first " \"-" $browser] }
		if { $idx!=-1 } {
			set pathname [string trim [string range $browser 0 \
					[expr $idx-1]]]
		} else {
			set pathname $browser
		}

		# check if the Plugins directory exists
		set plugindir [file join [file dirname $pathname] Plugins]
		if [file isdirectory $plugindir] {
			set list [list $plugindir]
		}
	}

	foreach dir [list "C:/Program Files/Netscape/Communicator/Program/Plugins" "C:/Program Files/Netscape/Navigator/Program/Plugins" "C:/Program Files/Microsoft Internet/Plugins" "C:/Program Files/Plus!/Microsoft Internet/Plugins" "C:/Program Files/Internet"] {

		if [file isdirectory $dir] {
			# first check if it's already there
			if { [lsearch [string tolower $list] \
					[string tolower $dir]] == -1 } {
				lappend list $dir
			}
		}
	}

	return $list
}


WidgetClass QueryUnixRCFilesDlg -superclass Dialog -default {
	{ .title "Select RC files" }
	{ *Checkbutton.borderWidth 1 }
	{ *ImageTextButton.borderWidth 1 }
	{ *Label.font WidgetDefault }
}


QueryUnixRCFilesDlg private build_widget { path } {
	label $path.label -justify left -anchor w -text \
		"Setup can update one or more of the following startup\
		\nfiles in your home directory. Please select which ones\
		\nyou would like Setup to update, depending on your\
		\npreferred shell."
	checkbutton $path.cshrc -text ".cshrc (csh and tcsh)" -anchor w \
			-variable [$self tkvarname cshrc]
	checkbutton $path.tcshrc -text ".tcshrc (tcsh only)" -anchor w \
			-variable [$self tkvarname tcshrc]
	checkbutton $path.profile -text ".profile (sh and bash)" -anchor w \
			-variable [$self tkvarname profile]
	ImageTextButton $path.ok -text "OK" -image Icons(check) \
			-command "$self ok"

	pack $path.label -side top -fill x -padx 10 -pady 10
	pack $path.cshrc $path.tcshrc $path.profile -fill x -padx 20
	pack $path.ok -anchor e -padx 20 -pady 15
}


QueryUnixRCFilesDlg private ok { } {
	$self tkvar cshrc tcshrc profile
	set list {}
	if { $cshrc   } { lappend list .cshrc   }
	if { $tcshrc  } { lappend list .tcshrc  }
	if { $profile } { lappend list .profile }

	$self configure -result $list
}


WidgetClass SetupProgress/Mash -superclass SetupProgress


SetupProgress/Mash private checklist { } {
	set list [$self next]
	lappend list "Update environment variables"
	set setup [Setup instance]
	if {[lsearch -exact [$setup set install_components_] mplug] != -1} {
		lappend list "Install Mash plug-in"
	}
	return $list
}



WidgetClass ReadmeDlg -superclass SetupDialog -default {
	{ .title "README.TXT" }
	{ *Text*borderWidth 1 }
	{ *Scrollbar*borderWidth 1 }
	{ *Scrollbar*width 10 }
}


ReadmeDlg private build_widget { path } {
	if [catch {set file [open README.TXT "r"]} msg ] {
		set msg "Could not open README file:\n$msg"
	} else {
		set msg ""
		while { [gets $file line] >= 0 } {
			append msg "$line\n"
		}
		close $file
	}

	set path [$self build_skeleton $path [list Exit]]
	ScrolledText $path.readme -scrollbar both -options \
			{ {text.width 60} {text.height 16} {text.wrap none} }
	$path.readme subwidget text insert end $msg
	$path.readme subwidget text configure -state disabled

        # For some unknown reason, Courier doesn't work with setup on Windows.
        # The ansifixed font, which is Courier, does work.  Go figure.

        global tcl_platform
        if {$tcl_platform(platform) == {windows}} {
            $path.readme subwidget text configure -font {ansifixed}
        } else {
            $path.readme subwidget text configure -font {Courier 10}
        }

	pack $path.readme -fill both -expand 1
}

