/*
 * tgmb-canv.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_TGMB_CANV_H
#define MASH_TGMB_CANV_H


#include "mb/mb-canv.h"
#include "mb/mb-items.h"
#include "misc/linkedlist.h"
#include "tgmb-conn.h"


class CanvasCmd;
class CanvasCreateCmd;
class ChunkFrag;


class TGMB_Canvas : public MBBaseCanvas {
public:
	TGMB_Canvas();
	virtual ~TGMB_Canvas();

	// return a record of the item
	virtual MBCanvItem* getItem(const CanvItemId canvId);

	// delete an item
	virtual Bool deleteItem(const CanvItemId canvId, MBCmd *pCmd);

	// re-create an item from a record of the item
	virtual CanvItemId createItem(Page* pPage, MBCmd* pCmd,
				      MBCanvItem* pItem);

	// create an item from raw data
	virtual CanvItemId createItem(Page* pPage, MBCmd* pCmd,
				      PageItem* pPgItem);

	virtual Bool moveItem(CanvItemId targetId,  MBCmd* pCmd, Coord dx,
			      Coord dy);

#ifdef SNDR_ONLY
	// returns the next nearest item within dist of (x,y)
	CanvItemId nextNearest(Coord x, Coord y, Coord dist, CanvItemId cid);

	// returns whether the item overlaps ( (x1,y1) (x2,y2) )
	Bool overlap(Coord x1, Coord y1, Coord x2, Coord y2, CanvItemId cid);
#endif

	virtual void raiseAfter(CanvItemId b4Id, CanvItemId afId);
	virtual void raise(CanvItemId cid) { raiseAfter(0, cid); }

	virtual char *getText(CanvItemId cid, int& len);
	virtual void setText(CanvItemId cid, MBCmd* pCmd, const char* szText);

	virtual CanvItemId createImage(Page* pPage, MBCmd* pCmd,
				       ImageItem* pItem,
				       const char* szFileName);

#ifdef NOTDEF
	/* return TRUE on success */
	int resize(int width, int height);

	int setsize(int width, int height);
#endif

	Bool toChunkFrag(ChunkFrag *frag, CanvItemId id);

	Bool construct_payload(TclObject *destination,
			       u_char *&data, u_int32_t &len,
			       ListIndex &lastSent);
	Bool construct_image_payload(TclObject *destination, u_int32_t canvId,
				     u_char *&data, u_int32_t &len);

	CanvasCreateCmd *FindFirstCmd(CanvItemId id) {
		int key[2] = { id, 0 };
		Tcl_HashEntry* pEntry =
			Tcl_FindHashEntry(&htCanvItems_, (char*)key);
		if (!pEntry) {
			disperr("FindFirstCmd called with unknown id: %d\n",
				id);
			assert(FALSE &&
			       "FindFirstCmd called with unknown id");
			return NULL;
		}

		return (CanvasCreateCmd*)Tcl_GetHashValue(pEntry);
	}

	CanvasCmd *FindLastCmd(CanvItemId id) {
		int key[2] = { id, 1 };
		Tcl_HashEntry* pEntry =
			Tcl_FindHashEntry(&htCanvItems_, (char*)key);
		if (!pEntry) {
			disperr("FindLastCmd called with unknown id: %d\n",
				id);
			assert(FALSE &&
			       "FindLastCmd called with unknown id");
			return NULL;
		}

		return (CanvasCmd*)Tcl_GetHashValue(pEntry);
	}

	Bool DeferUpdateNotification() { return deferUpdate_; }
	void DeferUpdateNotification(Bool deferUpdate) {
		deferUpdate_ = deferUpdate;
		if (deferUpdate_==FALSE) {
			UpdateClients();
			//Invoke("update 0 0", NULL);
		}
	}

	inline void UpdateClients() {
		if (update_scheduled_) { got_updates_recently_=TRUE; return; }
		Invoke("schedule_update_clients", NULL);
		update_scheduled_ = TRUE;
		//TCP_MediaPad::send_data_to_everyone(this);
	}
	PageId &getPageId() { return pageId_; }
private:
	virtual int init(int argc, const char * const *argv);
	CanvItemId addCanvCmd(CanvasCmd *pCanvCmd);
	void ApplyEffects(TclObject *destination,
			  CanvasCmd *pCmd, u_int32_t startSeqno,
			  u_char *&data, u_int32_t &len);

	int seqNo_;
	PageId pageId_;
	List<CanvasCmd> list_;
	Tcl_HashTable htCanvItems_;
	Bool deferUpdate_, update_scheduled_, got_updates_recently_;
};


#endif /* MASH_TGMB_CANV_H */
