/*
 * srmv2-api.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/srmv2-api.h,v 1.27 2002/02/03 03:05:47 lim Exp $
 */

#ifndef srmv2_api_h
#define srmv2_api_h

//#include "hfsc/hfsc_fun.h"

#define SRMv2_ALLOC 0xffffffff
#define SRMv2_ERROR 0xffffffff
#define SRMv2_ROOT_CID 0 /* SNAP root CID. Make this a randomized CID. */
#define SRMv2_SESSION_KBPS 64


/* API to SRMv2 library. */

#ifdef __cplusplus
extern "C" {
#endif
	
typedef void* srm_session_t;
typedef void* srm_source_t;
typedef void* srm_packet_t;

/* some NTP definitions */

/*
 * Number of seconds between 1-Jan-1900 and 1-Jan-1970
 */
#define GETTIMEOFDAY_TO_NTP_OFFSET 2208988800UL

/* Offset from UNIX's epoch to the NTP epoch in seconds (NTP's JAN_1970) */
#define RTP_EPOCH_OFFSET	2208988800UL

/* ntp64: a 64-bit representation of an NTP timestamp
 *        the units are (seconds * 2^32)
 */
typedef struct ntp64 {
	unsigned int upper;	/* more significant 32 bits */
	unsigned int lower;	/* less significant 32 bits */
} ntp64;


typedef struct srm_adu_info {
	unsigned char type;
	ntp64 timestamp;
} srm_adu_info;


/* create_session: 
 * Create an SRM multicast channel with 'addr', 'sport', 'rport', 'ttl'. 
 */
srm_session_t srm_create_session(unsigned int addr, unsigned int sport,
				 unsigned int rport, unsigned int ttl);
void srm_destroy_session(srm_session_t session);
int  srm_reset_session(srm_session_t session, unsigned int addr,
		       unsigned int sport, unsigned int rport, 
		       unsigned int ttl);

#ifndef USE_HFSC_SCHEDULER
void srm_set_session_bandwidth(srm_session_t session, int bps);
int  srm_get_session_bandwidth(srm_session_t session);
#endif

double srm_set_drop_probability(srm_session_t session, double dropProb);
double srm_get_drop_probability(srm_session_t session);

int srm_delay_until_full_packet(srm_session_t session, int flag);
int srm_get_delay_until_full_packet(srm_session_t session);

srm_source_t srm_create_source(srm_session_t session, const char *srcid);
void srm_set_app_info(srm_source_t src, const unsigned char *info,
		      int info_len);
void srm_get_app_info(srm_source_t src, const unsigned char **info,
		      int *info_len);
int srm_is_local_source(srm_source_t src);

/* srm_calloc:
 * Create a new child node of node 'parent'.
 */
unsigned int  srm_calloc(srm_source_t source, unsigned int parent,
			 const unsigned char *container_name, int name_len);


srm_session_t srm_get_session(srm_source_t source);

void srm_get_container_name(srm_source_t source, unsigned int cid,
			    const unsigned char **name, int *name_len);

unsigned int srm_get_parent_cid(srm_source_t source, unsigned int cid);

/* srm_get_source_id:
 * get the 4-int representation of source id
 */
const int *srm_get_source_id(srm_source_t source);

/* srm_srcid2str:
 * Gets 32 character string representation of source id. Pointer
 * for results passed in as second argument must be greater than 32
 * characters.
 */
void srm_srcid2str(const int *srcid, char *str);

/* srm_str2srcid:
 * Converts the 32 character string representation of source id back
 * into an int array
 */
const char *srm_str2srcid(const char *str, int *srcid);


/* send_buffer:
 * Allocate a new seqno for this ADU
 * Send 'len' bytes of <cid:seqno> to the SRM session.
 * Return the seqno
 */
unsigned int srm_send(srm_source_t source, unsigned int cid, 
		      unsigned char *data, int len, const srm_adu_info *info);

void srm_recover(srm_source_t source, unsigned int cid, 
		 unsigned int sseq, unsigned int eseq);


typedef void (*srm_free_proc)(void *ptr);
typedef void (*srm_recv_proc)(srm_source_t source,
			      unsigned int cid, unsigned int seqno,
			      const unsigned char *data, int len,
			      const srm_adu_info *info);
typedef int (*srm_should_recover_proc)(srm_source_t source,
				       unsigned int cid, unsigned int sseq,
				       unsigned int eseq);
typedef void (*srm_read_adu_proc)(srm_source_t source,
				  unsigned int cid, unsigned int seqno,
				  unsigned char **data_ptr,
				  unsigned int *len_ptr,
				  srm_free_proc *free_proc_ptr,
				  srm_adu_info *info);
typedef void (*srm_source_update_proc)(srm_source_t source,
				       const unsigned char *info,
				       int info_len);
typedef void (*srm_recv_cid_proc)(srm_source_t source, unsigned int cid,
				  unsigned int parent,
				  const unsigned char *name, int name_len);


/*typedef void (*srm_construct_cid_mapping_proc)(srm_source_t source,
					       unsigned int cid, 
					       char **data_ptr, int *len_ptr,
					       srm_free_proc *free_proc_ptr);
typedef void (*srm_recv_cid_mapping_proc)(srm_source_t source,
					  unsigned int cid,
					  const char *data, int len);*/


typedef struct srm_callbacks {
	srm_recv_proc           recv_proc;
	srm_should_recover_proc should_recover_proc;
	srm_read_adu_proc       read_adu_proc;
	srm_source_update_proc  source_update_proc;
	srm_recv_cid_proc       recv_cid_proc;
	void *user_hook;
} srm_callbacks;


void srm_set_callbacks(srm_session_t session, const srm_callbacks *callbacks);
const srm_callbacks *srm_get_callbacks(srm_session_t session);
void srm_set_recv_proc(srm_session_t session, srm_recv_proc proc);
void srm_set_should_recover_proc(srm_session_t session,
				 srm_should_recover_proc proc);
void srm_set_read_adu_proc(srm_session_t session, srm_read_adu_proc proc);
void srm_set_source_update_proc(srm_session_t session,
				srm_source_update_proc proc);
void srm_set_recv_cid_proc(srm_session_t session, srm_recv_cid_proc proc);


/* debugging methods */

#define srmSRM      0x00000001
#define srmVerbose  0x00000002

#ifndef NDEBUG
extern unsigned int srm_trace_flags_;
#define srm_trace_flags(flags)  srm_trace_flags_ = flags
#define srm_trace(flag, args)                            \
do {                                                     \
	if ( (srm_trace_flags_ & (flag))==(flag) ) {     \
		printf("[%s:%d] ", __FILE__, __LINE__);  \
		printf args;                             \
		printf("\n");                            \
	}                                                \
} while (0)


#define srm_trace_start(flag)                            \
do {                                                     \
	if ( (srm_trace_flags_ & (flag))==(flag) ) {     \
		printf("[%s:%d] ", __FILE__, __LINE__);  \
	}                                                \
} while (0)


#define srm_trace_out(flag, args)                        \
do {                                                     \
	if ( (srm_trace_flags_ & (flag))==(flag) ) {     \
		printf args;                             \
	}                                                \
} while (0)


#define srm_trace_end(flag)                              \
do {                                                     \
	if ( (srm_trace_flags_ & (flag))==(flag) ) {     \
		printf("\n");                            \
	}                                                \
} while (0)


#else
#define srm_trace_flags(flags)
#define srm_trace(flag, args)
#define srm_trace_start(flag)
#define srm_trace_out(flag, args)
#define srm_trace_end(flag)
#endif


/* The following functions are defined only if you compile libsrm.a with
 * the --enable-tcl-api flag set during configure
 */
typedef struct Tcl_Interp Tcl_Interp;
struct Tcl_Obj;
int SRMv2_Init(Tcl_Interp *interp);
int Srmv2_Init(Tcl_Interp *interp);

srm_session_t srm_session_from_str(Tcl_Interp *interp, const char *token);
srm_source_t  srm_source_from_str (Tcl_Interp *interp, const char *token);
srm_session_t srm_session_from_obj(Tcl_Interp *interp, struct Tcl_Obj *token);
srm_source_t  srm_source_from_obj (Tcl_Interp *interp, struct Tcl_Obj *token);


/* API to HFSC-related structures. */
	
#define ROOT_CLASS     0
#define DATA_CLASS     1
#define ANNOUNCE_CLASS 2
#define NACK_CLASS     3

#ifdef USE_HFSC_SCHEDULER
unsigned int srm_get_session_bandwidth(srm_session_t session);
unsigned int srm_get_class_bandwidth(srm_session_t session, unsigned int tcid);

unsigned int srm_create_tc(srm_session_t session, unsigned int parent_tcid);
void srm_delete_tc(srm_session_t session, unsigned int tcid);
#endif

#ifdef __cplusplus
}
#endif



#endif

