#!/bin/sh
# path trick for wish variants \
exec tclsh $0 ${1+"$@"}

# import the DpTcl library
source dp-lib.tcl

global g_serv

# procedures that can be invoked from this program or by a remote client

proc killServer {} {
    # this after is needed to give time for the RPC to return to the client
    after 1000 "exit"
}

proc helloWorld {arg} {
    puts stdout "received Hello World from $arg"
}

proc getServerHost {} {
    puts stdout "received getServerHost request"
    set hostname [info hostname]
    if {$hostname == ""} {
	# this system does not support the info hostname command
	set hostname "unsupported"
    }
    return $hostname
}

# main program starts here

set port 8024

set g_serv [dp_MakeRPCServer $port]

puts stdout "server running"

# this next line enters the TCL event loop and this guy will never exit
vwait forever