/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Promise;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FD_PID
extends Protocol {
    Address ping_dest;
    int ping_pid;
    Address local_addr;
    int local_pid;
    long timeout;
    long get_pids_timeout;
    long get_pids_retry_timeout;
    int num_tries;
    Vector members;
    Hashtable pids;
    boolean own_pid_sent;
    Vector pingable_mbrs;
    Promise get_pids_promise;
    boolean got_cache_from_coord;
    TimeScheduler timer;
    Monitor monitor;

    public String getName() {
        return "FD_PID";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("get_pids_timeout")) != null) {
            this.get_pids_timeout = new Long(str);
            props.remove("get_pids_timeout");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = new Integer(str);
            props.remove("num_tries");
        }
        if (props.size() > 0) {
            System.err.println("FD_PID.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            Trace.warn("FD_PID.start()", "TimeScheduler in protocol stack is null (or protocol stack is null)");
            return;
        }
        this.timer = this.stack.timer;
        if (this.monitor != null && !this.monitor.started) {
            this.monitor = null;
        }
        if (this.monitor == null) {
            this.monitor = new Monitor();
            this.timer.add(this.monitor, true);
        }
    }

    public void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        boolean num_pings = false;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.getHeader(this.getName());
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) break;
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbr == null) break;
                        if (Trace.trace) {
                            Trace.info("FD_PID.up()", "[SUSPECT] hdr: " + hdr);
                        }
                        this.passUp(new Event(9, hdr.mbr));
                        this.passDown(new Event(9, hdr.mbr));
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return;
                        }
                        if (hdr.mbr == null) {
                            Trace.error("FD_PID.up()", "[WHO_HAS_PID] hdr.mbr is null");
                            return;
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.local_pid > 0) {
                            this.sendIHavePidMessage(msg.getSrc(), hdr.mbr, this.local_pid);
                            return;
                        }
                        if (!this.pids.containsKey(hdr.mbr)) break;
                        this.sendIHavePidMessage(msg.getSrc(), hdr.mbr, (Integer)this.pids.get(hdr.mbr));
                        break;
                    }
                    case 12: {
                        if (Trace.trace) {
                            Trace.info("FD_PID.up()", "i-have pid: " + hdr.mbr + " --> " + hdr.pid);
                        }
                        if (hdr.mbr == null || hdr.pid <= 0) {
                            Trace.error("FD_PID.up()", "[I_HAVE_PID] hdr.mbr is null or hdr.pid == 0");
                            return;
                        }
                        if (!this.sameHost(this.local_addr, hdr.mbr)) {
                            Trace.error("FD_PID.up()", hdr.mbr + " is not on the same host as I (" + this.local_addr + ", discarding I_HAVE_PID event");
                            return;
                        }
                        this.pids.put(hdr.mbr, new Integer(hdr.pid));
                        if (Trace.trace) {
                            Trace.info("FD_PID.up()", "[" + this.local_addr + "]: the cache is " + this.pids);
                        }
                        if (this.ping_pid > 0 || this.ping_dest == null || !this.pids.containsKey(this.ping_dest)) break;
                        this.ping_pid = (Integer)this.pids.get(this.ping_dest);
                        try {
                            this.start();
                        }
                        catch (Exception ex) {
                            Trace.warn("FD_PID.up()", "exception when calling start(): " + ex);
                        }
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (Trace.trace) {
                                Trace.error("FD_PID.up()", "[GET_PIDS]: hdr.mbr == null");
                            }
                            return;
                        }
                        hdr = new FdHeader(14);
                        hdr.pids = (Hashtable)this.pids.clone();
                        msg = new Message(hdr.mbr, null, null);
                        msg.putHeader(this.getName(), hdr);
                        this.passDown(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.pids == null) {
                            if (Trace.trace) {
                                Trace.error("FD_PID.up()", "[GET_PIDS_RSP]: cache is null");
                            }
                            return;
                        }
                        this.get_pids_promise.setResult(hdr.pids);
                        break;
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        Vector old_mbrs = this.members;
        switch (evt.getType()) {
            case 52: {
                Integer pid = (Integer)evt.getArg();
                if (pid == null) {
                    Trace.error("FD_PID.down()", "SET_PID did not contain a pid !");
                    return;
                }
                this.local_pid = pid;
                if (!Trace.trace) return;
                Trace.info("FD_PID.down(SET_PID)", "local_pid=" + this.local_pid);
                return;
            }
            case 6: {
                FD_PID fD_PID = this;
                synchronized (fD_PID) {
                    View v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    this.passDown(evt);
                    if (!this.got_cache_from_coord) {
                        this.getPidsFromCoordinator();
                        this.got_cache_from_coord = true;
                    }
                    if (!this.own_pid_sent) {
                        if (this.local_pid > 0) {
                            this.sendIHavePidMessage(null, this.local_addr, this.local_pid);
                            this.own_pid_sent = true;
                        } else {
                            Trace.warn("FD_PID.down()", "[VIEW_CHANGE]: local_pid == 0");
                        }
                    }
                    if (this.members != null) {
                        Enumeration e = this.pids.keys();
                        while (e.hasMoreElements()) {
                            Address mbr = (Address)e.nextElement();
                            if (this.members.contains(mbr)) continue;
                            this.pids.remove(mbr);
                        }
                    }
                    Address tmp_ping_dest = this.determinePingDest();
                    this.ping_pid = 0;
                    if (tmp_ping_dest == null) {
                        this.stop();
                        this.ping_dest = null;
                    } else {
                        this.ping_dest = tmp_ping_dest;
                        try {
                            this.start();
                        }
                        catch (Exception ex) {
                            Trace.warn("FD_PID.down()", "exception when calling start(): " + ex);
                        }
                    }
                    return;
                }
            }
        }
        this.passDown(evt);
    }

    void getPidsFromCoordinator() {
        int attempts = this.num_tries;
        this.get_pids_promise.reset();
        while (attempts > 0) {
            Address coord = this.determineCoordinator();
            if (coord != null) {
                if (coord.equals(this.local_addr)) {
                    if (Trace.trace) {
                        Trace.info("FD_PID.getPidsFromCoordinator()", "first member; cache is empty");
                    }
                    return;
                }
                FdHeader hdr = new FdHeader(13);
                hdr.mbr = this.local_addr;
                Message msg = new Message(coord, null, null);
                msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, msg));
                Hashtable result = (Hashtable)this.get_pids_promise.getResult(this.get_pids_timeout);
                if (result != null) {
                    this.pids.putAll(result);
                    if (Trace.trace) {
                        Trace.info("FD_PID.getPidsFromCoordinator()", "got cache from " + coord + ": cache is " + this.pids);
                    }
                    return;
                }
                if (Trace.trace) {
                    Trace.error("FD_PID.getPidsFromCoordinator()", "received null cache; retrying");
                }
            }
            Util.sleep(this.get_pids_retry_timeout);
            --attempts;
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (Trace.trace) {
            Trace.info("FD_PID.broadcastSuspectMessage()", "suspecting " + suspected_mbr + " (own address is " + this.local_addr + ')');
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbr = suspected_mbr;
        Message suspect_msg = new Message();
        suspect_msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, suspect_msg));
    }

    void broadcastWhoHasPidMessage(Address mbr) {
        if (Trace.trace && this.local_addr != null && mbr != null) {
            Trace.info("FD_PID.broadcastWhoHasPidMessage()", "[" + this.local_addr + "]: who-has " + mbr);
        }
        Message msg = new Message();
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    void sendIHavePidMessage(Address dst, Address mbr, int pid) {
        Message msg = new Message(dst, null, null);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.pid = pid;
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    Address determinePingDest() {
        if (this.pingable_mbrs == null || this.pingable_mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        int i = 0;
        while (i < this.pingable_mbrs.size()) {
            Address tmp = (Address)this.pingable_mbrs.elementAt(i);
            if (this.local_addr.equals(tmp)) {
                if (i + 1 >= this.pingable_mbrs.size()) {
                    return (Address)this.pingable_mbrs.elementAt(0);
                }
                return (Address)this.pingable_mbrs.elementAt(i + 1);
            }
            ++i;
        }
        return null;
    }

    Address determineCoordinator() {
        return this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
    }

    boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            Trace.error("FD_PID.sameHost()", "addresses have to be of type IpAddress to be compared");
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    private final /* synthetic */ void this() {
        this.ping_dest = null;
        this.ping_pid = 0;
        this.local_addr = null;
        this.local_pid = 0;
        this.timeout = 3000L;
        this.get_pids_timeout = 3000L;
        this.get_pids_retry_timeout = 500L;
        this.num_tries = 3;
        this.members = new Vector();
        this.pids = new Hashtable();
        this.own_pid_sent = false;
        this.pingable_mbrs = new Vector();
        this.get_pids_promise = new Promise();
        this.got_cache_from_coord = false;
        this.timer = null;
        this.monitor = null;
    }

    public FD_PID() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FdHeader
    extends Header {
        static final int SUSPECT = 10;
        static final int WHO_HAS_PID = 11;
        static final int I_HAVE_PID = 12;
        static final int GET_PIDS = 13;
        static final int GET_PIDS_RSP = 14;
        int type;
        Address mbr;
        int pid;
        Hashtable pids;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=" + this.mbr);
            }
            if (this.pid > 0) {
                sb.append(", pid=" + this.pid);
            }
            if (this.pids != null) {
                sb.append(", pids=" + this.pids);
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_PID";
                }
                case 12: {
                    return "I_HAVE_PID";
                }
                case 13: {
                    return "GET_PIDS";
                }
                case 14: {
                    return "GET_PIDS_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.mbr);
            out.writeInt(this.pid);
            out.writeObject(this.pids);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.mbr = (Address)in.readObject();
            this.pid = in.readInt();
            this.pids = (Hashtable)in.readObject();
        }

        private final /* synthetic */ void this() {
            this.type = 10;
            this.mbr = null;
            this.pid = 0;
            this.pids = null;
        }

        public FdHeader() {
            this.this();
        }

        FdHeader(int type) {
            this.this();
            this.type = type;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Monitor
    implements TimeScheduler.Task {
        boolean started;

        void stop() {
            this.started = false;
        }

        public boolean cancelled() {
            return this.started ^ true;
        }

        public long nextInterval() {
            return FD_PID.this.timeout;
        }

        public void run() {
            if (FD_PID.this.ping_dest == null) {
                Trace.warn("FD_PID.Monitor.run()", "ping_dest is null, skipping ping");
                return;
            }
            if (Trace.trace) {
                Trace.info("FD_PID.Monitor.run()", "ping_dest=" + FD_PID.this.ping_dest + ", ping_pid=" + FD_PID.this.ping_pid + ", cache=" + FD_PID.this.pids);
            }
            if (FD_PID.this.ping_pid <= 0) {
                if (FD_PID.this.ping_dest != null && FD_PID.this.pids.containsKey(FD_PID.this.ping_dest)) {
                    FD_PID.this.ping_pid = (Integer)FD_PID.this.pids.get(FD_PID.this.ping_dest);
                    if (Trace.trace) {
                        Trace.info("FD_PID.Monitor.run()", "found PID for " + FD_PID.this.ping_dest + " in cache (pid=" + FD_PID.this.ping_pid + ')');
                    }
                } else {
                    if (Trace.trace) {
                        Trace.error("FD_PID.Monitor.run()", "PID for " + FD_PID.this.ping_dest + " not known, cache is " + FD_PID.this.pids);
                    }
                    FD_PID.this.broadcastWhoHasPidMessage(FD_PID.this.ping_dest);
                    return;
                }
            }
            if (!Util.fileExists("/proc/" + FD_PID.this.ping_pid)) {
                if (Trace.trace) {
                    Trace.info("FD_PID.Monitor.run()", "process " + FD_PID.this.ping_pid + " does not exist");
                }
                FD_PID.this.broadcastSuspectMessage(FD_PID.this.ping_dest);
                FD_PID.this.pingable_mbrs.removeElement(FD_PID.this.ping_dest);
                FD_PID.this.ping_dest = FD_PID.this.determinePingDest();
                if (FD_PID.this.ping_dest == null) {
                    this.stop();
                }
                FD_PID.this.ping_pid = 0;
            } else if (Trace.trace) {
                Trace.info("FD_PID.Monitor.run()", FD_PID.this.ping_dest + " is alive");
            }
        }

        private final /* synthetic */ void this() {
            this.started = true;
        }

        private Monitor() {
            this.this();
        }
    }
}

