#!/usr/bin/perl
use DBI;

$user = $ENV{"USER"};
$home = $ENV{"HOME"};
if (open(CFG,"<$home/.cscmailrc")) {
 @cfg = <CFG>;
 close(CFG);
 foreach (@cfg) {
  /^#/ and next;
  /^Database Driver: (\S+)/ and $dbd = $1;
 }
} else { die "You don't have a ~/.cscmailrc, I would say you probably
 do not need to run this program."; }

$conn=DBI->connect("dbi:$dbd:dbname=$user", "", "", {AutoCommit => 1}) or
die "Cannot connect to $user\'s database. Make sure that your
administrator has installed and configured DBI drivers on this machine for
you.";

$sql = "drop table filters";
$conn->do($sql);
if ($dbd eq "Pg") {
 $sql = "create table filters (id int4 default nextval('filtid') PRIMARY KEY,
          sorder int4, type int4, boxid int4, regex text, addr text,
          name text UNIQUE)";
 $conn->do($sql) or die "Could not create table filters\n";
} elsif ($dbd eq "mysql") {
  $sql = "create table filters (id int4 AUTO_INCREMENT PRIMARY KEY,
          sorder int4, type int4, boxid int4, regex text, addr text,
          name varchar(100) NOT NULL, UNIQUE name (name))";
  $conn->do($sql) or die "Could not create table filters\n";
}
print "Database Succesfully updated.\n";
$conn->disconnect;
