/*
 * File...........: s390-tools/dasdfmt/dasdfmt.h
 * Author(s)......: Horst Hummel <Horst.Hummel@de.ibm.com>
 *                  Volker Sameske <sameske@de.ibm.com>
 * Bugreports.to..: <Linux390@de.ibm.com>
 * (C) IBM Corporation, IBM Deutschland Entwicklung GmbH, 2002
 *
 * History of changes (starts March 2002)
 * 2002-03-12 initial
 * 2002-03-20 moved some definitions from dasdfmt.c
 *            removed some useless defines
 * 2002-05-10 changed API handling
 */

#ifndef DASDFMT_H
#define DASDFMT_H

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <getopt.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <mntent.h>
#include <ctype.h>
#include <signal.h>

/****************************************************************************
 * SECTION: Definition needed for DASD-API (see dasd.h)                     *
 ****************************************************************************/

#define DASD_IOCTL_LETTER 'D'

/* 
 * struct dasd_information_t
 * represents any data about the device, which is visible to userspace.
 *  including foramt and featueres.
 */
typedef struct dasd_information_t {
        unsigned int devno;           /* S/390 devno                        */
        unsigned int real_devno;      /* for aliases                        */
        unsigned int schid;           /* S/390 subchannel identifier        */
        unsigned int cu_type  : 16;   /* from SenseID                       */
        unsigned int cu_model :  8;   /* from SenseID                       */
        unsigned int dev_type : 16;   /* from SenseID                       */
        unsigned int dev_model : 8;   /* from SenseID                       */
        unsigned int open_count; 
        unsigned int req_queue_len; 
        unsigned int chanq_len;       /* length of chanq                    */
        char type[4];                 /* from discipline.name,              */
	                              /* 'none' for unknown                 */
        unsigned int status;          /* current device level               */
        unsigned int label_block;     /* where to find the VOLSER           */
        unsigned int FBA_layout;      /* fixed block size (like AIXVOL)     */
        unsigned int characteristics_size;
        unsigned int confdata_size;
        char characteristics[64];     /* from read_device_characteristics   */
        char configuration_data[256]; /* from read_configuration_data       */
} dasd_information_t;

/* 
 * struct format_data_t
 * represents all data necessary to format a dasd
 */
typedef struct format_data_t {
	int start_unit; /* from track */
	int stop_unit;  /* to track */
	int blksize;    /* sectorsize */
        int intensity;  
} format_data_t;

/*
 * values to be used for format_data_t.intensity
 * 0/8: normal format
 * 1/9: also write record zero
 * 3/11: also write home address
 * 4/12: invalidate track
 */
#define DASD_FMT_INT_FMT_R0 1 /* write record zero */
#define DASD_FMT_INT_FMT_HA 2 /* write home address, also set FMT_R0 ! */
#define DASD_FMT_INT_INVAL  4 /* invalidate tracks */
#define DASD_FMT_INT_COMPAT 8 /* use OS/390 compatible disk layout */


/* Disable the volume (for Linux) */
#define BIODASDDISABLE _IO(DASD_IOCTL_LETTER,0) 
/* Enable the volume (for Linux) */
#define BIODASDENABLE  _IO(DASD_IOCTL_LETTER,1)  

/* retrieve API version number */
#define DASDAPIVER     _IOR(DASD_IOCTL_LETTER,0,int)
/* Get information on a dasd device (enhanced) */
#define BIODASDINFO   _IOR(DASD_IOCTL_LETTER,1,dasd_information_t)

/* #define BIODASDFORMAT  _IOW(IOCTL_LETTER,0,format_data_t) , deprecated */
#define BIODASDFMT     _IOW(DASD_IOCTL_LETTER,1,format_data_t) 

/****************************************************************************
 * SECTION: Further IOCTL Definitions  (see fs.h)                           *
 ****************************************************************************/
/* re-read partition table */
#define BLKRRPART  _IO(0x12,95)	
/* get block device sector size */
#define BLKSSZGET  _IO(0x12,104)

/****************************************************************************
 * SECTION: Definition from hdreq.h                                         *
 ****************************************************************************/

struct hd_geometry {
      unsigned char heads;
      unsigned char sectors;
      unsigned short cylinders;
      unsigned long start;
};

/* get device geometry */
#define HDIO_GETGEO		0x0301	

/****************************************************************************
 * SECTION: DASDFMT internal types                                          *
 ****************************************************************************/

#define DASD_PARTN_BITS 2

#define DASD_MIN_API_VERSION 0

#define VERSION_NO "1.06"

#define EXIT_MISUSE 1
#define EXIT_BUSY   2
#define LABEL_LENGTH 14
#define VLABEL_CHARS 84
#define LINE_LENGTH  80
#define ERR_LENGTH   80

#define DEFAULT_BLOCKSIZE  4096
#define USABLE_PARTITIONS  ((1 << DASD_PARTN_BITS) - 1)

#define ERRMSG(x...) {fflush(stdout);fprintf(stderr,x);}
#define ERRMSG_EXIT(ec,x...) {fflush(stdout);fprintf(stderr,x);exit(ec);}

#define CHECK_SPEC_MAX_ONCE(i,str)                       \
	{if (i>1) ERRMSG_EXIT(EXIT_MISUSE,"%s: " str " " \
	"can only be specified once\n",prog_name);}

#define PARSE_PARAM_INTO(x,param,base,str)                     \
	{char *endptr=NULL; x=(int)strtol(param,&endptr,base); \
	if (*endptr) ERRMSG_EXIT(EXIT_MISUSE,"%s: " str " "    \
	"is in invalid format\n",prog_name);}

#define dasdfmt_getopt_string "b:n:l:f:d:m:hpLty?vVF"

static struct option dasdfmt_getopt_long_options[]=
{
        { "disk_layout", 1, 0, 'd'},
        { "test",        0, 0, 't'},
        { "version",     0, 0, 'V'},
        { "no_label",    0, 0, 'L'},
        { "force",       0, 0, 'F'},
        { "progressbar", 0, 0, 'p'},
        { "hashmarks",   1, 0, 'm'},
        { "label",       1, 0, 'l'},
        { "devno",       1, 0, 'n'},
        { "device",      1, 0, 'f'},
        { "blocksize",   1, 0, 'b'},
        { "help",        0, 0, '?'},
        {0, 0, 0, 0}
};

static int            filedes        = 0;
static int            disk_disabled  = 0;
static format_data_t  format_params;
char                 *prog_name;
volatile sig_atomic_t program_interrupt_in_progress = 0;

typedef struct bootstrap1 {
        u_int32_t key;
        u_int32_t data[6];
} __attribute__ ((packed)) bootstrap1_t;

typedef struct bootstrap2 {
        u_int32_t key;
        u_int32_t data[36];
} __attribute__ ((packed)) bootstrap2_t;

typedef struct dasdfmt_info {
        int   devno;
        char  devname[LINE_LENGTH];
        int   usage_count;
        int   verbosity;
        int   testmode;
        int   withoutprompt;
        int   print_progressbar;
        int   print_hashmarks, hashstep;
        int   force;
        int   writenolabel;
        int   labelspec;
        int   cdl_format;
        int   blksize_specified;
        int   node_specified;
        int   devno_specified;
} dasdfmt_info_t;


/*
C9D7D3F1 000A0000 0000000F 03000000  00000001 00000000 00000000
*/
bootstrap1_t ipl1 = {
        0xC9D7D3F1, {
                0x000A0000, 0x0000000F, 0x03000000,
                0x00000001, 0x00000000, 0x00000000
        }
};

/*
C9D7D3F2 07003AB8 40000006 31003ABE  40000005 08003AA0 00000000 06000000
20000000 00000000 00000000 00000400  00000000 00000000 00000000 00000000
00000000 00000000 00000000 00000000  00000000 00000000 00000000 00000000
00000000 00000000 00000000 00000000  00000000 00000000 00000000 00000000
00000000 00000000 00000000 00000000  00000000
*/
bootstrap2_t ipl2 = {
        0xC9D7D3F2, {
                0x07003AB8, 0x40000006, 0x31003ABE,
                0x40000005, 0x08003AA0, 0x00000000,
                0x06000000, 0x20000000, 0x00000000,
                0x00000000, 0x00000400, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000
        }
};

#endif /* DASDFMT_H */

