#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

   - Selection of default file names based on mime-types.
   - Filename truncation (should be truncated from the right)
   - Simple application of the drop, save, mangle, defang and accept
     policies.  The exclamation-policies are also tested.

tac

BINFALSE=/bin/false
[ -x /usr/bin/false ] && BINFALSE=/usr/bin/false || true
export BINFALSE

rm -f ./.tmp.*
#    'file_characters = A-Za-z0-9 ' \
$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'feat_force_name = 1' \
    'file_list_rules = 11' \
    "file_list_1_scanner = 0:1::$BINFALSE" \
    'file_list_1_policy = unknown^10:unknown^10:unknown:unknown' \
    'file_list_1 = .txt$' \
    'file_list_2_policy = save' \
    'file_list_2_scanner = 0' \
    'file_list_2 = red.txt' \
    'file_list_3_policy = mangle' \
    'file_list_3_scanner = 0' \
    'file_list_3 = orange.txt' \
    'file_list_4_policy = defang' \
    'file_list_4_scanner = 0' \
    'file_list_4 = yellw.txt' \
    'file_list_5_policy = accept' \
    'file_list_5_scanner = 0' \
    'file_list_5 = green.txt' \
    'file_list_6_policy = drop' \
    'file_list_6_scanner = 0' \
    'file_list_6 = winmail.dat' \
    'file_list_7_policy = warn^8' \
    'file_list_7_scanner = 0' \
    'file_list_7 = strange.txt' \
    'file_list_8_policy = accept' \
    'file_list_8_scanner = 0' \
    'file_list_8 = strange.txt' \
    'file_list_9_policy = unknown^11' \
    'file_list_9_scanner = 0' \
    'file_list_9 = .' \
    'file_list_10_policy = unknown^2' \
    'file_list_10_scanner = 0' \
    'file_list_10 = .' \
    'file_list_11_policy = accept:drop:drop:drop' \
    'file_list_11_scanner = 0:1::./sanitizer.filenames.hlp %FILENAME %ATTNAME' \
    'file_list_11 = replace.me' \
    'file_default_policy = defang!' \
    'file_default_filename = yellw.txt' \
    'file_name_tpl = ./.tmp.$$$' \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: this is a very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very long subject which looks a bit like a file name.txt with more than one extension.exe
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: application/ms-tnef; charset="evil"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

this is a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: application/x-snort-snort; charset="iso-8859-1"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

this is an unnamed file, which should be treated as if it were yellow

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment;
 filename="aaaaaaaaa0aaaaaaaaa1aaaaaaaaa2aaaaaaaaa3aaaaaaaaa4aaaaaaaaa5aaaaaaaaa6aaaaaaaaa7aaaaaaaa.vbs.txt"
Content-Transfer-Encoding: 8bit

this is also a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="red.txt"
Content-Transfer-Encoding: 8bit

this file is rather evil

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="orange.txt"
Content-Transfer-Encoding: 8bit

this file is pretty yucky

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="yellw.txt"
Content-Transfer-Encoding: 8bit

this file is somewhat suspicious

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="green.txt"
Content-Transfer-Encoding: 8bit

this file is nice

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="strange.txt"
Content-Transfer-Encoding: 8bit

this file is strange

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="scan me silly.txt"
Content-Transfer-Encoding: base64

L2Jpbi9mYWxzZSBtZSE=

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="scan me happy.txt"
Content-Transfer-Encoding: 8bit

Yeah baby.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="replace.me"
Content-Transfer-Encoding: 8bit

Yeah baby.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"; name="other.name.boo"; filename="fee.boo"
Content-Disposition: attachment; filename="some.other.name.blrg"; name="rah.boo"
Content-Description: Some fake filename .boo
Content-ID: Alphabet.blrg
Content-Transfer-Encoding: 8bit

This file should get renamed, and since it has two name/filename 
attributes, both should get modified.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF

echo "*** Exit code was $? ***" >>test.out
cat test.out |sed -e "s,$BINFALSE,/bin/false,g" >test2.out
mv -f test2.out test.out

echo ./.tmp.* >>test.out 2>&1
rm ./.tmp.*  >>test.out 2>&1
exit 0
