
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ReturnStatement.hh"
#include "savant.hh"

IIRBase_ReturnStatement::IIRBase_ReturnStatement() {
  set_enclosing_subprogram(NULL);
  set_return_expression(NULL); 
}

IIRBase_ReturnStatement::~IIRBase_ReturnStatement() {
  delete get_return_expression();
}

void
IIRBase_ReturnStatement::set_enclosing_subprogram( IIR_SubprogramDeclaration*
						   enclosing_subprogram) {
  this->enclosing_subprogram = enclosing_subprogram;
}

IIR_SubprogramDeclaration*
IIRBase_ReturnStatement::get_enclosing_subprogram() {
  return enclosing_subprogram;
}

void IIRBase_ReturnStatement::set_return_expression( IIR* return_expression) {
  this->return_expression =  return_expression;
}

IIR*
IIRBase_ReturnStatement::get_return_expression() {
  return  return_expression;
}
