/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdtreelb.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:01:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <bf_svx/svditer.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
#ifndef _SD_CUSSHOW_HXX
#include "cusshow.hxx"
#endif

#include "strmname.h"
#include "sdtreelb.hxx"
#include "viewshel.hxx"
#include "docshell.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "sdview.hxx"
#include "sdresid.hxx"
#include "navichld.hxx"
#include "navigatr.hxx"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "so3/staticbaseurl.hxx"
namespace binfilter {


//STRIP001 BOOL SdPageObjsTLB::bIsInDrag = FALSE;

// -----------------------------------------
// - SdPageObjsTLB::SdPageObjsTransferable -
// -----------------------------------------

//STRIP001 SdPageObjsTLB::SdPageObjsTransferable::~SdPageObjsTransferable()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdPageObjsTLB::SdPageObjsTransferable::AddSupportedFormats()
//STRIP001 {
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SdPageObjsTLB::SdPageObjsTransferable::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	SetINetBookmark( maBookmark, rFlavor );
//STRIP001 	return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdPageObjsTLB::SdPageObjsTransferable::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	mrParent.DragFinished( nDropAction );
//STRIP001 }
//STRIP001 
// -----------------------------------------------------------------------------

//STRIP001 SdDrawDocShell& SdPageObjsTLB::SdPageObjsTransferable::GetDocShell() const
//STRIP001 {
//STRIP001     return mrDocShell;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 NavigatorDragType SdPageObjsTLB::SdPageObjsTransferable::GetDragType() const
//STRIP001 {
//STRIP001     return meDragType;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 sal_Int64 SAL_CALL SdPageObjsTLB::SdPageObjsTransferable::getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& rId ) throw( ::com::sun::star::uno::RuntimeException )
//STRIP001 {
//STRIP001     sal_Int64 nRet;
//STRIP001 
//STRIP001     if( ( rId.getLength() == 16 ) && 
//STRIP001         ( 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(), rId.getConstArray(), 16 ) ) )
//STRIP001     {
//STRIP001         nRet = (sal_Int64) this;
//STRIP001     }
//STRIP001     else
//STRIP001         nRet = 0;
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 const ::com::sun::star::uno::Sequence< sal_Int8 >& SdPageObjsTLB::SdPageObjsTransferable::getUnoTunnelId()
//STRIP001 {
//STRIP001     static ::com::sun::star::uno::Sequence< sal_Int8 > aSeq;
//STRIP001 
//STRIP001 	if( !aSeq.getLength() )
//STRIP001 	{
//STRIP001 		static osl::Mutex   aCreateMutex;
//STRIP001     	osl::MutexGuard     aGuard( aCreateMutex );
//STRIP001 
//STRIP001 		aSeq.realloc( 16 );
//STRIP001     	rtl_createUuid( reinterpret_cast< sal_uInt8* >( aSeq.getArray() ), 0, sal_True );
//STRIP001 	}
//STRIP001 	
//STRIP001     return aSeq;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SdPageObjsTLB::SdPageObjsTransferable* SdPageObjsTLB::SdPageObjsTransferable::getImplementation( const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& rxData ) 
//STRIP001     throw()
//STRIP001 {
//STRIP001     try
//STRIP001     {
//STRIP001 	    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XUnoTunnel > xUnoTunnel( rxData, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 
//STRIP001         return( xUnoTunnel.is() ? 
//STRIP001                 ( (SdPageObjsTLB::SdPageObjsTransferable*)(void*) xUnoTunnel->getSomething( SdPageObjsTLB::SdPageObjsTransferable::getUnoTunnelId() ) ) :
//STRIP001                 NULL );
//STRIP001     }
//STRIP001     catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001         return NULL;
//STRIP001 	}
//STRIP001 }

//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ctor1 SdPageObjsTLB
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdPageObjsTLB::SdPageObjsTLB( Window* pParentWin, const SdResId& rSdResId,
//STRIP001 							  BOOL bEnableDrop ) :
//STRIP001 	SvTreeListBox       ( pParentWin, rSdResId ),
//STRIP001 	pParent 		    ( pParentWin ),
//STRIP001 	pDoc			    ( NULL ),
//STRIP001 	pBookmarkDoc	    ( NULL ),
//STRIP001 	pMedium 	    	( NULL ),
//STRIP001 	pOwnMedium		    ( NULL ),
//STRIP001 	aTransparencyColor	( RGB_COLORDATA (0xff,0,0xff) ),
//STRIP001 	aImgOle             ( Bitmap( SdResId( BMP_OLE ) ), aTransparencyColor ),
//STRIP001 	aImgGraphic         ( Bitmap( SdResId( BMP_GRAPHIC ) ), aTransparencyColor ),
//STRIP001 	aImgOleH            ( Bitmap( SdResId( BMP_OLE_H ) ), aTransparencyColor),
//STRIP001 	aImgGraphicH        ( Bitmap( SdResId( BMP_GRAPHIC_H ) ), aTransparencyColor),
//STRIP001 	pDropNavWin		    ( NULL ),
//STRIP001 	bLinkableSelected   ( FALSE )
//STRIP001 {
//STRIP001 	// Tree-ListBox mit Linien versehen
//STRIP001 	SetWindowBits( WinBits( WB_TABSTOP | WB_BORDER | WB_HASLINES |
//STRIP001 							WB_HASBUTTONS | // WB_HASLINESATROOT |
//STRIP001 							WB_HSCROLL | // #31562#
//STRIP001 							WB_HASBUTTONSATROOT ) );
//STRIP001 	SetNodeBitmaps( Bitmap( SdResId( BMP_EXPAND ) ),
//STRIP001 					Bitmap( SdResId( BMP_COLLAPSE ) ) );
//STRIP001 
//STRIP001 	SetNodeBitmaps( Bitmap( SdResId( BMP_EXPAND_H ) ),
//STRIP001 					Bitmap( SdResId( BMP_COLLAPSE_H ) ), 
//STRIP001 					BMP_COLOR_HIGHCONTRAST );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Dtor SdPageObjsTLB
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdPageObjsTLB::~SdPageObjsTLB()
//STRIP001 {
//STRIP001 	CloseBookmarkDoc();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* return name of object
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 String SdPageObjsTLB::GetObjectName( const SdrObject* pObj ) const
//STRIP001 {
//STRIP001     String aRet;
//STRIP001 
//STRIP001     if( pObj )
//STRIP001     {
//STRIP001         aRet = pObj->GetName();
//STRIP001 
//STRIP001         if( !aRet.Len() && pObj->ISA( SdrOle2Obj ) )
//STRIP001             aRet = static_cast< const SdrOle2Obj* >( pObj )->GetPersistName();
//STRIP001     }
//STRIP001 
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* In TreeLB Eintrag selektieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SdPageObjsTLB::SelectEntry( const String& rName )
//STRIP001 {
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	if( rName.Len() )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = NULL;
//STRIP001 		String aTmp;
//STRIP001 
//STRIP001 		for( pEntry = First(); pEntry && !bFound; pEntry = Next( pEntry ) )
//STRIP001 		{
//STRIP001 			aTmp = GetEntryText( pEntry );
//STRIP001 			if( aTmp == rName )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				SetCurEntry( pEntry );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( bFound );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Gibt zurueck, ob Childs des uebergebenen Strings selektiert sind
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SdPageObjsTLB::HasSelectedChilds( const String& rName )
//STRIP001 {
//STRIP001 	BOOL bFound  = FALSE;
//STRIP001 	BOOL bChilds = FALSE;
//STRIP001 
//STRIP001 	if( rName.Len() )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = NULL;
//STRIP001 		String aTmp;
//STRIP001 
//STRIP001 		for( pEntry = First(); pEntry && !bFound; pEntry = Next( pEntry ) )
//STRIP001 		{
//STRIP001 			aTmp = GetEntryText( pEntry );
//STRIP001 			if( aTmp == rName )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				BOOL bExpanded = IsExpanded( pEntry );
//STRIP001 				long nCount = GetChildSelectionCount( pEntry );
//STRIP001 #if SUPD < 335
//STRIP001 				nCount++;
//STRIP001 #endif
//STRIP001 				if( bExpanded && nCount > 0 )
//STRIP001 					bChilds = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( bChilds );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* TreeLB mit Seiten und Objekten fuellen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::Fill( const SdDrawDocument* pInDoc, BOOL bAllPages,
//STRIP001 						  const String& rDocName)
//STRIP001 {
//STRIP001 	String aSelection;
//STRIP001 	if( GetSelectionCount() > 0 )
//STRIP001 	{
//STRIP001 		aSelection = GetSelectEntry();
//STRIP001 		Clear();
//STRIP001 	}
//STRIP001 
//STRIP001 	pDoc = pInDoc;
//STRIP001 	aDocName = rDocName;
//STRIP001 
//STRIP001 	SdrObject*	 pObj = NULL;
//STRIP001 	SdPage* 	 pPage = NULL;
//STRIP001 	SvLBoxEntry* pEntry = NULL;
//STRIP001 
//STRIP001 	Bitmap aBmpPage( SdResId( BMP_PAGE ) );
//STRIP001 	Image aImgPage( aBmpPage, aTransparencyColor );
//STRIP001 	Bitmap aBmpPageExcl( SdResId( BMP_PAGE_EXCLUDED ) );
//STRIP001 	Image aImgPageExcl( aBmpPageExcl, aTransparencyColor );
//STRIP001 	Bitmap aBmpPageObjsExcl( SdResId( BMP_PAGEOBJS_EXCLUDED ) );
//STRIP001 	Image aImgPageObjsExcl( aBmpPageObjsExcl, aTransparencyColor );
//STRIP001 	Bitmap aBmpPageObjs( SdResId( BMP_PAGEOBJS ) );
//STRIP001 	Image aImgPageObjs( aBmpPageObjs, aTransparencyColor );
//STRIP001 	Bitmap aBmpObjects( SdResId( BMP_OBJECTS ) );
//STRIP001 	Image aImgObjects( aBmpObjects, aTransparencyColor );
//STRIP001 
//STRIP001 	Bitmap aBmpPageH( SdResId( BMP_PAGE_H ) );
//STRIP001 	Image aImgPageH( aBmpPageH , aTransparencyColor );
//STRIP001 	Bitmap aBmpPageExclH( SdResId( BMP_PAGE_EXCLUDED_H ) );
//STRIP001 	Image aImgPageExclH( aBmpPageExclH, aTransparencyColor );
//STRIP001 	Bitmap aBmpPageObjExclH( SdResId( BMP_PAGEOBJS_EXCLUDED_H ) );
//STRIP001 	Image aImgPageObjsExclH( aBmpPageObjExclH, aTransparencyColor );
//STRIP001 	Bitmap aBmpPageObjsH( SdResId( BMP_PAGEOBJS_H ) );
//STRIP001 	Image aImgPageObjsH( aBmpPageObjsH, aTransparencyColor );
//STRIP001 	Bitmap aBmpObjectsH( SdResId( BMP_OBJECTS_H ) );
//STRIP001 	Image aImgObjectsH( aBmpObjectsH, aTransparencyColor );
//STRIP001 
//STRIP001 	// Zuerst alle Pages incl. Objekte einfuegen
//STRIP001 	USHORT nPage = 0;
//STRIP001 	const USHORT nMaxPages = pDoc->GetPageCount();
//STRIP001 
//STRIP001 	while( nPage < nMaxPages )
//STRIP001 	{
//STRIP001 		pPage = (SdPage*) pDoc->GetPage( nPage );
//STRIP001 		if(  (bAllPages || pPage->GetPageKind() == PK_STANDARD)
//STRIP001 		     && !(pPage->GetPageKind()==PK_HANDOUT)   ) //#94954# never list the normal handout page ( handout-masterpage is used instead )
//STRIP001 		{
//STRIP001 			BOOL bPageExluded = pPage->IsExcluded();
//STRIP001 
//STRIP001             bool bPageBelongsToShow = PageBelongsToCurrentShow (pPage);
//STRIP001             bPageExluded |= !bPageBelongsToShow;
//STRIP001 
//STRIP001 			pEntry = InsertEntry( pPage->GetName(), 
//STRIP001 			                      bPageExluded ? aImgPageExcl : aImgPage,
//STRIP001 								  bPageExluded ? aImgPageExcl : aImgPage,
//STRIP001 								  0, 
//STRIP001 								  FALSE, 
//STRIP001 								  LIST_APPEND, 
//STRIP001 								  reinterpret_cast< void* >( 1 ) );
//STRIP001 
//STRIP001 			SetExpandedEntryBmp( pEntry, bPageExluded ? aImgPageExclH : aImgPageH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 			SetCollapsedEntryBmp( pEntry, bPageExluded ? aImgPageExclH : aImgPageH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 			SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 			while( aIter.IsMore() )
//STRIP001 			{
//STRIP001 				pObj = aIter.Next();
//STRIP001 				String aStr( GetObjectName( pObj ) );
//STRIP001 				if( aStr.Len() )
//STRIP001 				{
//STRIP001 					if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_OLE2 )
//STRIP001 					{
//STRIP001 						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgOle, aImgOle, pEntry );
//STRIP001 						
//STRIP001 						SetExpandedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 					else if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRAF )
//STRIP001 					{
//STRIP001 						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgGraphic, aImgGraphic, pEntry );
//STRIP001 						
//STRIP001 						SetExpandedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 					    SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgObjects, aImgObjects, pEntry );
//STRIP001 						
//STRIP001 						SetExpandedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if( pEntry->HasChilds() )
//STRIP001 			{
//STRIP001 				SetExpandedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExcl : aImgPageObjs );
//STRIP001 				SetCollapsedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExcl : aImgPageObjs );
//STRIP001 				SetExpandedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExclH : aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 				SetCollapsedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExclH : aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nPage++;
//STRIP001 	}
//STRIP001 
//STRIP001 	// dann alle MasterPages incl. Objekte einfuegen
//STRIP001 	if( bAllPages )
//STRIP001 	{
//STRIP001 		nPage = 0;
//STRIP001 		const USHORT nMaxMasterPages = pDoc->GetMasterPageCount();
//STRIP001 
//STRIP001 		while( nPage < nMaxMasterPages )
//STRIP001 		{
//STRIP001 			pPage = (SdPage*) pDoc->GetMasterPage( nPage );
//STRIP001 			pEntry = InsertEntry( pPage->GetName(), 
//STRIP001 			                      aImgPage, 
//STRIP001 			                      aImgPage, 
//STRIP001 			                      0, 
//STRIP001 								  FALSE, 
//STRIP001 								  LIST_APPEND, 
//STRIP001 								  reinterpret_cast< void* >( 1 ) );
//STRIP001 			
//STRIP001 			SetExpandedEntryBmp( pEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 			SetCollapsedEntryBmp( pEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 			SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 			while( aIter.IsMore() )
//STRIP001 			{
//STRIP001 				pObj = aIter.Next();
//STRIP001 				String aStr( GetObjectName( pObj ) );
//STRIP001 				if( aStr.Len() )
//STRIP001 				{
//STRIP001 					if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_OLE2 )
//STRIP001 					{
//STRIP001 						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgOle, aImgOle, pEntry ); // pEntry entspr. Parent

//STRIP001 						SetExpandedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 					else if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRAF )
//STRIP001 					{
//STRIP001 						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgGraphic, aImgGraphic, pEntry ); // pEntry entspr. Parent

//STRIP001 						SetExpandedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgObjects, aImgObjects, pEntry );

//STRIP001 						SetExpandedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if( pEntry->HasChilds() )
//STRIP001 			{
//STRIP001 				SetExpandedEntryBmp( pEntry, aImgPageObjs );
//STRIP001 				SetCollapsedEntryBmp( pEntry, aImgPageObjs );
//STRIP001 				SetExpandedEntryBmp( pEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 				SetCollapsedEntryBmp( pEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 			}
//STRIP001 			nPage++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( aSelection.Len() )
//STRIP001 		SelectEntry( aSelection );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Es wird nur der erste Eintrag eingefuegt. Childs werden OnDemand erzeugt
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::Fill( const SdDrawDocument* pInDoc, SfxMedium* pInMedium,
//STRIP001 						  const String& rDocName )
//STRIP001 {
//STRIP001 	pDoc = pInDoc;
//STRIP001 	pMedium = pInMedium;
//STRIP001 	aDocName = rDocName;
//STRIP001 
//STRIP001 	SdrObject*	 pObj = NULL;
//STRIP001 	SdPage* 	 pPage = NULL;
//STRIP001 	SvLBoxEntry* pFileEntry = NULL;
//STRIP001 	SvLBoxEntry* pPageEntry = NULL;
//STRIP001 
//STRIP001 	Bitmap aBmpDocOpen( SdResId( BMP_DOC_OPEN ) );
//STRIP001 	Image aImgDocOpen( aBmpDocOpen, aTransparencyColor );
//STRIP001 	Bitmap aBmpDocClosed( SdResId( BMP_DOC_CLOSED ) );
//STRIP001 	Image aImgDocClosed( aBmpDocClosed, aTransparencyColor );
//STRIP001 	Bitmap aBmpDocOpenH( SdResId( BMP_DOC_OPEN_H ) );
//STRIP001 	Image aImgDocOpenH( aBmpDocOpenH, aTransparencyColor );
//STRIP001 	Bitmap aBmpDocClosedH( SdResId( BMP_DOC_CLOSED_H ) );
//STRIP001 	Image aImgDocClosedH( aBmpDocClosedH, aTransparencyColor );
//STRIP001 
//STRIP001 	// Dokumentnamen einfuegen
//STRIP001 	pFileEntry = InsertEntry( aDocName, 
//STRIP001 	                          aImgDocOpen, 
//STRIP001 	                          aImgDocClosed,	
//STRIP001 	                          NULL, 
//STRIP001 	                          TRUE,
//STRIP001 							  LIST_APPEND, 
//STRIP001 							  reinterpret_cast< void* >( 1 ) );
//STRIP001 	
//STRIP001 	SetExpandedEntryBmp( pFileEntry, aImgDocOpenH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 	SetCollapsedEntryBmp( pFileEntry, aImgDocClosedH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Prueft, ob die Seiten (PK_STANDARD) und die darauf befindlichen Objekte
//STRIP001 |* des Docs und der TreeLB identisch sind.
//STRIP001 |* Wird ein Doc uebergeben, wird dieses zum aktuellem Doc (Wichtig bei
//STRIP001 |* mehreren Documenten).
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SdPageObjsTLB::IsEqualToDoc( const SdDrawDocument* pInDoc )
//STRIP001 {
//STRIP001 	if( pInDoc )
//STRIP001 		pDoc = pInDoc;
//STRIP001 
//STRIP001 	if( !pDoc )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	SdrObject*	 pObj = NULL;
//STRIP001 	SdPage* 	 pPage = NULL;
//STRIP001 	SvLBoxEntry* pEntry = First();
//STRIP001 	String		 aName;
//STRIP001 
//STRIP001 	// Alle Pages incl. Objekte vergleichen
//STRIP001 	USHORT nPage = 0;
//STRIP001 	const USHORT nMaxPages = pDoc->GetPageCount();
//STRIP001 
//STRIP001 	while( nPage < nMaxPages )
//STRIP001 	{
//STRIP001 		pPage = (SdPage*) pDoc->GetPage( nPage );
//STRIP001 		if( pPage->GetPageKind() == PK_STANDARD )
//STRIP001 		{
//STRIP001 			if( !pEntry )
//STRIP001 				return( FALSE );
//STRIP001 			aName = GetEntryText( pEntry );
//STRIP001 
//STRIP001 			if( pPage->GetName() != aName )
//STRIP001 				return( FALSE );
//STRIP001 
//STRIP001 			pEntry = Next( pEntry );
//STRIP001 
//STRIP001 			SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 			while( aIter.IsMore() )
//STRIP001 			{
//STRIP001 				pObj = aIter.Next();
//STRIP001                 
//STRIP001                 const String aObjectName( GetObjectName( pObj ) );
//STRIP001 
//STRIP001 				if( aObjectName.Len() )
//STRIP001 				{
//STRIP001 					if( !pEntry )
//STRIP001 						return( FALSE );
//STRIP001 				
//STRIP001                 	aName = GetEntryText( pEntry );
//STRIP001 
//STRIP001 					if( aObjectName != aName )
//STRIP001 						return( FALSE );
//STRIP001 
//STRIP001 					pEntry = Next( pEntry );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nPage++;
//STRIP001 	}
//STRIP001 	// Wenn noch Eintraege in der Listbox vorhanden sind, wurden
//STRIP001 	// Objekte (mit Namen) oder Seiten geloescht
//STRIP001 	return( !pEntry );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Selectierten String zurueckgeben
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 String SdPageObjsTLB::GetSelectEntry()
//STRIP001 {
//STRIP001 	return( GetEntryText( GetCurEntry() ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Selektierte Eintrage zurueckgeben
//STRIP001 |* nDepth == 0 -> Seiten
//STRIP001 |* nDepth == 1 -> Objekte
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 List* SdPageObjsTLB::GetSelectEntryList( USHORT nDepth )
//STRIP001 {
//STRIP001 	List*		 pList	= NULL;
//STRIP001 	SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 
//STRIP001 	while( pEntry )
//STRIP001 	{
//STRIP001 		USHORT nListDepth = GetModel()->GetDepth( pEntry );
//STRIP001 		if( nListDepth == nDepth )
//STRIP001 		{
//STRIP001 			if( !pList )
//STRIP001 				pList = new List();
//STRIP001 
//STRIP001 			const String aEntryText( GetEntryText( pEntry ) );
//STRIP001 			pList->Insert( new String( aEntryText ), LIST_APPEND );
//STRIP001 		}
//STRIP001 		pEntry = NextSelected( pEntry );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( pList );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Alle Pages (und Objekte) des Docs zurueckgeben
//STRIP001 |* nType == 0 -> Seiten
//STRIP001 |* nType == 1 -> Objekte
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 List* SdPageObjsTLB::GetBookmarkList( USHORT nType )
//STRIP001 {
//STRIP001 	List* pList	= NULL;
//STRIP001 
//STRIP001 	if( GetBookmarkDoc() )
//STRIP001 	{
//STRIP001 		SdPage* 	 pPage = NULL;
//STRIP001 		String*		 pName = NULL;
//STRIP001 		USHORT 		 nPage = 0;
//STRIP001 		const USHORT nMaxPages = pBookmarkDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 
//STRIP001 		while( nPage < nMaxPages )
//STRIP001 		{
//STRIP001 			pPage = pBookmarkDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001 			if( nType == 0 ) // Seitennamen einfuegen
//STRIP001 			{
//STRIP001 				if( !pList )
//STRIP001 					pList = new List();
//STRIP001 
//STRIP001 				pName = new String( pPage->GetRealName() );
//STRIP001 				pList->Insert( pName, LIST_APPEND );
//STRIP001 			}
//STRIP001 			else // Objektnamen einfuegen
//STRIP001 			{
//STRIP001 				// Ueber Objekte der Seite iterieren
//STRIP001 				SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 				while( aIter.IsMore() )
//STRIP001 				{
//STRIP001 					SdrObject* pObj = aIter.Next();
//STRIP001 					String aStr( GetObjectName( pObj ) );
//STRIP001 					if( aStr.Len() )
//STRIP001 					{
//STRIP001 						if( !pList )
//STRIP001 							pList = new List();
//STRIP001 
//STRIP001 						pName = new String( aStr );
//STRIP001 						pList->Insert( pName, LIST_APPEND );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nPage++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( pList );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Eintraege werden erst auf Anforderung (Doppelklick) eingefuegt
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::RequestingChilds( SvLBoxEntry* pFileEntry )
//STRIP001 {
//STRIP001 	if( !pFileEntry->HasChilds() )
//STRIP001 	{
//STRIP001 		if( GetBookmarkDoc() )
//STRIP001 		{
//STRIP001 			SdrObject*	 pObj = NULL;
//STRIP001 			SdPage* 	 pPage = NULL;
//STRIP001 			SvLBoxEntry* pPageEntry = NULL;
//STRIP001 
//STRIP001 			Bitmap aBmpPage( SdResId( BMP_PAGE ) );
//STRIP001 			Image aImgPage( aBmpPage, aTransparencyColor );
//STRIP001 			Bitmap aBmpPageObjs( SdResId( BMP_PAGEOBJS ) );
//STRIP001 			Image aImgPageObjs( aBmpPageObjs, aTransparencyColor );
//STRIP001 			Bitmap aBmpObjects( SdResId( BMP_OBJECTS ) );
//STRIP001 			Image aImgObjects( aBmpObjects, aTransparencyColor );
//STRIP001 			Bitmap aBmpPageH( SdResId( BMP_PAGE_H ) );
//STRIP001 			Image aImgPageH( aBmpPageH, aTransparencyColor );
//STRIP001 			Bitmap aBmpPageObjsH( SdResId( BMP_PAGEOBJS_H ) );
//STRIP001 			Image aImgPageObjsH( aBmpPageObjsH, aTransparencyColor );
//STRIP001 			Bitmap aBmpImgObjectsH( SdResId( BMP_OBJECTS_H ) );
//STRIP001 			Image aImgObjectsH( aBmpImgObjectsH, aTransparencyColor );
//STRIP001 
//STRIP001 			// Dokumentname ist schon eingefuegt
//STRIP001 
//STRIP001 			// Nur alle "normalen" Pages mit Objekten einfuegen
//STRIP001 			USHORT nPage = 0;
//STRIP001 			const USHORT nMaxPages = pBookmarkDoc->GetPageCount();
//STRIP001 
//STRIP001 			while( nPage < nMaxPages )
//STRIP001 			{
//STRIP001 				pPage = (SdPage*) pBookmarkDoc->GetPage( nPage );
//STRIP001 				if( pPage->GetPageKind() == PK_STANDARD )
//STRIP001 				{
//STRIP001 					pPageEntry = InsertEntry( pPage->GetName(),
//STRIP001 					                          aImgPage, 
//STRIP001 					                          aImgPage, 
//STRIP001 					                          pFileEntry,
//STRIP001 							                  FALSE, 
//STRIP001 								              LIST_APPEND, 
//STRIP001 								              reinterpret_cast< void* >( 1 ) );
//STRIP001 
//STRIP001 					SetExpandedEntryBmp( pPageEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					SetCollapsedEntryBmp( pPageEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 					SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 					while( aIter.IsMore() )
//STRIP001 					{
//STRIP001 						pObj = aIter.Next();
//STRIP001 						String aStr( GetObjectName( pObj ) );
//STRIP001 						if( aStr.Len() )
//STRIP001 						{
//STRIP001 							if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_OLE2 )
//STRIP001 							{
//STRIP001 								SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgOle, aImgOle, pPageEntry );

//STRIP001 								SetExpandedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 								SetCollapsedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 							}
//STRIP001 							else if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRAF )
//STRIP001 							{
//STRIP001 								SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgGraphic, aImgGraphic, pPageEntry ); // pEntry entspr. Parent

//STRIP001 								SetExpandedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 								SetCollapsedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgObjects, aImgObjects, pPageEntry );

//STRIP001 								SetExpandedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 								SetCollapsedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					if( pPageEntry->HasChilds() )
//STRIP001 					{
//STRIP001 						SetExpandedEntryBmp( pPageEntry, aImgPageObjs );
//STRIP001 						SetCollapsedEntryBmp( pPageEntry, aImgPageObjs );
//STRIP001 						SetExpandedEntryBmp( pPageEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 						SetCollapsedEntryBmp( pPageEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				nPage++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SvTreeListBox::RequestingChilds( pFileEntry );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Prueft, ob es sich um eine Draw-Datei handelt und oeffnet anhand des
//STRIP001 |*	uebergebenen Docs das BookmarkDoc
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdDrawDocument* SdPageObjsTLB::GetBookmarkDoc(SfxMedium* pMed)
//STRIP001 {
//STRIP001 	if (!pBookmarkDoc ||
//STRIP001 		pMed && (!pOwnMedium || pOwnMedium->GetName() != pMed->GetName()))
//STRIP001 	{
//STRIP001 		if (pOwnMedium != pMed)
//STRIP001 		{
//STRIP001 			CloseBookmarkDoc();
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxMedium* pWorkMedium = NULL;
//STRIP001 
//STRIP001 		if (pMed)
//STRIP001 		{
//STRIP001 			// Dieses Medium gehoert nun SdPageObjsTLB
//STRIP001 			pOwnMedium = pMed;
//STRIP001 			pWorkMedium = pOwnMedium;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			delete pOwnMedium;
//STRIP001 			pOwnMedium = NULL;
//STRIP001 			pWorkMedium = pMedium;
//STRIP001 
//STRIP001 			// Das Medium muss mit READ/WRITE geoeffnet werden, da es ev.
//STRIP001 			// OLE-Objekte enthaelt, welche geclont werden
//STRIP001 			// (innerhalb dieses Mediums)
//STRIP001 
//STRIP001 			// #70116#: OpenMode is set only to STREAM_READ
//STRIP001 			pWorkMedium->SetOpenMode(STREAM_READ /*WRITE | STREAM_SHARE_DENYWRITE | STREAM_NOCREATE */,
//STRIP001 										FALSE);
//STRIP001 			pWorkMedium->ReOpen();
//STRIP001 		}
//STRIP001 
//STRIP001 		SvStorage* pStorage;
//STRIP001 
//STRIP001 		if( !pWorkMedium->IsStorage() )
//STRIP001 		{
//STRIP001 			// Nun wird eine Kopie angelegt. In diese Kopie darf
//STRIP001 			// geschrieben werden
//STRIP001 			pWorkMedium = new SfxMedium(*pWorkMedium, TRUE);
//STRIP001 			pStorage = ( pWorkMedium->IsStorage() ? pWorkMedium->GetStorage() : NULL );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pStorage = pWorkMedium->GetStorage();
//STRIP001 
//STRIP001 		// ist es eine Draw-Datei?
//STRIP001 		if( pStorage && 
//STRIP001 			( pStorage->IsStream( pStarDrawDoc ) || 
//STRIP001 			  pStorage->IsStream( pStarDrawDoc3 ) || 
//STRIP001 			  pStorage->IsStream( pStarDrawXMLContent ) ||
//STRIP001 			  pStorage->IsStream( pStarDrawOldXMLContent ) ) )
//STRIP001 		{
//STRIP001 			if( pMed )
//STRIP001 			{
//STRIP001 				// Da das Medium der SdTreeLb gehoert, gehoert auch die
//STRIP001 				// nun zu erzeugende DocShell der SdTreeLb
//STRIP001 				xBookmarkDocShRef = new SdDrawDocShell(SFX_CREATE_MODE_STANDARD, TRUE);
//STRIP001 
//STRIP001 				if (xBookmarkDocShRef->DoLoad(pMed))
//STRIP001 					pBookmarkDoc = xBookmarkDocShRef->GetDoc();
//STRIP001 				else
//STRIP001 					pBookmarkDoc = NULL;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pBookmarkDoc = ((SdDrawDocument*) pDoc)->OpenBookmarkDoc(*pWorkMedium);
//STRIP001 		}
//STRIP001 		else			 // unbekanntes Storage-Format
//STRIP001 		{
//STRIP001 			ErrorBox aErrorBox( this, WB_OK, String( SdResId( STR_READ_DATA_ERROR ) ) );
//STRIP001 			aErrorBox.Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( pBookmarkDoc );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Bookmark-Dokument schlieen und loeschen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::CloseBookmarkDoc()
//STRIP001 {
//STRIP001 	if (xBookmarkDocShRef.Is())
//STRIP001 	{
//STRIP001 		xBookmarkDocShRef->DoClose();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (pBookmarkDoc && pDoc)
//STRIP001 			((SdDrawDocument*) pDoc)->CloseBookmarkDoc();
//STRIP001 	}
//STRIP001 
//STRIP001 	xBookmarkDocShRef.Clear();
//STRIP001 
//STRIP001 	pBookmarkDoc = NULL;
//STRIP001 
//STRIP001 //	  delete pOwnMedium;
//STRIP001 	pOwnMedium = NULL;
//STRIP001 }
//STRIP001 
/*************************************************************************
|*
|* 
|*
\************************************************************************/

//STRIP001 void SdPageObjsTLB::SelectHdl()
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 	
//STRIP001 	bLinkableSelected = TRUE;
//STRIP001 
//STRIP001 	while( pEntry && bLinkableSelected )
//STRIP001 	{
//STRIP001 	    if( NULL == pEntry->GetUserData() )
//STRIP001 	        bLinkableSelected = FALSE;
//STRIP001 
//STRIP001 		pEntry = NextSelected( pEntry );
//STRIP001 	}
//STRIP001 
//STRIP001 	SvTreeListBox::SelectHdl();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberlaedt RETURN mit der Funktionsweise von DoubleClick
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	if( rKEvt.GetKeyCode().GetCode() == KEY_RETURN )
//STRIP001 	{
//STRIP001 		// Auskommentierter Code aus svtools/source/contnr/svimpbox.cxx
//STRIP001 		SvLBoxEntry* pCursor = GetCurEntry();
//STRIP001 		if( pCursor->HasChilds() || pCursor->HasChildsOnDemand() )
//STRIP001 		{
//STRIP001 			if( IsExpanded( pCursor ) )
//STRIP001 				Collapse( pCursor );
//STRIP001 			else
//STRIP001 				Expand( pCursor );
//STRIP001 		}
//STRIP001 
//STRIP001 		DoubleClickHdl();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SvTreeListBox::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* StartDrag-Request
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	SdNavigatorWin* pNavWin = NULL;
//STRIP001 
//STRIP001 	if( pFrame->HasChildWindow( SID_NAVIGATOR ) )
//STRIP001 		pNavWin = (SdNavigatorWin*) ( pFrame->GetChildWindow( SID_NAVIGATOR )->GetContextWindow( SD_MOD() ) );
//STRIP001 
//STRIP001 	if( pNavWin && pNavWin == pParent && pNavWin->GetNavigatorDragType() != NAVIGATOR_DRAGTYPE_NONE )
//STRIP001 	{
//STRIP001 		//  Aus dem ExecuteDrag heraus kann der Navigator geloescht werden
//STRIP001 		//  (beim Umschalten auf einen anderen Dokument-Typ), das wuerde aber
//STRIP001 		//  den StarView MouseMove-Handler, der Command() aufruft, umbringen.
//STRIP001 		//  Deshalb Drag&Drop asynchron:
//STRIP001 		Application::PostUserEvent( STATIC_LINK( this, SdPageObjsTLB, ExecDragHdl ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Begin drag
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::DoDrag()
//STRIP001 {
//STRIP001 	pDropNavWin = ( pFrame->HasChildWindow( SID_NAVIGATOR ) ) ?
//STRIP001 				  (SdNavigatorWin*)( pFrame->GetChildWindow( SID_NAVIGATOR )->GetContextWindow( SD_MOD() ) ) : 
//STRIP001 				  NULL;
//STRIP001 
//STRIP001 	if( pDropNavWin )
//STRIP001 	{
//STRIP001 		SdDrawDocShell*		pDocShell = ( (SdDrawDocument*) pDoc )->GetDocSh();
//STRIP001 		String				aURL( pDocShell->GetMedium()->GetPhysicalName() );
//STRIP001 		NavigatorDragType	eDragType = pDropNavWin->GetNavigatorDragType();
//STRIP001 		
//STRIP001 		aURL = so3::StaticBaseUrl::SmartRelToAbs( aURL, FALSE, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 		aURL.Append( '#' );
//STRIP001 		aURL.Append( GetSelectEntry() );
//STRIP001 
//STRIP001 		INetBookmark	aBookmark( aURL, GetSelectEntry() );
//STRIP001 		sal_Int8		nDNDActions = DND_ACTION_COPY;
//STRIP001 
//STRIP001 		if( eDragType == NAVIGATOR_DRAGTYPE_LINK )
//STRIP001 			nDNDActions = DND_ACTION_LINK;	// #93240# Either COPY *or* LINK, never both!
//STRIP001 
//STRIP001 		SvTreeListBox::ReleaseMouse();
//STRIP001 
//STRIP001 		bIsInDrag = TRUE;
//STRIP001 
//STRIP001 		// object is destroyed by internal reference mechanism
//STRIP001 		( new SdPageObjsTLB::SdPageObjsTransferable( *this, aBookmark, *pDocShell, eDragType ) )->StartDrag( this, nDNDActions );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Drag finished
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPageObjsTLB::DragFinished( sal_uInt8 nDropAction )
//STRIP001 {
//STRIP001 	if( pFrame->HasChildWindow( SID_NAVIGATOR ) )
//STRIP001 	{
//STRIP001 		SdNavigatorWin* pNewNavWin = (SdNavigatorWin*) ( pFrame->GetChildWindow( SID_NAVIGATOR )->GetContextWindow( SD_MOD() ) );
//STRIP001 
//STRIP001 		if( pDropNavWin == pNewNavWin)
//STRIP001 		{
//STRIP001 			MouseEvent aMEvt( pDropNavWin->GetPointerPosPixel() );
//STRIP001 			SvTreeListBox::MouseButtonUp( aMEvt );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pDropNavWin = NULL;
//STRIP001 	bIsInDrag = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* AcceptDrop-Event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 sal_Int8 SdPageObjsTLB::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return( ( !bIsInDrag && IsDropFormatSupported( FORMAT_FILE ) ) ? rEvt.mnAction : DND_ACTION_NONE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ExecuteDrop-Event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 sal_Int8 SdPageObjsTLB::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( !bIsInDrag )
//STRIP001 	{
//STRIP001 		SdNavigatorWin* pNavWin = NULL;
//STRIP001 		USHORT			nId = SID_NAVIGATOR;
//STRIP001 
//STRIP001 		if( pFrame->HasChildWindow( nId ) )
//STRIP001 			pNavWin = (SdNavigatorWin*)( pFrame->GetChildWindow( nId )->GetContextWindow( SD_MOD() ) );
//STRIP001 
//STRIP001 		if( pNavWin && ( pNavWin == pParent ) )
//STRIP001 		{
//STRIP001 			TransferableDataHelper	aDataHelper( rEvt.maDropEvent.Transferable );
//STRIP001 			String					aFile;
//STRIP001 			
//STRIP001 			if( aDataHelper.GetString( FORMAT_FILE, aFile ) &&
//STRIP001 				( (SdNavigatorWin*) pParent)->InsertFile( aFile ) )
//STRIP001 			{
//STRIP001 				nRet = rEvt.mnAction;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Handler fuers Dragging
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_STATIC_LINK(SdPageObjsTLB, ExecDragHdl, void*, EMPTYARG)
//STRIP001 {
//STRIP001 	//	als Link, damit asynchron ohne ImpMouseMoveMsg auf dem Stack auch der
//STRIP001 	//	Navigator geloescht werden darf
//STRIP001 	pThis->DoDrag();
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 bool SdPageObjsTLB::PageBelongsToCurrentShow (const SdPage* pPage) const
//STRIP001 {
//STRIP001     // Return <TRUE/> as default when there is no custom show or when none
//STRIP001     // is used.  The page does then belong to the standard show.
//STRIP001     bool bBelongsToShow = true;
//STRIP001 
//STRIP001     if (pDoc->IsCustomShow())
//STRIP001     {
//STRIP001         // Get the current custom show.
//STRIP001         SdCustomShow* pCustomShow = NULL;
//STRIP001         List* pShowList = const_cast<SdDrawDocument*>(pDoc)->GetCustomShowList();
//STRIP001         if (pShowList != NULL)
//STRIP001         {
//STRIP001             ULONG nCurrentShowIndex = pShowList->GetCurPos();
//STRIP001             void* pObject = pShowList->GetObject(nCurrentShowIndex);
//STRIP001             pCustomShow = static_cast<SdCustomShow*>(pObject);
//STRIP001         }
//STRIP001     
//STRIP001         // Check whether the given page is part of that custom show.
//STRIP001         if (pCustomShow != NULL)
//STRIP001         {
//STRIP001             bBelongsToShow = false;
//STRIP001             ULONG nPageCount = pCustomShow->Count();
//STRIP001             for (USHORT i=0; i<nPageCount && !bBelongsToShow; i++)
//STRIP001                 if (pPage == static_cast<SdPage*>(pCustomShow->GetObject (i)))
//STRIP001                     bBelongsToShow = true;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bBelongsToShow;
//STRIP001 }
}
