/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wizag.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:14:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SV_SPINFLD_HXX //autogen
#include <vcl/spinfld.hxx>
#endif
#ifndef _SV_SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif

#ifndef _COM_SUN_STAR_UI_DIALOGS_EXTENDEDFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/ExtendedFilePickerElementIds.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERCONTROLACCESS_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerControlAccess.hpp>
#endif

//STRIP008 using namespace ::sfx2;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ui::dialogs;

#include "swtypes.hxx"
#include "wizag.hxx"
#include "wizpage.hxx"
#include "wizard.hrc"
#include "helpid.h"
namespace binfilter {
using namespace sfx2;
#define FRAME_SPACE (5*EINHEIT)  /* Abstand zwischen den Rahmen */
#define MAX_RECS	(255)

////////////////////////////////////////////////////////////////////////////////
//
// @@@@@ @@ @@ @@@@@ @@  @@ @@@@ @@  @@  @@@@  @@  @@ @@@@@  @@   @@@@@ @@@@@
// @@    @@ @@ @@    @@@ @@  @@  @@  @@ @@  @@ @@@ @@ @@  @@ @@   @@    @@  @@
// @@    @@ @@ @@    @@@@@@  @@  @@  @@ @@  @@ @@@@@@ @@  @@ @@   @@    @@  @@
// @@@@  @@@@@ @@@@  @@@@@@  @@  @@@@@@ @@@@@@ @@@@@@ @@  @@ @@   @@@@  @@@@@
// @@     @@@  @@    @@ @@@  @@  @@  @@ @@  @@ @@ @@@ @@  @@ @@   @@    @@  @@
// @@     @@@  @@    @@  @@  @@  @@  @@ @@  @@ @@  @@ @@  @@ @@   @@    @@  @@
// @@@@@   @   @@@@@ @@  @@  @@  @@  @@ @@  @@ @@  @@ @@@@@  @@@@ @@@@@ @@  @@
//
////////////////////////////////////////////////////////////////////////////////


IMPL_LINK( AgenDialog, GrfBtnHdl, PushButton *, pBtn )
{
    FileDialogHelper* pFileDlg = new FileDialogHelper( SFXWB_GRAPHIC );
    pFileDlg->SetTitle(SW_RESSTR( STR_Agn_WTGrphic ));
    Reference < XFilePicker > xFP = pFileDlg->GetFilePicker();
    Reference < XFilePickerControlAccess > xCtrlAcc(xFP, UNO_QUERY);

    if( ERRCODE_NONE == pFileDlg->Execute() )
	{
        Any aVal = xCtrlAcc->getValue( ExtendedFilePickerElementIds::CHECKBOX_LINK, 0);
        DBG_ASSERT(aVal.hasValue(), "Value CBX_INSERT_AS_LINK not found")
        BOOL bAsLink = aVal.hasValue() ? *(sal_Bool*) aVal.getValue() : sal_True;

        aPage1.aLogo.SetGraphic(
            pFileDlg->GetPath(), pFileDlg->GetCurrentFilter(), bAsLink);
		LogoToUI();
	}
    delete pFileDlg;
	ArrangeObjects();
	return 0;
}

IMPL_LINK_INLINE_START( AgenDialog, StyleClickHdl, RadioButton *, pBtn )
{
	BYTE nStyle=0;
	if (p1_RBtn_Stil1->IsChecked()) nStyle=0;
	if (p1_RBtn_Stil2->IsChecked()) nStyle=1;
	if (p1_RBtn_Stil3->IsChecked()) nStyle=2;
	return 0;
}
IMPL_LINK_INLINE_END( AgenDialog, StyleClickHdl, RadioButton *, pBtn )

IMPL_LINK_INLINE_START( AgenDialog, CheckHdl, CheckBox *, pBtn )
{
	CheckElements();
	ArrangeObjects();
	FillDocInfoList();
	return 0;
}
IMPL_LINK_INLINE_END( AgenDialog, CheckHdl, CheckBox *, pBtn )

IMPL_LINK_INLINE_START( AgenDialog, TitlModHdl, Edit *, pEdt )
{
	aPage1.aTitl.SetStr(pEdt->GetText(),&aPrevWin);
	CheckTitel();
	ArrangeObjects();
	FillDocInfoList();
	return 0;
}
IMPL_LINK_INLINE_END( AgenDialog, TitlModHdl, Edit *, pEdt )

IMPL_LINK_INLINE_START( AgenDialog, LogoClickHdl, CheckBox *, pBtn )
{
	aPage1.aLogo.Show(&aPrevWin,pBtn->IsChecked());
	LogoToUI();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( AgenDialog, LogoClickHdl, CheckBox *, pBtn )

////////////////////////////////////////////////////////////////////////////////
// AgenDialog
////////////////////////////////////////////////////////////////////////////////

AgenDialog::AgenDialog(Window* pParent):
	WizardAgenDialog(pParent),
	aList(*this)
{
	Init();
	aPrevWin.SetPage( &aPage1 );
	pDoku->SetPtr( pOkayBtn );

	GetFromIni();  // Defaults vom Inifile holen

	SetEventHandler();

	pDoku->ToUI();
	aList.ToUI();
	ToUI();
	FillDocInfoList();

	CheckElements();
	ArrangeObjects();

	ShowHideWin( *p4_Text_TipNr3, FALSE );
	ShowHideWin( *p4_Text_TipNr4, FALSE );
	Inc();
}

////////////////////////////////////////////////////////////////////////////////
//
//  @@@@  @@@@@ @@@@@@   @@@@@ @@@@   @@@@  @@   @@
// @@  @@ @@      @@     @@    @@ @@ @@  @@ @@@ @@@
// @@     @@      @@     @@    @@ @@ @@  @@ @@@@@@@
// @@ @@@ @@@@    @@     @@@@  @@@@  @@  @@ @@ @ @@
// @@  @@ @@      @@     @@    @@ @@ @@  @@ @@   @@
// @@  @@ @@      @@     @@    @@ @@ @@  @@ @@   @@   @@ @@ @@
//  @@@@@ @@@@@   @@     @@    @@ @@  @@@@  @@   @@   @@ @@ @@
//
////////////////////////////////////////////////////////////////////////////////

void AgenDialog::GetFromIni()
{
    // #97167# at least the RadioButtons need to be set
    sal_Int32 nStyle = aConfig.GetStyle();
	switch(nStyle)
	{
		case 0: p1_RBtn_Stil1->Check(TRUE);break;
		case 1: p1_RBtn_Stil2->Check(TRUE);break;
		default: p1_RBtn_Stil3->Check(TRUE);
	}
	StyleClickHdl(NULL);
    p7_RBtn_PrtJaa->Check(aConfig.IsUseMinutes());
	p7_RBtn_PrnNee->Check(!p7_RBtn_PrtJaa->IsChecked());

    if(!aConfig.HasValuesRead())
		return;

	aPage1.aTitl.SetStr(aConfig.GetTitle());
	aPage1.aLogo.Show(NULL, aConfig.IsLogoVisible());
	if(aConfig.GetLogoGrapicName().getLength())
        aPage1.aLogo.SetGraphic(aConfig.GetLogoGrapicName(),
                    aConfig.GetLogoGraphicFilter(),
                    aConfig.IsLogoGraphicAsLink());
	Date aSetDate;
	if(aConfig.GetDate())
		aSetDate.SetDate(aConfig.GetDate());
	p2_DFld_MetDat->SetDate(aSetDate);
	Time aSetTime;
	if(aConfig.GetTime())
		aSetTime.SetTime(aConfig.GetTime());
	p2_TFld_MetTim->SetTime(aSetTime);
	p2_Edit_MetOrt->SetText(aConfig.GetLocation());

	p2_CBox_Anlass->Check(aConfig.IsOccasion());
	p2_CBox_Mitbrn->Check(aConfig.IsBringAlong());
	p2_CBox_Vorber->Check(aConfig.IsPrepare());
	p2_CBox_Anmerk->Check(aConfig.IsNotes());
	p3_CBox_Einber->Check(aConfig.IsConvened());
	p3_CBox_Leitng->Check(aConfig.IsPresiding());
	p3_CBox_Protok->Check(aConfig.IsMinutes());
	p3_CBox_Teilnm->Check(aConfig.IsParticipants());
	p3_CBox_Gaeste->Check(aConfig.IsGuests());
	p3_CBox_Fachlt->Check(aConfig.IsExperts());
	p3_CBox_Nachbe->Check(aConfig.IsPostprocessing());

	FillDocInfoList();
	aConfig.ReadDocInfo(*pDoku);
}

void AgenDialog::WriteToIni()
{
	sal_Int32 nStyle = p1_RBtn_Stil2->IsChecked() ? 1
						: p1_RBtn_Stil3->IsChecked() ? 2 : 0;

	aConfig.SetStyle(nStyle);
	String aStr1,aStr2;
    sal_Bool bAsLink;
    aPage1.aLogo.GetGraphic(aStr1,aStr2, bAsLink );
	aConfig.SetLogoGrapicName(aStr1);
	aConfig.SetLogoGraphicFilter(aStr2);
    aConfig.SetLogoGraphicAsLink(bAsLink);

	aConfig.SetOccasion(p2_CBox_Anlass->IsChecked());
	aConfig.SetNumber(aConfig.GetAgendaArray().GetAnz());
	aConfig.SetNotes(p2_CBox_Anmerk->IsChecked());
	aConfig.SetDate(p2_DFld_MetDat->GetDate().GetDate());
	aConfig.SetConvened(p3_CBox_Einber->IsChecked());
	aConfig.SetExperts(p3_CBox_Fachlt->IsChecked());
	aConfig.SetGuests(p3_CBox_Gaeste->IsChecked());
	aConfig.SetPresiding(p3_CBox_Leitng->IsChecked());
	aConfig.SetBringAlong(p2_CBox_Mitbrn->IsChecked());
	aConfig.SetPostprocessing(p3_CBox_Nachbe->IsChecked());
	aConfig.SetLocation(p2_Edit_MetOrt->GetText());
	aConfig.SetMinutes(p3_CBox_Protok->IsChecked());
	aConfig.SetUseMinutes(p7_RBtn_PrtJaa->IsChecked());
	aConfig.SetParticipants(p3_CBox_Teilnm->IsChecked());
	aConfig.SetTitle(aPage1.aTitl.GetStr());
	aConfig.SetLogoVisible(aPage1.aLogo.IsVisible());
	aConfig.SetTime(p2_TFld_MetTim->GetTime().GetTime());
	aConfig.SetPrepare(p2_CBox_Vorber->IsChecked());
	aConfig.WriteDocInfo(*pDoku);

	aConfig.Commit();
}

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

void AgenDialog::CheckTitel()
{
	if (aPage1.aTitl.GetStr().Len()!=0) {
		aPage1.aTitl.Show(&aPrevWin);
	} else {
		aPage1.aTitl.Hide(&aPrevWin);
	}
}

void AgenDialog::CheckElements()
{
	USHORT nAnz=0;

	if (p2_CBox_Anlass->IsChecked()) nAnz++;
	if (p2_CBox_Mitbrn->IsChecked()) nAnz++;
	if (p2_CBox_Vorber->IsChecked()) nAnz++;
	if (p3_CBox_Einber->IsChecked()) nAnz++;
	if (p3_CBox_Leitng->IsChecked()) nAnz++;
	if (p3_CBox_Protok->IsChecked()) nAnz++;
	if (p3_CBox_Teilnm->IsChecked()) nAnz++;
	if (p3_CBox_Nachbe->IsChecked()) nAnz++;
	if (nAnz!=0) {
		aPage1.aElem.Show(&aPrevWin);
		aPage1.aElem.SetLnDazu(USHORT(nAnz-1),&aPrevWin); // Eine Zeile ist immer mind. da
	} else {
		aPage1.aElem.Hide(&aPrevWin);
	}
	// unten:
	/* p2_CBox_Anmerk
	   p3_CBox_Gaeste
	   p3_CBox_Fachlt
	*/
}

void AgenDialog::ArrangeObjects()
{
	USHORT yPos=10*EINHEIT; // Defaultrand oben = 10mm
	USHORT nHgt=0;
	USHORT nTitlPos=USHORT(aPage1.RandL);
	if (aPage1.aLogo.IsVisible()) {
		nTitlPos+=aPage1.aLogo.GetWdt()+FRAME_SPACE;
		nHgt=aPage1.aLogo.GetHgt();
	}
	USHORT nTitlWdt=USHORT(aPage1.SizeX-nTitlPos-aPage1.RandR);
	aPage1.aTitl.SetHor(nTitlPos,&aPrevWin);
	aPage1.aTitl.SetWdt(nTitlWdt,&aPrevWin);
	aPage1.aDatm.SetHor(nTitlPos,&aPrevWin);
	aPage1.aDatm.SetWdt(nTitlWdt,&aPrevWin);
	USHORT yPos1=yPos;
	USHORT nHgt1=0;
	if (aPage1.aTitl.IsVisible()) {
		aPage1.aTitl.SetVer(yPos1,&aPrevWin);
		nHgt1=aPage1.aTitl.GetHgt();
		yPos1+=nHgt1;
	}
	if (aPage1.aDatm.IsVisible()) {
		if (nHgt1>0) { yPos1+=FRAME_SPACE; nHgt1+=FRAME_SPACE; }
		aPage1.aDatm.SetVer(yPos1,&aPrevWin);
		nHgt1+=aPage1.aDatm.GetHgt();
	}
	if (nHgt1>nHgt) nHgt=nHgt1;
	if (nHgt>0) nHgt+=FRAME_SPACE;
	yPos+=nHgt;
	if (aPage1.aElem.IsVisible()) {
		aPage1.aElem.SetVer(yPos,&aPrevWin);
		yPos+=aPage1.aElem.GetHgt()+FRAME_SPACE;
	}
	aPage1.SetRandO(yPos,&aPrevWin);
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@     @@@@@ @@  @@ @@@@@ @@    @@    @@  @@ @@  @@  @@@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@ @@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@@@@ @@
// @@  @@ @@ @@@ @@@@  @@  @@ @@@@  @@    @@    @@  @@ @@@@@@ @@ @@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@ @@@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@  @@ @@  @@
//  @@@@  @@     @@     @@@@  @@@@@ @@@@@ @@@@@  @@@@  @@  @@  @@@@@
//
////////////////////////////////////////////////////////////////////////////////

void AgenDialog::ToUI()
{
	String aStr(aPage1.aTitl.GetStr());  // Titel
	p1_Edit_TitTxt->SetText(aStr);
	LogoToUI();
}

void AgenDialog::LogoToUI()
{
	String aStr;                         // LogoFilename
	String aFlt;
    sal_Bool bAsLink;

    aPage1.aLogo.GetGraphic(aStr,aFlt, bAsLink);
	FNam2FixedText(aStr,*p1_Text_TitGrf);
	p1_CBox_TitGrf->Check(aPage1.aLogo.IsVisible());

	const BOOL bEnable = aPage1.aLogo.IsVisible();
	p1_PBtn_TitGrf->Enable(bEnable);
	p1_Text_TitGrf->Enable(bEnable);
}

////////////////////////////////////////////////////////////////////////////////
//
//  DocInfo ...
//
////////////////////////////////////////////////////////////////////////////////

void AgenDialog::FillDocInfoList()
{
	pDoku->MerkDocInfListSel();
	pDoku->SetDBFieldAnz(0);
	USHORT i,j;
	String aStr;
	USHORT nAnz=0;
	for (i=0; i<15; i++)
		if (GetDocInfStrOk(i)) nAnz++;
	pDoku->SetTxFieldAnz(nAnz);
	j=0;
	for (i=0; i<15; i++) {
		if (GetDocInfStrOk(i))  {
			aStr=GetDocInfStr(i);
			pDoku->SetTxFieldNam(j,aStr);
			j++;
		}
	}
	pDoku->RestDocInfListSel();
}

BOOL AgenDialog::GetDocInfOn(USHORT nNum)
{
	BOOL bOn=FALSE;
	switch (nNum) {
		case  0: bOn=aPage1.aTitl.IsVisible();    break; // Titel
		case  1: bOn=TRUE;                        break; // Datum
		case  2: bOn=TRUE;                        break; // Uhrzeit
		case  3: bOn=TRUE;                        break; // Ort
		case  4: bOn=p2_CBox_Anlass->IsChecked(); break;
		case  5: bOn=p2_CBox_Mitbrn->IsChecked(); break;
		case  6: bOn=p2_CBox_Vorber->IsChecked(); break;
		case  7: bOn=p2_CBox_Anmerk->IsChecked(); break;
		case  8: bOn=p3_CBox_Einber->IsChecked(); break;
		case  9: bOn=p3_CBox_Leitng->IsChecked(); break;
		case 10: bOn=p3_CBox_Protok->IsChecked(); break;
		case 11: bOn=p3_CBox_Teilnm->IsChecked(); break;
		case 12: bOn=p3_CBox_Gaeste->IsChecked(); break;
		case 13: bOn=p3_CBox_Fachlt->IsChecked(); break;
		case 14: bOn=p3_CBox_Nachbe->IsChecked(); break;
	}
	return bOn;
}

String AgenDialog::GetDocInfStr(USHORT nNum)
{
	Window* pWin = 0;
	USHORT nRId = 0;
	String aStr;

	switch( nNum )
	{
	case  0: 	aStr = aPage1.aTitl.GetStr();     	// Titel
				nRId = STR_Agn_DocInTit;
				break;

	case  1: 	pWin = p2_Text_MetDat; 				// Datum
				nRId = STR_Agn_DocInDtm;
				break;

	case  2: 	pWin = p2_Text_MetTim; 				// Uhrzeit
				nRId = STR_Agn_DocInUzt;
				break;

	case  3: 	nRId = STR_Agn_DocInOrt; 			// Ort
				/*p2_Text_MetOrt->GetText();*/
				break;

	case  4: pWin = p2_CBox_Anlass; break;
	case  5: pWin = p2_CBox_Mitbrn; break;
	case  6: pWin = p2_CBox_Vorber; break;
	case  7: pWin = p2_CBox_Anmerk; break;
	case  8: pWin = p3_CBox_Einber; break;
	case  9: pWin = p3_CBox_Leitng; break;
	case 10: pWin = p3_CBox_Protok; break;
	case 11: pWin = p3_CBox_Teilnm; break;
	case 12: pWin = p3_CBox_Gaeste; break;
	case 13: pWin = p3_CBox_Fachlt; break;
	case 14: pWin = p3_CBox_Nachbe; break;
	}

	if( pWin )
		aStr = pWin->GetText();

	if( (!aStr.Len() || !aStr.EraseTrailingChars().Len()) && nRId )
		aStr = SW_RESSTR( nRId );

	return aStr;
}

BOOL AgenDialog::GetDocInfStrOk(USHORT nNum)
{
	return GetDocInfOn(nNum);
}


////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

void AgenDialog::SetEventHandler()
{
	{
	p1_Edit_TitTxt->SetModifyHdl(LINK(this,AgenDialog,TitlModHdl));
	p1_PBtn_TitGrf->SetClickHdl(LINK(this,AgenDialog,GrfBtnHdl));
	p1_CBox_TitGrf->SetClickHdl(LINK(this,AgenDialog,LogoClickHdl));
	}
	Link aLk = LINK(this,AgenDialog,StyleClickHdl);
	p1_RBtn_Stil1 ->SetClickHdl ( aLk );
	p1_RBtn_Stil2 ->SetClickHdl ( aLk );
	p1_RBtn_Stil3 ->SetClickHdl ( aLk );

	aLk = LINK(this,AgenDialog,CheckHdl);
	p2_CBox_Anlass->SetClickHdl( aLk );
	p2_CBox_Mitbrn->SetClickHdl( aLk );
	p2_CBox_Vorber->SetClickHdl( aLk );
	p3_CBox_Einber->SetClickHdl( aLk );
	p3_CBox_Leitng->SetClickHdl( aLk );
	p3_CBox_Protok->SetClickHdl( aLk );
	p3_CBox_Teilnm->SetClickHdl( aLk );
	p3_CBox_Nachbe->SetClickHdl( aLk );
	p2_CBox_Anmerk->SetClickHdl( aLk );
	p3_CBox_Gaeste->SetClickHdl( aLk );
	p3_CBox_Fachlt->SetClickHdl( aLk );
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@ @@@@@  @@@@@@ @@  @@ @@@@@ @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@@@@@ @@ @@@@@    @@   @@  @@ @@@@  @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//   @@   @@ @@  @@   @@    @@@@  @@@@@ @@@@ @@@@
//
////////////////////////////////////////////////////////////////////////////////

BOOL AgenDialog::Possible(USHORT StepNum)
{
	return(TRUE);
}

void AgenDialog::Enter(USHORT StepNum)
{
	if (StepNum==3 || // Tagesordnungsliste ohne Preview
		StepNum==5) aPrevWin.Hide(); // Fuer die Fahne
}

void AgenDialog::Leave(USHORT StepNum)
{
	if (StepNum==3 || // Tagesordnungsliste ohne Preview
		StepNum==5) aPrevWin.Show(); // Fuer die Fahne
}

void AgenDialog::Fill(USHORT StepNum, MultiOne& WinArr)
{
	switch (StepNum)
	{
		case 0:
		{
			WinArr.AddWin(p1_Text_Stil  );
			WinArr.AddWin(p1_RBtn_Stil1, TRUE );
			WinArr.AddWin(p1_RBtn_Stil2, TRUE );
			WinArr.AddWin(p1_RBtn_Stil3, TRUE );
			WinArr.AddWin(p1_Text_Titel );
			WinArr.AddWin(p1_Edit_TitTxt, TRUE);
			WinArr.AddWin(p1_CBox_TitGrf, TRUE);
			WinArr.AddWin(p1_PBtn_TitGrf, TRUE);
			WinArr.AddWin(p1_Text_TitGrf);
			WinArr.SetHelpId( HID_AGENDA_PAGE1 );
		}
		break;
		case 1:
		{
			WinArr.AddWin(p2_Text_MetDim);
			WinArr.AddWin(p2_Text_MetDat);
			WinArr.AddWin(p2_DFld_MetDat, TRUE);
			WinArr.AddWin(p2_Text_MetTim);
			WinArr.AddWin(p2_TFld_MetTim, TRUE);
			WinArr.AddWin(p2_Text_MetOrt);
			WinArr.AddWin(p2_Edit_MetOrt, TRUE);
			WinArr.AddWin(p2_Text_MetOpt);
			WinArr.AddWin(p2_CBox_Anlass, TRUE);
			WinArr.AddWin(p2_CBox_Mitbrn, TRUE);
			WinArr.AddWin(p2_CBox_Vorber, TRUE);
			WinArr.AddWin(p2_CBox_Anmerk, TRUE);
			WinArr.SetHelpId( HID_AGENDA_PAGE2 );
		}
		break;
		case 2:
		{
			WinArr.AddWin(p3_Text_AllNam);
			WinArr.AddWin(p3_CBox_Einber, TRUE);
			WinArr.AddWin(p3_CBox_Leitng, TRUE);
			WinArr.AddWin(p3_CBox_Protok, TRUE);
			WinArr.AddWin(p3_CBox_Teilnm, TRUE);
			WinArr.AddWin(p3_CBox_Gaeste, TRUE);
			WinArr.AddWin(p3_CBox_Fachlt, TRUE);
			WinArr.AddWin(p3_CBox_Nachbe, TRUE);
			WinArr.SetHelpId( HID_AGENDA_PAGE3 );
		}
		break;
		case 3:
		{
			WinArr.AddWin(p4_Text_PktNum);
			WinArr.AddWin(p4_Text_Verant);
			WinArr.AddWin(p4_Text_Minutn);
			WinArr.AddWin(p4_Text_PktNm1);
			WinArr.AddWin(p4_Edit_PktNm1, TRUE);
			WinArr.AddWin(p4_Edit_VerNm1, TRUE);
			WinArr.AddWin(p4_NFld_TimNm1, TRUE);
			WinArr.AddWin(p4_Text_PktNm2);
			WinArr.AddWin(p4_Edit_PktNm2, TRUE);
			WinArr.AddWin(p4_Edit_VerNm2, TRUE);
			WinArr.AddWin(p4_NFld_TimNm2, TRUE);
			WinArr.AddWin(p4_Text_PktNm3);
			WinArr.AddWin(p4_Edit_PktNm3, TRUE);
			WinArr.AddWin(p4_Edit_VerNm3, TRUE);
			WinArr.AddWin(p4_NFld_TimNm3, TRUE);
			WinArr.AddWin(p4_Text_PktNm4);
			WinArr.AddWin(p4_Edit_PktNm4, TRUE);
			WinArr.AddWin(p4_Edit_VerNm4, TRUE);
			WinArr.AddWin(p4_NFld_TimNm4, TRUE);
			WinArr.AddWin(p4_Text_PktNm5);
			WinArr.AddWin(p4_Edit_PktNm5, TRUE);
			WinArr.AddWin(p4_Edit_VerNm5, TRUE);
			WinArr.AddWin(p4_NFld_TimNm5, TRUE);
			WinArr.AddWin(p4_Text_PktNm6);
			WinArr.AddWin(p4_Edit_PktNm6, TRUE);
			WinArr.AddWin(p4_Edit_VerNm6, TRUE);
			WinArr.AddWin(p4_NFld_TimNm6, TRUE);
			WinArr.AddWin(p4_Scrl_UpDown);
			WinArr.AddWin(p4_Text_TipNr4);
			WinArr.AddWin(p4_Text_TipNr3);
			WinArr.AddWin(p4_Text_TipNr2);
			WinArr.AddWin(p4_Text_TipNr1);
			WinArr.SetHelpId( HID_AGENDA_PAGE4 );
		}
		break;
		case 4:
		{
			pDoku->Fill(WinArr);
			WinArr.SetHelpId( HID_AGENDA_PAGE5 );
		}
		break;
		case 5:
		{
			WinArr.AddWin(p7_BMap_Fahne );
			WinArr.AddWin(p7_Text_Final );
			WinArr.AddWin(p7_Text_Protok);
			WinArr.AddWin(p7_RBtn_PrtJaa, TRUE);
			WinArr.AddWin(p7_RBtn_PrnNee, TRUE);
			WinArr.SetHelpId( HID_AGENDA_PAGE6 );
		}
		break;
		case 0xFFFF:
		{
			FillDefElems(WinArr); // Defaultelemente (Buttons, PrevWin)
		}
		break;
	}
}

////////////////////////////////////////////////////////////////////////////////
//
//  XX X    XX   XXX  XXX    @@@@   @@@@  @@@@@ @@  @@ @@   @@  @@@@ @@@@@@
// X   X   X  X X    X      @@  @@ @@  @@ @@    @@@ @@ @@   @@ @@  @@  @@
// X   X   X  X X    X      @@  @@ @@     @@    @@@@@@ @@   @@ @@      @@
// X   X   XXXX  XX   XX    @@@@@@ @@ @@@ @@@@  @@@@@@ @@   @@  @@@@   @@
// X   X   X  X    X    X   @@  @@ @@  @@ @@    @@ @@@ @@   @@     @@  @@
// X   X   X  X    X    X   @@  @@ @@  @@ @@    @@  @@ @@   @@ @@  @@  @@
//  XX XXX X  X XXX  XXX    @@  @@  @@@@@ @@@@@ @@  @@ @@@@ @@  @@@@   @@
//
////////////////////////////////////////////////////////////////////////////////

AgenList::AgenList(AgenDialog& rDlg)
{
	pDlg=&rDlg;
	nArrOfs=0;
	InitUI();
	SetEventHandler();
}

void AgenList::InitUIArr()
{
	aRec[0].pPkt=pDlg->p4_Text_PktNm1;
	aRec[0].pThm=pDlg->p4_Edit_PktNm1;
	aRec[0].pNam=pDlg->p4_Edit_VerNm1;
	aRec[0].pTim=pDlg->p4_NFld_TimNm1;
	aRec[1].pPkt=pDlg->p4_Text_PktNm2;
	aRec[1].pThm=pDlg->p4_Edit_PktNm2;
	aRec[1].pNam=pDlg->p4_Edit_VerNm2;
	aRec[1].pTim=pDlg->p4_NFld_TimNm2;
	aRec[2].pPkt=pDlg->p4_Text_PktNm3;
	aRec[2].pThm=pDlg->p4_Edit_PktNm3;
	aRec[2].pNam=pDlg->p4_Edit_VerNm3;
	aRec[2].pTim=pDlg->p4_NFld_TimNm3;
	aRec[3].pPkt=pDlg->p4_Text_PktNm4;
	aRec[3].pThm=pDlg->p4_Edit_PktNm4;
	aRec[3].pNam=pDlg->p4_Edit_VerNm4;
	aRec[3].pTim=pDlg->p4_NFld_TimNm4;
	aRec[4].pPkt=pDlg->p4_Text_PktNm5;
	aRec[4].pThm=pDlg->p4_Edit_PktNm5;
	aRec[4].pNam=pDlg->p4_Edit_VerNm5;
	aRec[4].pTim=pDlg->p4_NFld_TimNm5;
	aRec[5].pPkt=pDlg->p4_Text_PktNm6;
	aRec[5].pThm=pDlg->p4_Edit_PktNm6;
	aRec[5].pNam=pDlg->p4_Edit_VerNm6;
	aRec[5].pTim=pDlg->p4_NFld_TimNm6;
}

void AgenList::InitUI()
{
	InitUIArr();
	pScrl =pDlg->p4_Scrl_UpDown;
	SetScrollBarSizes();
	ScrollUpdate();
}

void AgenList::SetScrollBarSizes()
{
	short nSiz=pDlg->aConfig.GetAgendaArray().GetAnz()+DIALOGLINES-1;  // Eine Page mehr fuer neue Zeile
	//nSiz-=DIALOGLINES;
	if (nSiz<0)
		nSiz=0;
	else if( nSiz > MAX_RECS )
		nSiz = MAX_RECS;

	pScrl->SetRange(Range(0,nSiz));
	pScrl->SetLineSize(1);
	pScrl->SetPageSize(DIALOGLINES);
	pScrl->SetVisibleSize(DIALOGLINES);
}

void AgenList::ToUI()
{
	SetScrollBarSizes();
	ScrollUpdate();
}

void AgenList::ScrollUpdate()
{
	AgendaArray& rArr = pDlg->aConfig.GetAgendaArray();
	USHORT nAnz= rArr.GetAnz();
	USHORT i,j;
	for (i=0; i<DIALOGLINES; i++) {
		j=i+nArrOfs;
		String aTmp(String::CreateFromInt32(j+1));
		aTmp+='.';
		aRec[i].pPkt->SetText(aTmp);
		AgendaRec aAgnRec;
		if (j<nAnz) {
			rArr.GetRec(j,aAgnRec);
			aRec[i].pThm->SetText(aAgnRec.aThem);
			aRec[i].pNam->SetText(aAgnRec.aName);
			aRec[i].pTim->SetValue(aAgnRec.nZeit);
		} else {
			aRec[i].pThm->SetText(aEmptyStr);
			aRec[i].pNam->SetText(aEmptyStr);
			aRec[i].pTim->SetValue(0);
			aRec[i].pTim->SetText(aEmptyStr);
		}
	}
}

USHORT AgenList::GetUILine(Edit* pEdt)
{
	USHORT i;
	USHORT nRet=0;
	for (i=0; i<DIALOGLINES; i++) {
		if (pEdt==aRec[i].pThm || pEdt==aRec[i].pNam || pEdt==aRec[i].pTim) nRet=i;
	}
	return nRet;
}

void AgenList::UIToArr(USHORT nUILin)
{
	USHORT nLstIdx=nArrOfs+nUILin;
	AgendaArray& rArr = pDlg->aConfig.GetAgendaArray();
	rArr.SetThm(nLstIdx,aRec[nUILin].pThm->GetText());
	rArr.SetNam(nLstIdx,aRec[nUILin].pNam->GetText());
	rArr.SetTim(nLstIdx,USHORT(aRec[nUILin].pTim->GetValue()));
}

void AgenList::MoveCursor(USHORT nArrLin)
{
	short nUILin=short(nArrLin)-nArrOfs;
	if (nUILin<0) {
		nArrOfs=nArrLin;
		pScrl->SetThumbPos(nArrOfs);
		nUILin=0;
	}
	if (nUILin>USHORT(DIALOGLINES-1)) {
		nArrOfs=nArrLin-(DIALOGLINES-1);
		pScrl->SetThumbPos(nArrOfs);
		nUILin=DIALOGLINES-1;
	}
	if (nUILin>=0 && nUILin<DIALOGLINES) {
		aRec[nUILin].pThm->GrabFocus();
	} else Sound::Beep();
}

void AgenList::MoveUp(USHORT nNum)
{
	if (nNum>0)
	{
		AgendaArray& rArr = pDlg->aConfig.GetAgendaArray();
		rArr.XChange(nNum,USHORT(nNum-1));
		MoveCursor(nNum-1);
		// Cursor in die voherige Zeile
		ScrollUpdate();
	}
}

void AgenList::MoveDn(USHORT nNum)
{
	AgendaArray& rArr = pDlg->aConfig.GetAgendaArray();
	rArr.XChange(nNum,nNum+1);
	MoveCursor(nNum+1);
	// Cursor in die naechste Zeile
	ScrollUpdate();
}
/* -----------------------------15.09.00 17:14--------------------------------

 ---------------------------------------------------------------------------*/
USHORT AgenList::GetAnz()
{
	return pDlg->aConfig.GetAgendaArray().GetAnz();
}
/* -----------------------------15.09.00 17:14--------------------------------

 ---------------------------------------------------------------------------*/
void AgenList::GetRec(USHORT nNum, AgendaRec& rRec)
{
	pDlg->aConfig.GetAgendaArray().GetRec(nNum,rRec);
}
AgendaArray& AgenList::GetArray()
{
	return pDlg->aConfig.GetAgendaArray();
}

////////////////////////////////////////////////////////////////////////////////
// Eventhandler
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( AgenList, ScrollHdl, ScrollBar *, pScrl )
{
	USHORT nOfs = (USHORT)pScrl->GetThumbPos();
	if (nOfs!=nArrOfs)
	{
		nArrOfs=nOfs;
		ScrollUpdate();
	}
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, ScrollHdl, ScrollBar *, pScrl )

IMPL_LINK_INLINE_START( AgenList, ModifyHdl, Edit *, pEdt )
{
	UIToArr(GetUILine(pEdt));
	AgendaArray& rArr = pDlg->aConfig.GetAgendaArray();
	rArr.Trim();
	SetScrollBarSizes();
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, ModifyHdl, Edit *, pEdt )

IMPL_LINK_INLINE_START( AgenList, SpinUpHdl, SpinField *, pFld )
{
	USHORT nNum=pDlg->aList.GetUILine(pFld);
	nNum+=nArrOfs;
//  USHORT nAnz=pDlg->aList.GetAnz();
	if (nNum>0) pDlg->aList.MoveUp(nNum);
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, SpinUpHdl, SpinField *, pFld )

IMPL_LINK_INLINE_START( AgenList, SpinDnHdl, SpinField *, pFld )
{
	USHORT nNum=pDlg->aList.GetUILine(pFld);
	nNum+=nArrOfs;
	USHORT nAnz=pDlg->aList.GetAnz();
	if( nNum <= nAnz && nNum + 1 < MAX_RECS)
		pDlg->aList.MoveDn(nNum);
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, SpinDnHdl, SpinField *, pFld )

IMPL_LINK_INLINE_START( AgenList, GetFocus3Hdl, Control *, pCtl )
{
	pDlg->ShowHideWin( *pDlg->p4_Text_TipNr3, TRUE );
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, GetFocus3Hdl, Control *, pCtl )

IMPL_LINK_INLINE_START( AgenList, LosFocus3Hdl, Control *, pCtl )
{
	pDlg->ShowHideWin( *pDlg->p4_Text_TipNr3, FALSE );
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, LosFocus3Hdl, Control *, pCtl )

IMPL_LINK_INLINE_START( AgenList, GetFocus4Hdl, Control *, pCtl )
{
	pDlg->ShowHideWin( *pDlg->p4_Text_TipNr4, TRUE );
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, GetFocus4Hdl, Control *, pCtl )

IMPL_LINK_INLINE_START( AgenList, LosFocus4Hdl, Control *, pCtl )
{
	pDlg->ShowHideWin( *pDlg->p4_Text_TipNr4, FALSE  );
	return 0;
}
IMPL_LINK_INLINE_END( AgenList, LosFocus4Hdl, Control *, pCtl )

////////////////////////////////////////////////////////////////////////////////

void AgenList::SetEventHandler()
{
	pScrl->SetScrollHdl(LINK(this,AgenList,ScrollHdl));
	USHORT i;
	Link aLk = LINK(this,AgenList,ModifyHdl);
	for (i=0; i<DIALOGLINES; i++)
	{
		aRec[i].pThm->SetModifyHdl( aLk );
		aRec[i].pNam->SetModifyHdl( aLk );
		aRec[i].pTim->SetModifyHdl( aLk );
		aRec[i].pThm->SetUpHdl(LINK(this,AgenList,SpinUpHdl));   ////
		aRec[i].pNam->SetUpHdl(LINK(this,AgenList,SpinUpHdl));     // Fuers Verschieben von
		aRec[i].pThm->SetDownHdl(LINK(this,AgenList,SpinDnHdl));   // Tagesordnungspunkten
		aRec[i].pNam->SetDownHdl(LINK(this,AgenList,SpinDnHdl)); ////
		aRec[i].pThm->SetGetFocusHdl(LINK(this,AgenList,GetFocus3Hdl));  ////
		aRec[i].pNam->SetGetFocusHdl(LINK(this,AgenList,GetFocus3Hdl));    // Ein-/Ausblenden
		aRec[i].pThm->SetLoseFocusHdl(LINK(this,AgenList,LosFocus3Hdl));   // des Hilfetextes
		aRec[i].pNam->SetLoseFocusHdl(LINK(this,AgenList,LosFocus3Hdl)); ////
		aRec[i].pTim->SetGetFocusHdl(LINK(this,AgenList,GetFocus4Hdl));  // ...
		aRec[i].pTim->SetLoseFocusHdl(LINK(this,AgenList,LosFocus4Hdl)); // ...
	}
}

////////////////////////////////////////////////////////////////////////////////
//
//  XX X    XX   XXX  XXX    @@@@   @@@@  @@  @@  @@@@  @@@@@  @@@@@
// X   X   X  X X    X      @@  @@ @@  @@ @@@ @@ @@  @@ @@  @@ @@  @@
// X   X   X  X X    X      @@  @@ @@     @@@@@@ @@  @@ @@  @@ @@  @@
// X   X   XXXX  XX   XX    @@@@@@ @@ @@@ @@@@@@ @@@@@@ @@@@@  @@@@@
// X   X   X  X    X    X   @@  @@ @@  @@ @@ @@@ @@  @@ @@  @@ @@  @@
// X   X   X  X    X    X   @@  @@ @@  @@ @@  @@ @@  @@ @@  @@ @@  @@
//  XX XXX X  X XXX  XXX    @@  @@  @@@@@ @@  @@ @@  @@ @@  @@ @@  @@
//
////////////////////////////////////////////////////////////////////////////////

AgendaArray::AgendaArray()
{
	nUsedSiz=0;
}

AgendaArray::~AgendaArray()
{
//  USHORT nAnz=USHORT(GetSize());
	USHORT i;
	for (i=0; i<nUsedSiz; i++) {
		AgendaRec* pRec=Get(i);
		delete pRec;
	}
}

void AgendaArray::Trim()
{
	USHORT nUsed=0;
	USHORT i;
	for (i=nUsedSiz; i>0 && nUsed==0;) {
		i--;
		AgendaRec* pRec=Get(i);
		if (pRec->nZeit!=0) nUsed=i+1;
		if (nUsed==0) {
			String aStr(pRec->aThem);
			aStr.EraseTrailingChars();
			if (aStr.Len()>0) nUsed=i+1;
		}
		if (nUsed==0) {
			String aStr(pRec->aName);
			aStr.EraseTrailingChars();
			if (aStr.Len()>0) nUsed=i+1;
		}
	}
	if (nUsed<nUsedSiz) {
		for (i=nUsedSiz; i>nUsed;) {
			i--;
			AgendaRec* pRec=Get(i);
			delete pRec;
		}
		nUsedSiz=nUsed;
	}
}

void AgendaArray::ForceSize(USHORT nSiz)
{
	if (nSiz>nUsedSiz) {
		if (nSiz>GetSize())
			SetSize(nSiz);
		USHORT i;
		for (i=nUsedSiz; i<nSiz; i++) {
			AgendaRec* pRec=new AgendaRec;
			pRec->nZeit=0;
			Put(i,pRec);
		}
		nUsedSiz=nSiz;
	}
}

void AgendaArray::GetRec(USHORT nNum, AgendaRec& rRec)
{
	if (nNum<nUsedSiz) {
		rRec=*Get(nNum);
	} // else ASSERT
}
void AgendaArray::SetThm(USHORT nNum, const String& rThm)
{
	ForceSize(nNum+1);
	AgendaRec* pRec=Get(nNum);
	pRec->aThem=rThm;
}

void AgendaArray::SetNam(USHORT nNum, const String& rNam)
{
	ForceSize(nNum+1);
	AgendaRec* pRec=Get(nNum);
	pRec->aName=rNam;
}

void AgendaArray::SetTim(USHORT nNum, sal_Int32 nTim)
{
	ForceSize(nNum+1);
	AgendaRec* pRec=Get(nNum);
	pRec->nZeit=nTim;
}

void AgendaArray::XChange(USHORT a, USHORT b)
{
	ForceSize(a+1);
	ForceSize(b+1);
	AgendaRec* pRecA=Get(a);
	AgendaRec* pRecB=Get(b);
	String aTmp;
	USHORT nTmp;
	aTmp=pRecA->aThem;
	pRecA->aThem=pRecB->aThem;
	pRecB->aThem=aTmp;
	aTmp=pRecA->aName;
	pRecA->aName=pRecB->aName;
	pRecB->aName=aTmp;
	nTmp=pRecA->nZeit;
	pRecA->nZeit=pRecB->nZeit;
	pRecB->nZeit=nTmp;
}

////////////////////////////////////////////////////////////////////////////////
//
//  XX X    XX   XXX  XXX   @@   @@ @@  @@ @@@@@ @@@@@  @@ @@@@@@
// X   X   X  X X    X      @@@ @@@ @@  @@ @@    @@  @@ @@   @@
// X   X   X  X X    X      @@@@@@@ @@  @@ @@    @@  @@ @@   @@
// X   X   XXXX  XX   XX    @@ @ @@  @@@@  @@@@  @@  @@ @@   @@
// X   X   X  X    X    X   @@   @@   @@   @@    @@  @@ @@   @@
// X   X   X  X    X    X   @@   @@   @@   @@    @@  @@ @@   @@
//  XX XXX X  X XXX  XXX    @@   @@   @@   @@@@@ @@@@@  @@   @@
//
////////////////////////////////////////////////////////////////////////////////




}
