/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: topfrm.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:43:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_TOPFRM_HXX
#define _SFX_TOPFRM_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _SV_DOCKWIN_HXX //autogen
#include <vcl/dockwin.hxx>
#endif
#include <vcl/wrkwin.hxx>

#include <bf_sfx2/frame.hxx>
#include <bf_sfx2/viewfrm.hxx>
namespace svtools { class AsynchronLink; }
namespace binfilter {

class SfxViewShell;
class SfxTopFrame;
class SfxTopFrame_Impl;
class SfxTopViewFrame_Impl;
//STRIP008 namespace svtools { class AsynchronLink; }

// class SfxTopFrame -----------------------------------------------------

class SfxTopFrame :	public SfxFrame
{
friend class SfxTopWindow_Impl;
friend class SfxTopFrameWindow_Impl;
friend class SfxTopFrame_Impl;

	SfxTopFrame_Impl*	pImp;
    Window*             pWindow;
                        SfxTopFrame( Window* pWindow=NULL, sal_Bool bHidden = sal_False );
    virtual             ~SfxTopFrame();
public:
                        TYPEINFO();

    static SfxTopFrame* Create( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > xFrame );
//STRIP001     static SfxTopFrame* Create( SfxObjectShell* pDoc=0, USHORT nViewId=0, BOOL bHidden=sal_False, const SfxItemSet* pSet=NULL );
//STRIP001     static SfxTopFrame* Create( SfxObjectShell* pDoc, Window* pWindow, USHORT nViewId=0, BOOL bHidden=sal_False, const SfxItemSet* pSet=NULL );

	virtual Window&		GetWindow() const;
	virtual BOOL		Close();
	virtual	BOOL		InsertDocument( SfxObjectShell *pDoc );
//STRIP001 	String				GetWindowData();

//STRIP001     void                SetPresentationMode( BOOL bSet );

#if _SOLAR__PRIVATE
    void                LockResize_Impl( BOOL bLock );
    void                SetMenuBar_Impl( MenuBar* pMenu );
//STRIP001     void                SetMenuBarOn_Impl( BOOL bOn );
//STRIP001     BOOL                IsMenuBarOn_Impl() const;
    MenuBar*            GetMenuBar_Impl() const;
	BOOL				InsertDocument_Impl( SfxObjectShell *pDoc, USHORT nViewId=0 );
    SystemWindow*       GetTopWindow_Impl() const;
	void				CheckMenuCloser_Impl( MenuBar* pMenubar );
#endif
};

// class SfxTopViewFrame -------------------------------------------------

class SfxTopViewFrame : public SfxViewFrame
{
friend class SfxTopWindow_Impl;
friend class SfxTopViewFrame_Impl;

	SfxTopViewFrame_Impl*	pImp;
    ::svtools::AsynchronLink* pCloser;

protected:

	virtual void            Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	virtual void            Activate( BOOL bUI );
	virtual void            Deactivate( BOOL bUI );
	virtual BOOL            Close();
	virtual                 ~SfxTopViewFrame();

public:
							TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXTOPFRM);

                            SfxTopViewFrame( SfxFrame* pFrame, SfxObjectShell *pDoc=NULL, USHORT nViewId=0 );

    virtual void            SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY );
	virtual BOOL			SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder );
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );
	virtual String			UpdateTitle();

#if _SOLAR__PRIVATE
	void					Exec_Impl(SfxRequest &);
	void                    GetState_Impl(SfxItemSet &);
	void					INetExecute_Impl(SfxRequest &);
	void					INetState_Impl(SfxItemSet &);
    SfxTopFrame*            GetTopFrame_Impl()
                            { return (SfxTopFrame*) GetFrame(); }
#endif
};

}//end of namespace binfilter
#endif // #ifndef _SFX_TOPFRM_HXX

