/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cpp_defs.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:36:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <ary/cpp/cpp_defs.hxx>



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include "rcids.hxx"


namespace ary
{
namespace cpp
{



CppDefinition::CppDefinition( Did                 i_nId,
                              const udmstri &     i_sName,
                              Lid                 i_nDeclaringFile )
    :   nId(i_nId),
        sName(i_sName),
        nLocation(i_nDeclaringFile),
        pInfo(0)
{
}

Rid
CppDefinition::inq_Id() const
{
    return nId;
}

const Documentation &
CppDefinition::inq_Info() const
{
    return pInfo ? *pInfo : ary::Documentation::Null_();
}

void
CppDefinition::do_Add_Documentation( DYN Documentation & let_drInfo )
{
    pInfo = &let_drInfo;
}

}   // end namespace cpp
}   // end namespace ary



