/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: g_stgifc.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:17:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <store/g_stgifc.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/cpp/cg_proj.hxx>
#include <ary/cpp/cg_file.hxx>
#include "sto_grps.hxx"
#include "ti_storg.hxx"


namespace ary
{
namespace store
{


//********************		CheshireCat		**************//

struct Groups_Ifc::CheshireCat
{
	typedef std::map< Gid, ary::AryGroup* >          GroupIndex;
	typedef std::map< Lid, ary::cpp::ProjectGroup* > MapLid2Project;
	typedef std::map< udmstri, ary::cpp::ProjectGroup* >
                                                     MapName2Project;
	typedef std::map< Lid, ary::cpp::FileGroup* >    MapLid2File;

    GroupIndex          aIndex;
    MapLid2Project      aProjectsByLid;
    MapName2Project     aProjectsByName;
    MapLid2File         aFilesByLid;

    ary::store::IndependentGroups *
                        pStorage;
	Dyn<ary::TopProject>
                     	pTopProject;                // KORR_FUTURE!
                                                    //   Has to be part of Storage!

						CheshireCat(
							IndependentGroups & io_rGroupStorage );
						~CheshireCat();
};


Groups_Ifc::
CheshireCat::CheshireCat( IndependentGroups & io_rGroupStorage )
	:	// aIndex,
        // aProjectsByLid,
        // aFilesByLid,
        pStorage( &io_rGroupStorage ),
        pTopProject(0)
{
}

Groups_Ifc::
CheshireCat::~CheshireCat()
{
}


//********************		Groups_Ifc		**************//

Groups_Ifc::Groups_Ifc( IndependentGroups & io_rGroupStorage )
	:	pi( new CheshireCat(io_rGroupStorage) )
{
}

void
Groups_Ifc::Init_TopProject( ary::TopProject & let_drProject )
{
    pi->pTopProject = &let_drProject;
    pi->aIndex[let_drProject.Id()] = &let_drProject;
}

Groups_Ifc::~Groups_Ifc()
{
}

void
Groups_Ifc::Add_ProjectGroup_Cpp( DYN ary::cpp::ProjectGroup & let_drProject )
{
    Gid nId = let_drProject.Id_Group();
    pi->pStorage->Projects_Cpp().Add( nId, let_drProject );
    pi->aIndex[nId] = &let_drProject;
    pi->aProjectsByLid[let_drProject.RootDir()] = &let_drProject;
    pi->aProjectsByName[let_drProject.Name()] = &let_drProject;
}

void
Groups_Ifc::Add_FileGroup_Cpp( DYN ary::cpp::FileGroup & let_drFile )
{
    Gid nId = let_drFile.Id_Group();
    pi->pStorage->Files_Cpp().Add( nId, let_drFile );
    pi->aIndex[nId] = &let_drFile;
    pi->aFilesByLid[let_drFile.AssociatedFile()] = &let_drFile;
}

const ary::TopProject &
Groups_Ifc::Top() const
{
    csv_assert( pi->pTopProject != 0 );
    return *pi->pTopProject;
}

const ary::AryGroup *
Groups_Ifc::Find_Group( Gid i_nId ) const
{
	return csv::value_from_map( pi->aIndex, i_nId );
}

const ary::cpp::ProjectGroup *
Groups_Ifc::Search_ProjectGroup_Cpp( const udmstri & i_sProjectName  ) const
{
    return csv::value_from_map( pi->aProjectsByName, i_sProjectName );
}

ary::TopProject &
Groups_Ifc::Top()
{
    csv_assert( pi->pTopProject != 0 );
    return *pi->pTopProject;
}

ary::cpp::ProjectGroup *
Groups_Ifc::Find_ProjectGroup_Cpp( Gid i_nProject )
{
    return pi->pStorage->Projects_Cpp().Find( i_nProject );
}

ary::cpp::ProjectGroup *
Groups_Ifc::Search_ProjectGroup_Cpp( Lid i_nRootDir )
{
	return csv::value_from_map( pi->aProjectsByLid, i_nRootDir );
}

ary::cpp::FileGroup *
Groups_Ifc::Search_FileGroup_Cpp( Lid i_nFile )
{
	return csv::value_from_map( pi->aFilesByLid, i_nFile );
}


} // namespace store
} // namespace ary


