#!/usr/bin/perl

use Cwd;
use File::Find;
use File::Basename;
use XML::LibXSLT;
use XML::LibXML;

$| = 1;

$cwd = getcwd;
$scriptdir = $0;
$default_hcpath = ($cwd =~ s,/helpcontent2/.*,/helpcontent2/, ? $cwd."source" : '');
$default_htmlpath = ($cwd =~ s,/helpcontent2/.*,/helpcontent2/, ? $cwd."helpers/htmlhelp/output" : '');
$default_xslf = ($cwd =~ s,/helpcontent2/.*,/helpcontent2/, ? $cwd."helpers/htmlhelp/xhp2html.xsl" : '');
$default_xslindf = ($cwd =~ s,/helpcontent2/.*,/helpcontent2/, ? $cwd."helpers/htmlhelp/xhp2index.xsl" : '');
$default_imgpath = ($cwd =~ s,/helpcontent2/.*,, ? $cwd."/default_images" : '');
$default_pn = "OpenOffice.org";
$default_pv = "2.0";
($scriptpath = $0) =~ s/help2html.pl//;
$cssfile = "ooohelp.css";

$params = "|".join("|",split(/(?=-)/,join(" ",@ARGV)))."|";

$hcpath = ($params =~ /\|-in\s+([^\|\s]+)/ ? $1 : $default_hcpath);
$htmlpath = ($params =~ /\|-out\s+([^\|\s]+)/ ? $1 : $default_htmlpath);
$xslf = ($params =~ /\|-xsl\s+([^\|\s]+)/ ? $1 : $default_xslf);
$xslindf = ($params =~ /\|-ind\s+([^\|\s]+)/ ? $1 : $default_xslindf);
$imgpath = ($params =~ /\|-img\s+([^\|\s]+)/ ? $1 : $default_imgpath);
$pn = ($params =~ /\|-pn\s+([^\|\s]+)/ ? $1 : $default_pn);
$pv = ($params =~ /\|-pv\s+([^\|\s]+)/ ? $1 : $default_pv);

#print join("\n",(split /\|/, $params));
#if ($params =~ /\|-out\s+([^\|\s]+)/) { print $1 };
#die;


$secname{'swriter'} = 'writer';
$secname{'scalc'} = 'calc';
$secname{'sdraw'} = 'draw';
$secname{'simpress'} = 'impress';
$secname{'sbasic'} = 'basic';
$secname{'smath'} = 'math';
$secname{'schart'} = 'chart';
$secname{'shared'} = 'shared';
$secname{'database'} = 'base';

$startpage{'Writer'} = "text/swriter/main0000.html";
$startpage{'Calc'} = "text/scalc/main0000.html";
$startpage{'Draw'} = "text/sdraw/main0000.html";
$startpage{'Impress'} = "text/simpress/main0000.html";
$startpage{'Basic'} = "text/sbasic/shared/main0601.html";
$startpage{'Math'} = "text/smath/main0000.html";
$startpage{'Base'} = "text/shared/explorer/database/main.html";


if ($hcpath !~ /^.*\/source\/*$/gi) {
	$hcpath .= "/source";
}

&mydie("\nCannot access XSL stylesheet:\n $xslf") if (not -e $xslf);
&mydie("\nCannot access input path:\n $hcpath") if (not -d $hcpath);
&mydie("\nCannot access output path:\n $htmlpath") if (not -d $htmlpath);
&mydie("\nCannot access image path:\n $imgpath") if (not -d $imgpath);

if ( open XSL, $xslf ) {
	undef $/;
	$xsl = <XSL>;
	close XSL;
}	else {
	die "\nCannot open XSL stylesheet ($!):\n $xslf";
}

if ( open XSLIND, $xslindf ) {
	undef $/;
	$xslind = <XSLIND>;
	close XSLIND;
}	else {
	die "\nCannot open XSL stylesheet ($!):\n $xslindf";
}

$ctfiles = 0;

print "Converting files...";
find(\&convfiles,"$hcpath/text");
print "done\n";

print "Copying images...";
&copyimages;
print "done\n";

print "Creating index...";
&createindex;
print "done\n";

print "Copying templates...";
&copytemplates;
print "done\n";

#-----------------------------#

sub convfiles {
	$indir = $File::Find::dir;
	$infile = $_;
  ($srcdir = $indir) =~ s/$hcpath//gis;
	$outdir = $htmlpath.$srcdir;
	($outfile = "$outdir/$_") =~ s/\.xhp$/\.html/;
	$section = 'nochange';
		
	if (/\.xhp/) {
		
		for $k(reverse(sort(keys(%secname)))) {

			if ($indir =~ /$k/gi) {
				$section = $secname{$k};
			}
		}
		
		$srcfile = "$srcdir/$_";
		$level = -2;
		while ($srcfile =~ /\//g) { $level++; }
		$goup = "../" x $level;
		$goupsrc = "../" x ($level+1);
		
		if (open XML, $_) {
			undef $/;
			$xml = <XML>;
			close XML;
		}	else {
			die "\nCannot open $_:$!\n";
		}
		
		# convert file
		$html = &xmltrans($xml,$xsl,$hcpath,$goup,$goupsrc);		
		
		#get index entries
		$ind = &xmltransindex($xml,$xslind);

		for $i(split("\n",$ind)) {
			#entry1;entry2::file
			$i =~ s/(%PRODUCTNAME|\$\[officename\])/$pn/gis;
			$i =~ s/(%PRODUCTVERSION|\$\[officeversion\])/$pv/gis;
			($entry,$file) = split /::/, $i;
			($entry1, $entry2) = split /;/, $entry;
			push @{$index{$section}}, {$entry1 => { $entry2 => $file }};
		}
		
		# replace xhp extensions by html extensions
		$html =~ s/\.xhp/\.html/gis;
		
		# replace productname and version
		$html =~ s/(%PRODUCTNAME|\$\[officename\])/$pn/gis;
		$html =~ s/(%PRODUCTVERSION|\$\[officeversion\])/$pv/gis;
		
	
		# get all images
		while ($html =~ /<img[^>]*src="([^"]+)"[^>]*>/g) {
			($img{$1}=$1) =~ s/^.*img\//$imgpath/;
		}
		&makedir($outfile);
		if (	open HTML, ">$outfile") {
			print HTML $html;
			close HTML;
			$ctfiles++;
			#printf("%5d %s/%s\n",$ctfiles,$files,$srcdir,$_);
			print "." if ($ctfiles % 10);
			
		} else {
			die "\nCannot write to $outfile: $!\n";
		}
	}
}

sub createindex {
	push @{$index{writer}},@{$index{shared}},@{$index{chart}};
	push @{$index{calc}},@{$index{shared}},@{$index{chart}};
	push @{$index{draw}},@{$index{impress}},@{$index{shared}},@{$index{chart}};
	push @{$index{math}},@{$index{shared}};
	push @{$index{basic}},@{$index{shared}};
	
	for $k(keys(%index)) {
		if ($k !~ /(shared|chart)/i) {
			$id = 0;
			print "\n$k\n";
			if (open (IND, ">$htmlpath/${k}_index.html")) {
				print IND <<"HEADER";
<html>
	<head>
		<title>OOo Help Menu Frame</title>
		<link href="ooohelp.css" type="text/css" rel="StyleSheet">
		<script src="ooohelp.js" type="text/javascript"></script>
	</head>
	<body class="menuframe">
	<a name="top"></a>
		<div class="contents">
			<div class="inner">
				<div id="top">
					<div class="indextitle">Index</div>
					<div class="indexsubtitle">$k</div>
				</div>
				<div class="jump">
					<a href="#top">Top</a>
HEADER
				for $l(@{['A'..'Z']}) {
						print IND "          <a href=\"#ind_$l\">$l</a>\n";
					}
				print IND <<"HEADER";
				</div>
				<div class="index">
HEADER
			
				undef %index2;
				
				for $i(@{$index{$k}}) {
					for $l1(keys(%{$i})) {
						for $l2(keys(%{${$i}{$l1}})) {
							#$l1 = level1
							#$l2 = level2
							push @{$index2{$l1}}, ${l2}."::".${${$i}{$l1}}{$l2};
							#print $l2,"::",${${$i}{$l1}}{$l2},"\n";
							#sleep 10;
						}
					}
				}
			
				$letter = "";
				
				@k = keys(%index2);
				for $i(sort({lc($a) cmp lc($b)} @k)) {
					$i =~ s/(%PRODUCTNAME|\$\[officename\])/$pn/gis;
					$i =~ s/(%PRODUCTVERSION|\$\[officeversion\])/$pv/gis;	
					$id++;
					
					($firstletter = uc($i)) =~ s/^\s*(.).*$/$1/gs;
					if (($firstletter ne $letter) && ($firstletter =~ /[A-Z]/)) {
						print IND "<a name=\"ind_$firstletter\"></a><div class=\"indexletter\">$firstletter</div>\n";
						$letter = $firstletter;
					}
					
					if ((scalar @{$index2{$i}} == 1) and (${$index2{$i}}[0] =~ /^\s*::/)) {
						($lev2,$file) = split /::/, ${$index2{$i}}[0];
						$file =~ s/\.xhp$/\.html/gis;
						print IND "<div class=\"entry\" id=\"id_$id\"><a href=\"text$file\" target=\"mainframe\" class=\"indexlink\" title=\"$i\">$i</a></div>\n";
					} else {
						print IND "<div class=\"entry withsub\">";
						print IND "<div class=\"subhidden\" id=\"id_$id\" onClick=\"toggle(this.id)\" title=\"$i\">$i</div>\n";
						print IND "<div class=\"hidden\" id=\"id_${id}_sub\">\n";
						for $l2(sort(@{$index2{$i}})) {
							($lev2,$file) = split /::/, $l2;
							$lev2 = ($lev2 eq "" ? $i : $lev2);
							$lev2 =~ s/^\s+//gis;
							$file =~ s/\.xhp$/\.html/gis;
							print IND "  <div class=\"subentry\" ><a href=\"text$file\" target=\"mainframe\" class=\"indexlink\">$lev2</a></div>\n";

						}
						print IND "</div></div>\n";
					}
				}
				print IND "</div>\n</div>\n</div>\n</body>\n</html>\n";
				close IND;
			} else {
				die "\nCannot write to $htmlpath.${k}_index.html: $!\n";
			}
		}
	}
}

sub xmltrans {    # makes the xslt tranformation
	my $xml = shift;
	my $xsl = shift;

	my $parser = XML::LibXML->new();
	my $xslt   = XML::LibXSLT->new();

	my $source    = $parser->parse_string($xml);
	my $style_doc = $parser->parse_string($xsl);

	my $stylesheet = $xslt->parse_stylesheet($style_doc);

	my $result = $stylesheet->transform($source,
		XML::LibXSLT::xpath_to_string(fsroot => $hcpath),
		XML::LibXSLT::xpath_to_string(fsrootrel => $goup),
		XML::LibXSLT::xpath_to_string(fsrootsource => "$hcpath/"),
		XML::LibXSLT::xpath_to_string(fsrootsourcerel => $goupsrc),
		XML::LibXSLT::xpath_to_string(section => $section)
	);

	return $stylesheet->output_string($result);
#	return XML::LibXML::encodeToUTF8( "utf-8",	$stylesheet->output_string($result) );

}

sub xmltransindex {    # makes the xslt tranformation
	my $xml = shift;
	my $xsl = shift;

	my $parser = XML::LibXML->new();
	my $xslt   = XML::LibXSLT->new();

	my $source    = $parser->parse_string($xml);
	my $style_doc = $parser->parse_string($xsl);

	
	my $stylesheet = $xslt->parse_stylesheet($style_doc);

	my $result = $stylesheet->transform($source);

	return $stylesheet->output_string($result);
#	return XML::LibXML::encodeToUTF8( "utf-8",	$stylesheet->output_string($result) );

}


sub copyimages {
	for (keys(%img)) {
		($imgout = $_) =~ s/.*\/img\//$htmlpath\/img\//g;
		($imgin = $_) =~ s/.*\/img\//$imgpath\//g;
		&makedir($imgout);
		`cp $imgin $imgout`;
	}

}

sub copytemplates {
	`cp ${scriptpath}templates/css/$cssfile $htmlpath/$cssfile`;
	`cp ${scriptpath}templates/ooohelp.js $htmlpath/ooohelp.js`;
	`cp ${scriptpath}templates/index.html $htmlpath/index.html`;
	`cp ${scriptpath}templates/img/*.* $htmlpath/img/`;

	for $f(@{['main.html','top.html','start_index.html']}) {
		if (open HTML, "${scriptpath}templates/$f") {
			undef $/;
			$html = <HTML>;
			close HTML;
			$html =~ s/<!--%ProductName-->/$pn/gis;
			$html =~ s/<!--%ProductVersion-->/$pv/gis;
			
			if ($f eq 'top.html') {
				$html =~ s/<!--%([^>]+)StartPage-->/$startpage{$1}/gis;
			}
						
			if (open HTML, ">$htmlpath/$f") {
				print HTML $html;
			} else {
				die "\nCannot write output file $htmlpath/$f.";
			}
		} else {
			die "\nCannot open template file ${scriptpath}templates/$f.";
		}
	}
}

sub makedir {
	my @path;
	$targetdir = dirname(shift);
	return (-1) if (!($targetdir =~ /^\/.*$/));
	while (!($targetdir =~ /^\/$/))	{
		push @path, basename($targetdir);
		$targetdir = dirname($targetdir);
	}
	for $p (reverse(@path)) {
		$targetdir = $targetdir."/".$p;
		mkdir $targetdir if (!-e ($targetdir));
	}
}

sub mydie {
	my $msg = shift;
	print "$msg\n\n";
	$default_hcpath = "-none-" if ($default_hcpath eq '');
	$default_htmlpath = "-none-" if ($default_htmlpath eq '');
	$default_imgpath = "-none-" if ($default_imgpath eq '');
	$default_xslf = "-none-" if ($default_xslf eq '');
	print<<"USAGE";	
Usage:
perl help2html [-in <inputpath>] [-out <outputpath>] [-xsl <stylesheet>] [-ind <indexstylesheet>] [-img <imagepath>] [-pn <ProductName>} [-pv <ProductVersion>]

Default values
Input path:       $default_hcpath
Output path:      $default_htmlpath
Image Path:       $default_imgpath
XSL Stylesheet:   $default_xslf
Index Stylesheet: $default_xslindf
ProductName:      $default_pn
ProductVersion:   $default_pv

Note, that images reside in the default_images project.

USAGE
	die "\n";
}
