/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: axisgrid.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:07:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFX_HRC
#include <sfx2/sfx.hrc>
#endif
// header for SfxBoolItem
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
// header for SAL_STATIC_CAST
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#include "schdll.hxx"
#include "schresid.hxx"
#include "axisgrid.hxx"
#include "axisgrid.hrc"

//==============================
//
// SchAxisDlg
//
//==============================

SchAxisDlg::SchAxisDlg( Window* pWindow, const SfxItemSet& rInAttrs,
						BOOL b3D, BOOL bNet,
						BOOL bSecondaryX, BOOL bSecondaryY ) :
		ModalDialog( pWindow, SchResId( DLG_AXIS )),

		aFlPrimary( this, ResId( FL_PRIMARY_AXIS )),
		aCbPrimaryX( this, ResId( CB_X_PRIMARY )),
		aCbPrimaryY( this, ResId( CB_Y_PRIMARY )),
		aCbPrimaryZ( this, ResId( CB_Z_PRIMARY )),

		aFlSecondary( this, ResId( FL_SECONDARY_AXIS )),
		aCbSecondaryX( this, ResId( CB_X_SECONDARY )),
		aCbSecondaryY( this, ResId( CB_Y_SECONDARY )),

		aPbOK( this, ResId( PB_OK )),
		aPbCancel( this, ResId( PB_CANCEL )),
		aPbHelp( this, ResId( PB_HELP )),

		rOutAttrs( rInAttrs )
{
	FreeResource();

	aCbPrimaryX.Enable( !bNet );
	aCbSecondaryX.Enable( !bNet && bSecondaryX );
	aCbSecondaryY.Enable( bSecondaryY );
	aCbPrimaryZ.Enable( b3D );

	Reset();
}

SchAxisDlg::~SchAxisDlg()
{
}

//--------------------
// initialize
//--------------------

void SchAxisDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	if( aCbPrimaryX.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		bOldShowX = SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue();
		aCbPrimaryX.Check( bOldShowX );
	}
	
	if( aCbPrimaryY.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		bOldShowY = SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue();
		aCbPrimaryY.Check( bOldShowY );
	}

	if( aCbPrimaryZ.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_Z_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		bOldShowZ = SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue();
		aCbPrimaryZ.Check( bOldShowZ );
	}

	if( aCbSecondaryX.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_2X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		bOldShow2X = SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue();
		aCbSecondaryX.Check( bOldShow2X );
	}

	if( aCbSecondaryY.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_2Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		bOldShow2Y = SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue();
		aCbSecondaryY.Check( bOldShow2Y );
	}
}

//---------------------
// fill result item set
//---------------------

void SchAxisDlg::GetAttr(SfxItemSet& rOutAttrs)
{
	if( aCbPrimaryX.IsEnabled() &&
		bOldShowX != aCbPrimaryX.IsChecked() )
	{
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_AXIS,  aCbPrimaryX.IsChecked()) );
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_DESCR, aCbPrimaryX.IsChecked()) );
	}

	if( aCbPrimaryY.IsEnabled() &&
		bOldShowY != aCbPrimaryY.IsChecked() )
	{
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_AXIS,  aCbPrimaryY.IsChecked()) );
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_DESCR, aCbPrimaryY.IsChecked()) );
	}

	if( aCbPrimaryZ.IsEnabled()  &&
		bOldShowZ != aCbPrimaryZ.IsChecked() )
	{
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_AXIS,  aCbPrimaryZ.IsChecked()) );
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_DESCR, aCbPrimaryZ.IsChecked()) );
	}

	if( aCbSecondaryX.IsEnabled() &&
		bOldShow2X != aCbSecondaryX.IsChecked() )
	{
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2X_AXIS,  aCbSecondaryX.IsChecked()) );
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2X_DESCR, aCbSecondaryX.IsChecked()) );
	}

	if( aCbSecondaryY.IsEnabled() &&
		bOldShow2Y != aCbSecondaryY.IsChecked() )
	{
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2Y_AXIS,  aCbSecondaryY.IsChecked()) );
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2Y_DESCR, aCbSecondaryY.IsChecked()) );
	}
}

//==============================
//
// SchGridDlg
//
//==============================

SchGridDlg::SchGridDlg( Window* pWindow, const SfxItemSet& rInAttrs,
						BOOL b3D, BOOL bNet,
						BOOL bSecondaryX, BOOL bSecondaryY ) :
		ModalDialog( pWindow, SchResId( DLG_GRID )),

		aFlMain( this, ResId( FL_MAIN_GRID )),
		aCbMainX( this, ResId( CB_X_MAIN )),
		aCbMainY( this, ResId( CB_Y_MAIN )),
		aCbMainZ( this, ResId( CB_Z_MAIN )),

		aFlHelp( this, ResId( FL_HELP_GRID )),
		aCbHelpX( this, ResId( CB_X_HELP )),
		aCbHelpY( this, ResId( CB_Y_HELP )),
		aCbHelpZ( this, ResId( CB_Z_HELP )),

		aPbOK( this, ResId( PB_OK )),
		aPbCancel( this, ResId( PB_CANCEL )),
		aPbHelp( this, ResId( PB_HELP )),

		rOutAttrs( rInAttrs )
{
	FreeResource();

	aCbMainX.Enable( !bNet );
	aCbHelpX.Enable( !bNet );

	aCbMainZ.Enable( b3D );
	aCbHelpZ.Enable( b3D );

	Reset();
}

SchGridDlg::~SchGridDlg()
{
}

//--------------------
// initialize
//--------------------

void SchGridDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	// Note: the CHATTRs for X-grids contain Y and vice versa !
	if( aCbMainX.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_Y_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET )
		aCbMainX.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue() );

	if( aCbMainY.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_X_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET )
		aCbMainY.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue() );

	if( aCbMainZ.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_Z_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET )
		aCbMainZ.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue() );


	if( aCbHelpX.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_Y_HELP, TRUE, &pPoolItem) == SFX_ITEM_SET )
		aCbHelpX.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue() );

	if( aCbHelpY.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_X_HELP, TRUE, &pPoolItem) == SFX_ITEM_SET )
		aCbHelpY.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue() );

	if( aCbHelpZ.IsEnabled() &&
		rOutAttrs.GetItemState( CHATTR_AXISGRID_SHOW_Z_HELP, TRUE, &pPoolItem) == SFX_ITEM_SET )
		aCbHelpZ.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem)->GetValue() );
}

//---------------------
// fill result item set
//---------------------

void SchGridDlg::GetAttr(SfxItemSet& rOutAttrs)
{
	// Note: the CHATTRs for X-grids contain Y and vice versa !
	if( aCbMainX.IsEnabled() )
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_MAIN, aCbMainX.IsChecked()) );

	if( aCbMainY.IsEnabled() )
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_MAIN, aCbMainY.IsChecked()) );

	if( aCbMainZ.IsEnabled() )
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_MAIN, aCbMainZ.IsChecked()) );


	if( aCbHelpX.IsEnabled() )
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_HELP, aCbHelpX.IsChecked()) );

	if( aCbHelpY.IsEnabled() )
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_HELP, aCbHelpY.IsChecked()) );

	if( aCbHelpZ.IsEnabled() )
		rOutAttrs.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_HELP, aCbHelpZ.IsChecked()) );
}




